/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Semaphore;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.AbstractWorker;
import org.alfresco.solr.tracker.ActivatableTracker;
import org.alfresco.solr.tracker.Tracker;
import org.alfresco.solr.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTracker
extends ActivatableTracker {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ContentTracker.class);
    private static final int DEFAULT_CONTENT_TRACKER_MAX_PARALLELISM = 8;
    private int contentTrackerParallelism;
    private int contentUpdateBatchSize;
    private static final Map<String, Semaphore> RUN_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();
    private static final Map<String, Semaphore> WRITE_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();
    private ForkJoinPool forkJoinPool;

    @Override
    public Semaphore getWriteLock() {
        return WRITE_LOCK_BY_CORE.get(this.coreName);
    }

    @Override
    public Semaphore getRunLock() {
        return RUN_LOCK_BY_CORE.get(this.coreName);
    }

    public ContentTracker(Properties p, SOLRAPIClient client, String coreName, InformationServer informationServer) {
        super(p, client, coreName, informationServer, Tracker.Type.CONTENT);
        int DEFAULT_CONTENT_UPDATE_BATCH_SIZE = 2000;
        this.contentUpdateBatchSize = Integer.parseInt(p.getProperty("alfresco.contentUpdateBatchSize", String.valueOf(DEFAULT_CONTENT_UPDATE_BATCH_SIZE)));
        this.contentTrackerParallelism = Integer.parseInt(p.getProperty("alfresco.content.tracker.maxParallelism", String.valueOf(8)));
        this.forkJoinPool = new ForkJoinPool(this.contentTrackerParallelism);
        RUN_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
        WRITE_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
    }

    ContentTracker() {
        super(Tracker.Type.CONTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTrack(String iterationId) throws Exception {
        try {
            long startElapsed = System.nanoTime();
            this.checkShutdown();
            long totalDocs = 0L;
            this.checkShutdown();
            while (true) {
                try {
                    this.getWriteLock().acquire();
                    List<AlfrescoSolrDataModel.TenantDbId> docs = Utils.notNullOrEmpty(this.infoSrv.getDocsWithUncleanContent());
                    if (docs.isEmpty()) {
                        LOGGER.trace("No unclean document has been detected in the current ContentTracker cycle.");
                        break;
                    }
                    List docBatches = Lists.partition(docs, (int)this.contentUpdateBatchSize);
                    for (List batch : docBatches) {
                        Integer processedDocuments = (Integer)((ForkJoinTask)this.forkJoinPool.submit(() -> batch.parallelStream().map(doc -> {
                            ContentIndexWorkerRunnable ciwr = new ContentIndexWorkerRunnable((AlfrescoSolrDataModel.TenantDbId)doc, this.infoSrv);
                            ciwr.run();
                            return 1;
                        }).reduce(0, Integer::sum))).get();
                        long endElapsed = System.nanoTime();
                        this.trackerStats.addElapsedContentTime(processedDocuments.intValue(), endElapsed - startElapsed);
                        startElapsed = endElapsed;
                    }
                    totalDocs += (long)docs.size();
                    this.checkShutdown();
                    continue;
                }
                finally {
                    this.getWriteLock().release();
                    continue;
                }
                break;
            }
            LOGGER.info("{}-[CORE {}] Total number of docs with content updated: {} ", new Object[]{Thread.currentThread().getId(), this.coreName, totalDocs});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean hasMaintenance() {
        return false;
    }

    @Override
    public void maintenance() {
    }

    @Override
    public void invalidateState() {
        super.invalidateState();
        this.infoSrv.setCleanContentTxnFloor(-1L);
    }

    class ContentIndexWorkerRunnable
    extends AbstractWorker {
        InformationServer infoServer;
        AlfrescoSolrDataModel.TenantDbId docRef;

        ContentIndexWorkerRunnable(AlfrescoSolrDataModel.TenantDbId doc, InformationServer infoServer) {
            this.docRef = doc;
            this.infoServer = infoServer;
        }

        @Override
        protected void doWork() throws Exception {
            ContentTracker.this.checkShutdown();
            this.infoServer.updateContent(this.docRef);
        }

        @Override
        protected void onFail(Throwable failCausedBy) {
            LOGGER.warn("Content tracker failed due to {}", (Object)failCausedBy.getMessage(), (Object)failCausedBy);
        }
    }
}

