/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.util.PropertiesInputStream;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String COLLECTION_PROPS_FILE = "collection_state.json";
    public static final String BACKUP_PROPS_FILE = "backup.properties";
    public static final String ZK_STATE_DIR = "zk_backup";
    public static final String CONFIG_STATE_DIR = "configs";
    public static final String COLLECTION_NAME_PROP = "collection";
    public static final String BACKUP_NAME_PROP = "backupName";
    public static final String INDEX_VERSION_PROP = "index.version";
    public static final String START_TIME_PROP = "startTime";
    protected final ZkStateReader zkStateReader;
    protected final BackupRepository repository;

    public BackupManager(BackupRepository repository, ZkStateReader zkStateReader) {
        this.repository = Objects.requireNonNull(repository);
        this.zkStateReader = Objects.requireNonNull(zkStateReader);
    }

    public final String getVersion() {
        return "1.0";
    }

    public Properties readBackupProperties(URI backupLoc, String backupId) throws IOException {
        Objects.requireNonNull(backupLoc);
        Objects.requireNonNull(backupId);
        URI backupPath = this.repository.resolve(backupLoc, backupId);
        if (!this.repository.exists(backupPath)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't restore since doesn't exist: " + backupPath);
        }
        Properties props = new Properties();
        try (InputStreamReader is = new InputStreamReader((InputStream)new PropertiesInputStream(this.repository.openInput(backupPath, BACKUP_PROPS_FILE, IOContext.DEFAULT)), StandardCharsets.UTF_8);){
            props.load(is);
            Properties properties = props;
            return properties;
        }
    }

    public void writeBackupProperties(URI backupLoc, String backupId, Properties props) throws IOException {
        URI dest = this.repository.resolve(backupLoc, backupId, BACKUP_PROPS_FILE);
        try (OutputStreamWriter propsWriter = new OutputStreamWriter(this.repository.createOutput(dest), StandardCharsets.UTF_8);){
            props.store(propsWriter, "Backup properties file");
        }
    }

    public DocCollection readCollectionState(URI backupLoc, String backupId, String collectionName) throws IOException {
        Objects.requireNonNull(collectionName);
        URI zkStateDir = this.repository.resolve(backupLoc, backupId, ZK_STATE_DIR);
        try (IndexInput is = this.repository.openInput(zkStateDir, COLLECTION_PROPS_FILE, IOContext.DEFAULT);){
            byte[] arr = new byte[(int)is.length()];
            is.readBytes(arr, 0, (int)is.length());
            ClusterState c_state = ClusterState.load((Integer)-1, (byte[])arr, Collections.emptySet());
            DocCollection docCollection = c_state.getCollection(collectionName);
            return docCollection;
        }
    }

    public void writeCollectionState(URI backupLoc, String backupId, String collectionName, DocCollection collectionState) throws IOException {
        URI dest = this.repository.resolve(backupLoc, backupId, ZK_STATE_DIR, COLLECTION_PROPS_FILE);
        try (OutputStream collectionStateOs = this.repository.createOutput(dest);){
            collectionStateOs.write(Utils.toJSON(Collections.singletonMap(collectionName, collectionState)));
        }
    }

    public void uploadConfigDir(URI backupLoc, String backupId, String sourceConfigName, String targetConfigName) throws IOException {
        URI source = this.repository.resolve(backupLoc, backupId, ZK_STATE_DIR, CONFIG_STATE_DIR, sourceConfigName);
        String zkPath = "/configs/" + targetConfigName;
        this.uploadToZk(this.zkStateReader.getZkClient(), source, zkPath);
    }

    public void downloadConfigDir(URI backupLoc, String backupId, String configName) throws IOException {
        URI dest = this.repository.resolve(backupLoc, backupId, ZK_STATE_DIR, CONFIG_STATE_DIR, configName);
        this.repository.createDirectory(this.repository.resolve(backupLoc, backupId, ZK_STATE_DIR));
        this.repository.createDirectory(this.repository.resolve(backupLoc, backupId, ZK_STATE_DIR, CONFIG_STATE_DIR));
        this.repository.createDirectory(dest);
        this.downloadFromZK(this.zkStateReader.getZkClient(), "/configs/" + configName, dest);
    }

    private void downloadFromZK(SolrZkClient zkClient, String zkPath, URI dir) throws IOException {
        try {
            if (!this.repository.exists(dir)) {
                this.repository.createDirectory(dir);
            }
            List files = zkClient.getChildren(zkPath, null, true);
            for (String file : files) {
                List children = zkClient.getChildren(zkPath + "/" + file, null, true);
                if (children.size() == 0) {
                    log.info("Writing file {}", (Object)file);
                    byte[] data = zkClient.getData(zkPath + "/" + file, null, null, true);
                    OutputStream os = this.repository.createOutput(this.repository.resolve(dir, file));
                    try {
                        os.write(data);
                        continue;
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                        continue;
                    }
                }
                this.downloadFromZK(zkClient, zkPath + "/" + file, this.repository.resolve(dir, file));
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error downloading files from zookeeper path " + zkPath + " to " + dir.toString(), SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    private void uploadToZk(SolrZkClient zkClient, URI sourceDir, String destZkPath) throws IOException {
        Preconditions.checkArgument((boolean)this.repository.exists(sourceDir), (String)"Path {} does not exist", (Object)sourceDir);
        Preconditions.checkArgument((this.repository.getPathType(sourceDir) == BackupRepository.PathType.DIRECTORY ? 1 : 0) != 0, (String)"Path {} is not a directory", (Object)sourceDir);
        block11: for (String file : this.repository.listAll(sourceDir)) {
            String zkNodePath = destZkPath + "/" + file;
            URI path = this.repository.resolve(sourceDir, file);
            BackupRepository.PathType t = this.repository.getPathType(path);
            switch (t) {
                case FILE: {
                    try (IndexInput is = this.repository.openInput(sourceDir, file, IOContext.DEFAULT);){
                        byte[] arr = new byte[(int)is.length()];
                        is.readBytes(arr, 0, (int)is.length());
                        zkClient.makePath(zkNodePath, arr, true);
                        continue block11;
                    }
                    catch (InterruptedException | KeeperException e) {
                        throw new IOException(e);
                    }
                }
                case DIRECTORY: {
                    if (file.startsWith(".")) continue block11;
                    this.uploadToZk(zkClient, path, zkNodePath);
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("Unknown path type " + (Object)((Object)t));
                }
            }
        }
    }
}

