/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.util.Map;
import java.util.Objects;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.security.HadoopAuthPlugin;
import org.apache.solr.security.HttpClientInterceptorPlugin;

public class ConfigurableInternodeAuthHadoopPlugin
extends HadoopAuthPlugin
implements HttpClientInterceptorPlugin {
    private static final String HTTPCLIENT_BUILDER_FACTORY = "clientBuilderFactory";
    private HttpClientConfigurer factory = null;

    public ConfigurableInternodeAuthHadoopPlugin(CoreContainer coreContainer) {
        super(coreContainer);
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
        super.init(pluginConfig);
        String httpClientBuilderFactory = (String)Objects.requireNonNull(pluginConfig.get(HTTPCLIENT_BUILDER_FACTORY), "Please specify clientBuilderFactory to be used for Solr internal communication.");
        this.factory = this.coreContainer.getResourceLoader().newInstance(httpClientBuilderFactory, HttpClientConfigurer.class);
    }

    @Override
    public HttpClientConfigurer getClientConfigurer() {
        return this.factory;
    }
}

