/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.solr.common.EmptyEntityResolver;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.util.SystemIdResolver;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@SuppressForbidden(reason="This class uses XML APIs directly that should not be used anywhere else in Solr code")
public final class SafeXMLParsing {
    public static final String SYSTEMID_UNTRUSTED = "untrusted://stream";

    private SafeXMLParsing() {
    }

    public static Document parseConfigXML(Logger log, ResourceLoader loader, String file) throws SAXException, IOException {
        Document document;
        block10: {
            InputStream in = loader.openResource(file);
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setValidating(false);
                dbf.setNamespaceAware(true);
                SafeXMLParsing.trySetDOMFeature(dbf, "http://javax.xml.XMLConstants/feature/secure-processing", true);
                try {
                    dbf.setXIncludeAware(true);
                }
                catch (UnsupportedOperationException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "XML parser doesn't support XInclude option", (Throwable)e);
                }
                DocumentBuilder db = dbf.newDocumentBuilder();
                db.setEntityResolver(new SystemIdResolver(loader));
                db.setErrorHandler((ErrorHandler)new XMLErrorLogger(log));
                document = db.parse(in, SystemIdResolver.createSystemIdFromResourceName(file));
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException pce) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "XML parser cannot be configured", (Throwable)pce);
                }
            }
            in.close();
        }
        return document;
    }

    public static Document parseUntrustedXML(Logger log, InputStream in) throws SAXException, IOException {
        return SafeXMLParsing.getUntrustedDocumentBuilder(log).parse((InputStream)new CloseShieldInputStream(in), SYSTEMID_UNTRUSTED);
    }

    public static Document parseUntrustedXML(Logger log, Reader reader) throws SAXException, IOException {
        InputSource is = new InputSource(new FilterReader(reader){

            @Override
            public void close() {
            }
        });
        is.setSystemId(SYSTEMID_UNTRUSTED);
        return SafeXMLParsing.getUntrustedDocumentBuilder(log).parse(is);
    }

    public static Document parseUntrustedXML(Logger log, String xml) throws SAXException, IOException {
        return SafeXMLParsing.parseUntrustedXML(log, new StringReader(xml));
    }

    private static DocumentBuilder getUntrustedDocumentBuilder(Logger log) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            SafeXMLParsing.trySetDOMFeature(dbf, "http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(EmptyEntityResolver.SAX_INSTANCE);
            db.setErrorHandler((ErrorHandler)new XMLErrorLogger(log));
            return db;
        }
        catch (ParserConfigurationException pce) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "XML parser cannot be configured", (Throwable)pce);
        }
    }

    private static void trySetDOMFeature(DocumentBuilderFactory factory, String feature, boolean enabled) {
        try {
            factory.setFeature(feature, enabled);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

