/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import java.util.List;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.extensions.config.ConfigDeployer;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.source.UrlConfigSource;

public class ConfigBootstrap
implements BeanNameAware,
ConfigDeployer {
    private String beanName;
    protected ConfigService configService;
    protected List<String> configs;

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setConfigs(List<String> configs) {
        this.configs = configs;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    @Override
    public List<ConfigDeployment> initConfig() {
        List<ConfigDeployment> deployed = null;
        if (this.configService != null && this.configs != null && this.configs.size() != 0) {
            UrlConfigSource configSource = new UrlConfigSource(this.configs, true);
            deployed = this.configService.appendConfig(configSource);
        }
        return deployed;
    }

    @Override
    public void register() {
        if (this.configService == null) {
            throw new ConfigException("Config service must be provided");
        }
        this.configService.addDeployer(this);
    }

    @Override
    public String getSortKey() {
        return this.beanName;
    }
}

