/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config.source;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.source.BaseConfigSource;

public class ClassPathConfigSource
extends BaseConfigSource {
    private static Log logger = LogFactory.getLog(ClassPathConfigSource.class);

    public ClassPathConfigSource(String classpath) {
        this(Collections.singletonList(classpath));
    }

    public ClassPathConfigSource(List<String> sourceStrings) {
        super(sourceStrings);
    }

    @Override
    public InputStream getInputStream(String sourceString) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(sourceString);
        if (logger.isDebugEnabled()) {
            if (is == null) {
                logger.debug((Object)("Failed to obtain input stream to classpath: " + sourceString));
            } else {
                URL url = this.getClass().getClassLoader().getResource(sourceString);
                String location = url.toExternalForm();
                logger.debug((Object)("Loaded '" + sourceString + "' from: " + location));
            }
        }
        return is;
    }
}

