/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.transaction;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.GUID;
import org.alfresco.util.transaction.TransactionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class TransactionSupportUtil {
    private static Log logger = LogFactory.getLog(TransactionSupportUtil.class);
    private static final int SESSION_SYNCHRONIZATION_ORDER = 800;
    private static final String RESOURCE_KEY_TXN_SYNCH = "AlfrescoTransactionSupport.txnSynch";
    private static final String RESOURCE_KEY_TXN_ID = "AlfrescoTransactionSupport.txnId";
    private static final ThreadLocal<ResourcesHolder> txnResources = ThreadLocal.withInitial(() -> new ResourcesHolder(new HashMap<Object, Object>(3)));
    private static Comparator<Integer> FORWARD_INTEGER_ORDER = new Comparator<Integer>(){

        @Override
        public int compare(Integer arg0, Integer arg1) {
            return arg0 - arg1;
        }
    };
    private static Comparator<Integer> REVERSE_INTEGER_ORDER = new Comparator<Integer>(){

        @Override
        public int compare(Integer arg0, Integer arg1) {
            return arg1 - arg0;
        }
    };

    public static long getTransactionStartTime() {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            return TransactionSupportUtil.getSynchronization().getTransactionStartTime();
        }
        return -1L;
    }

    public static String getTransactionId() {
        return (String)TransactionSupportUtil.getResource(RESOURCE_KEY_TXN_ID);
    }

    public static boolean isActualTransactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public static <R> R getResource(Object key) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSupportUtil.getSynchronization();
        }
        Object resource = TransactionSupportUtil.txnResources.get().resources.get(key);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Fetched resource in " + TransactionSynchronizationManager.getCurrentTransactionName() + ": \n   key: " + key + "\n   resource: " + resource));
        }
        return (R)resource;
    }

    private static TransactionSynchronizationImpl registerSynchronization() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            Thread currentThread = Thread.currentThread();
            throw new AlfrescoRuntimeException("Transaction must be active and synchronization is required: " + currentThread);
        }
        String txnId = GUID.generate();
        TransactionSynchronizationImpl txnSynch = new TransactionSynchronizationImpl(txnId);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)txnSynch);
        ResourcesHolder resourcesHolder = txnResources.get();
        if (!resourcesHolder.resources.isEmpty()) {
            ResourcesHolder newResourcesHolder = new ResourcesHolder(resourcesHolder, new HashMap<Object, Object>(3));
            txnResources.set(newResourcesHolder);
        }
        Map<Object, Object> data = TransactionSupportUtil.txnResources.get().resources;
        data.put(RESOURCE_KEY_TXN_SYNCH, (Object)txnSynch);
        data.put(RESOURCE_KEY_TXN_ID, txnId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bound txn synch: " + txnSynch + " with txn name: " + TransactionSynchronizationManager.getCurrentTransactionName()));
        }
        return txnSynch;
    }

    private static TransactionSynchronizationImpl getSynchronization() {
        Map<Object, Object> data = TransactionSupportUtil.txnResources.get().resources;
        if (data.get(RESOURCE_KEY_TXN_SYNCH) != null) {
            return (TransactionSynchronizationImpl)((Object)data.get(RESOURCE_KEY_TXN_SYNCH));
        }
        return TransactionSupportUtil.registerSynchronization();
    }

    private static void suspendSynchronization() {
        ResourcesHolder currentResourcesHolder = txnResources.get();
        ResourcesHolder newResourcesHolder = new ResourcesHolder(currentResourcesHolder, new HashMap<Object, Object>(3));
        txnResources.set(newResourcesHolder);
    }

    private static void resumeSynchronization() {
        ResourcesHolder currentResourcesHolder = txnResources.get();
        ResourcesHolder previousResourcesHolder = currentResourcesHolder.previousResourceHolder;
        if (currentResourcesHolder.resources.isEmpty() && previousResourcesHolder != null) {
            txnResources.set(previousResourcesHolder);
        }
    }

    private static void clearResources() {
        ResourcesHolder previousResourcesHolder;
        ResourcesHolder currentResourcesHolder = txnResources.get();
        Map<Object, Object> txnData = currentResourcesHolder.resources;
        txnData.clear();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Clear txn resources for " + Thread.currentThread().getName()));
        }
        if ((previousResourcesHolder = currentResourcesHolder.previousResourceHolder) != null) {
            txnResources.set(previousResourcesHolder);
        }
    }

    public static void bindResource(Object key, Object resource) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSupportUtil.getSynchronization();
        }
        TransactionSupportUtil.txnResources.get().resources.put(key, resource);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Bound resource to " + TransactionSynchronizationManager.getCurrentTransactionName() + ": \n   key: " + key + "\n   resource: " + resource));
        }
    }

    public static void unbindResource(Object key) {
        TransactionSupportUtil.txnResources.get().resources.remove(key);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Unbound resource from " + TransactionSynchronizationManager.getCurrentTransactionName() + ": \n   key: " + key));
        }
    }

    public static boolean bindListener(TransactionListener listener, int priority) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bind Listener listener: " + listener + ", priority: " + priority));
        }
        TransactionSynchronizationImpl synch = TransactionSupportUtil.getSynchronization();
        return synch.addListener(listener, priority);
    }

    public static Set<TransactionListener> getListeners() {
        TransactionSynchronizationImpl txnSynch = TransactionSupportUtil.getSynchronization();
        return txnSynch.getListenersIterable();
    }

    private static class TransactionSynchronizationImpl
    extends TransactionSynchronizationAdapter {
        private long txnStartTime;
        private final String txnId;
        private final Map<Integer, Set<TransactionListener>> priorityLookup = new HashMap<Integer, Set<TransactionListener>>();

        public TransactionSynchronizationImpl(String txnId) {
            this.txnStartTime = System.currentTimeMillis();
            this.txnId = txnId;
            this.priorityLookup.put(0, new LinkedHashSet(5));
        }

        public long getTransactionStartTime() {
            return this.txnStartTime;
        }

        public boolean addListener(TransactionListener listener, int priority) {
            ParameterCheck.mandatory((String)"listener", (Object)listener);
            if (this.priorityLookup.containsKey(priority)) {
                Set<TransactionListener> listeners = this.priorityLookup.get(priority);
                return listeners.add(listener);
            }
            LinkedHashSet<TransactionListener> listeners = new LinkedHashSet<TransactionListener>(5);
            this.priorityLookup.put(priority, listeners);
            return listeners.add(listener);
        }

        private List<TransactionListener> getLevelZeroListenersIterable() {
            Set<TransactionListener> listeners = this.priorityLookup.get(0);
            return new ArrayList<TransactionListener>(listeners);
        }

        private Set<TransactionListener> getListenersIterable() {
            LinkedHashSet<TransactionListener> ret = new LinkedHashSet<TransactionListener>();
            Set<Map.Entry<Integer, Set<TransactionListener>>> entries = this.priorityLookup.entrySet();
            for (Map.Entry<Integer, Set<TransactionListener>> entry : entries) {
                ret.addAll(entry.getValue());
            }
            return ret;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append("TransactionSychronizationImpl").append("[ txnId=").append(this.txnId).append("]");
            return sb.toString();
        }

        public int getOrder() {
            return 800;
        }

        public void suspend() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Suspending transaction: " + this));
            }
            TransactionSupportUtil.suspendSynchronization();
        }

        public void resume() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resuming transaction: " + this));
            }
            TransactionSupportUtil.resumeSynchronization();
        }

        public void beforeCommit(boolean readOnly) {
            TransactionSynchronizationImpl synch;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Before commit " + (readOnly ? "read-only" : "") + this));
            }
            if ((synch = (TransactionSynchronizationImpl)((Object)TransactionSupportUtil.getResource(TransactionSupportUtil.RESOURCE_KEY_TXN_SYNCH))) == null) {
                throw new AlfrescoRuntimeException("No synchronization bound to thread");
            }
            logger.trace((Object)"Before Prepare - level 0");
            this.doBeforeCommit(readOnly);
            Set<Integer> priorities = this.priorityLookup.keySet();
            ConcurrentSkipListSet<Integer> sortedPriorities = new ConcurrentSkipListSet<Integer>(FORWARD_INTEGER_ORDER);
            sortedPriorities.addAll(priorities);
            sortedPriorities.remove(0);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Before Prepare priorities:" + sortedPriorities));
            }
            for (Integer priority : sortedPriorities) {
                Set<TransactionListener> listeners = this.priorityLookup.get(priority);
                for (TransactionListener listener : listeners) {
                    listener.beforeCommit(readOnly);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Prepared");
            }
        }

        private void doBeforeCommit(boolean readOnly) {
            this.doBeforeCommit(new HashSet<TransactionListener>(), readOnly);
        }

        private void doBeforeCommit(Set<TransactionListener> visitedListeners, boolean readOnly) {
            List<TransactionListener> pendingListeners = this.getLevelZeroListenersIterable();
            pendingListeners.removeAll(visitedListeners);
            if (pendingListeners.size() != 0) {
                for (TransactionListener listener : pendingListeners) {
                    listener.beforeCommit(readOnly);
                    visitedListeners.add(listener);
                }
                this.doBeforeCommit(visitedListeners, readOnly);
            }
        }

        public void beforeCompletion() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Before completion: " + this));
            }
            for (TransactionListener listener : this.getLevelZeroListenersIterable()) {
                listener.beforeCompletion();
            }
        }

        public void afterCompletion(int status) {
            TransactionSupportUtil.unbindResource(TransactionSupportUtil.RESOURCE_KEY_TXN_SYNCH);
            String statusStr = "unknown";
            switch (status) {
                case 0: {
                    statusStr = "committed";
                    break;
                }
                case 1: {
                    statusStr = "rolled-back";
                    break;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("After completion (" + statusStr + "): " + this));
            }
            Set<Integer> priorities = this.priorityLookup.keySet();
            ConcurrentSkipListSet<Integer> sortedPriorities = new ConcurrentSkipListSet<Integer>(REVERSE_INTEGER_ORDER);
            sortedPriorities.addAll(priorities);
            for (Integer priority : sortedPriorities) {
                HashSet listeners = new HashSet(this.priorityLookup.get(priority));
                for (TransactionListener listener : listeners) {
                    try {
                        if (status == 0) {
                            listener.afterCommit();
                            continue;
                        }
                        listener.afterRollback();
                    }
                    catch (RuntimeException e) {
                        logger.error((Object)("After completion (" + statusStr + ") exception"), (Throwable)e);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"After Completion: DONE");
            }
            TransactionSupportUtil.clearResources();
        }
    }

    private static class ResourcesHolder {
        @Nullable
        private ResourcesHolder previousResourceHolder;
        @NonNull
        private Map<Object, Object> resources;

        ResourcesHolder(ResourcesHolder previousResourceHolder, Map<Object, Object> resources) {
            this.previousResourceHolder = previousResourceHolder;
            this.resources = resources;
        }

        ResourcesHolder(Map<Object, Object> resources) {
            this(null, resources);
        }
    }
}

