/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.analysis.MLAnalayser;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MLAnalayserTest {
    private static final String PROPERTY_NAME = "@{http://www.alfresco.org/model/content/1.0}propertyName";
    private MLAnalayser analyser;
    @Mock
    private DictionaryService dictionaryService;
    private MLAnalysisMode mlAnalaysisMode = MLAnalysisMode.EXACT_COUNRTY;

    @Before
    public void setUp() throws Exception {
        this.analyser = new MLAnalayser(this.mlAnalaysisMode);
        PropertyDefinition propDef = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)this.dictionaryService.getProperty((QName)ArgumentMatchers.any(QName.class))).thenReturn((Object)propDef);
    }

    @Ignore
    @Test
    public void testTokenStreamForLanguageAndCountry() throws IOException {
        String inputStr = "\u0000fr_FR\u0000Ceci n'est pas Fran\u00e7aise";
        StringReader reader = new StringReader("\u0000fr_FR\u0000Ceci n'est pas Fran\u00e7aise");
        ArrayList<String> expectedTokens = new ArrayList<String>();
        expectedTokens.add("{fr_FR}ceci");
        expectedTokens.add("{fr_FR}n'est");
        expectedTokens.add("{fr_FR}pas");
        expectedTokens.add("{fr_FR}francaise");
        TokenStream ts = this.analyser.tokenStream(PROPERTY_NAME, (Reader)reader);
        this.verifyTokenStream(ts, expectedTokens);
    }

    @Ignore
    @Test
    public void testTokenStreamForLanguage() throws IOException {
        String inputStr = "\u0000fr\u0000Ceci n'est pas Fran\u00e7aise";
        StringReader reader = new StringReader("\u0000fr\u0000Ceci n'est pas Fran\u00e7aise");
        ArrayList<String> expectedTokens = new ArrayList<String>();
        expectedTokens.add("{fr}ceci");
        expectedTokens.add("{fr_CH}ceci");
        expectedTokens.add("{fr_LU}ceci");
        expectedTokens.add("{fr_FR}ceci");
        expectedTokens.add("{fr_BE}ceci");
        expectedTokens.add("{fr_CA}ceci");
        expectedTokens.add("{fr}n'est");
        expectedTokens.add("{fr_CH}n'est");
        expectedTokens.add("{fr_LU}n'est");
        expectedTokens.add("{fr_FR}n'est");
        expectedTokens.add("{fr_BE}n'est");
        expectedTokens.add("{fr_CA}n'est");
        expectedTokens.add("{fr}pas");
        expectedTokens.add("{fr_CH}pas");
        expectedTokens.add("{fr_LU}pas");
        expectedTokens.add("{fr_FR}pas");
        expectedTokens.add("{fr_BE}pas");
        expectedTokens.add("{fr_CA}pas");
        expectedTokens.add("{fr}francaise");
        expectedTokens.add("{fr_CH}francaise");
        expectedTokens.add("{fr_LU}francaise");
        expectedTokens.add("{fr_FR}francaise");
        expectedTokens.add("{fr_BE}francaise");
        expectedTokens.add("{fr_CA}francaise");
        TokenStream ts = this.analyser.tokenStream(PROPERTY_NAME, (Reader)reader);
        this.verifyTokenStream(ts, expectedTokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyTokenStream(TokenStream ts, List<String> expectedTokens) throws IOException {
        int expectedCount = expectedTokens.size();
        int count = 0;
        CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        try {
            ts.reset();
            while (ts.incrementToken()) {
                ++count;
                System.out.println("Token: " + termAtt.toString());
                if (expectedTokens.contains(termAtt.toString())) {
                    expectedTokens.remove(termAtt.toString());
                    continue;
                }
                Assert.fail((String)("Unexpected token: " + termAtt.toString()));
            }
            ts.end();
        }
        finally {
            ts.close();
        }
        Assert.assertEquals((String)"Incorrect number of tokens generated.", (long)expectedCount, (long)count);
    }
}

