/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.Collections;
import java.util.Optional;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AdminHandlerIT
extends AbstractAlfrescoSolrIT {
    static CoreAdminHandler admin;

    @BeforeClass
    public static void beforeClass() throws Exception {
        AdminHandlerIT.initAlfrescoCore("schema.xml");
        admin = AdminHandlerIT.getMultiCoreHandler();
    }

    @After
    public void clearQueue() {
        SOLRAPIQueueClient.NODE_META_DATA_MAP.clear();
        SOLRAPIQueueClient.TRANSACTION_QUEUE.clear();
        SOLRAPIQueueClient.ACL_CHANGE_SET_QUEUE.clear();
        SOLRAPIQueueClient.ACL_READERS_MAP.clear();
        SOLRAPIQueueClient.ACL_MAP.clear();
        SOLRAPIQueueClient.NODE_MAP.clear();
        SOLRAPIQueueClient.NODE_CONTENT_MAP.clear();
        this.clearIndex();
        this.assertU(AdminHandlerIT.commit(new String[0]));
    }

    @Test(expected=SolrException.class)
    public void testUnhandled() throws Exception {
        SolrQueryResponse resp = new SolrQueryResponse();
        admin.handleRequestBody(AdminHandlerIT.req("action", "totalnonsense", "name", AdminHandlerIT.getCore().getName()), resp);
    }

    @Test
    public void testhandledCores() throws Exception {
        this.requestAction("newCore");
        this.requestAction("updateCore");
        this.requestAction("removeCore");
    }

    @Test
    public void nodeReportOnMasterOrStandaloneContainsTxInfo() throws Exception {
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Collections.singletonList(acl), Collections.singletonList(AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null)));
        BooleanQuery waitForQuery = new BooleanQuery.Builder().add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST)).add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST)).build();
        AdminHandlerIT.waitForDocCount((Query)waitForQuery, 1L, AlfrescoSolrUtils.MAX_WAIT_TIME);
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 4);
        Node node = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData nodeMetadata = AlfrescoSolrUtils.getNodeMetaData(node, txn, acl, "mike", null, false);
        AdminHandlerIT.indexTransaction(txn, Collections.singletonList(node), Collections.singletonList(nodeMetadata));
        this.makeSureTransactionHasBeenIndexed(txn.getId());
        SolrQueryRequest request = AdminHandlerIT.req("action", "nodereport", "name", AdminHandlerIT.getCore().getName());
        ModifiableSolrParams params = new ModifiableSolrParams(request.getParams()).set("nodeid", new String[]{Long.toString(node.getId())});
        request.setParams((SolrParams)params);
        SolrQueryResponse response = new SolrQueryResponse();
        admin.handleRequestBody(request, response);
        NamedList data = response.getValues();
        NamedList report = Optional.ofNullable(data.get("report")).map(NamedList.class::cast).orElseThrow(() -> new AssertionError((Object)("'report' section not in response. Response was " + String.valueOf(data))));
        NamedList collection = Optional.of(report.get("collection1")).map(NamedList.class::cast).orElseThrow(() -> new AssertionError((Object)("'collection' section not in response. Response was " + String.valueOf(data))));
        Optional.of(collection.get("Node DBID")).map(Long.class::cast).filter(dbid -> node.getId() == dbid.longValue()).orElseThrow(() -> new AssertionError((Object)("'Node DBID' mismatch or not found. Expected '" + node.getId() + "'Response was " + String.valueOf(data))));
        Optional.of(collection.get("DB TX")).map(Long.class::cast).filter(dbtx -> txn.getId() == dbtx.longValue()).orElseThrow(() -> new AssertionError((Object)("'DB TX' mismatch or not found. Expected '" + txn.getId() + "' Response was " + String.valueOf(data))));
        Optional.of(collection.get("DB TX Status")).map(String.class::cast).filter("UPDATED"::equals).orElseThrow(() -> new AssertionError((Object)("'DB TX' mismatch or not found. Expected 'UPDATED', Response was " + String.valueOf(data))));
    }

    @Test
    public void testhandledReports() throws Exception {
        this.requestAction("CHECK");
        this.requestAction("REPORT");
        this.requestAction("SUMMARY");
    }

    private void requestAction(String actionName) throws Exception {
        admin.handleRequestBody(AdminHandlerIT.req("action", actionName, "name", AdminHandlerIT.getCore().getName()), new SolrQueryResponse());
    }

    private void makeSureTransactionHasBeenIndexed(long transactionId) throws Exception {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!TX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_TXID", (Long)transactionId, (Long)(transactionId + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        AdminHandlerIT.waitForDocCount((Query)waitForQuery, 1L, AlfrescoSolrUtils.MAX_WAIT_TIME);
    }
}

