/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.index.shard.ShardState;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.SolrInformationServer;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.ContentPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.alfresco.util.ISO9075;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.junit.Assert;
import org.springframework.extensions.surf.util.I18NUtil;

public class AlfrescoSolrUtils {
    public static final String TEST_NAMESPACE = "http://www.alfresco.org/test/solrtest";
    public static long MAX_WAIT_TIME = 80000L;
    public static Random RANDOMIZER = new Random();
    private static AtomicLong id = new AtomicLong(System.currentTimeMillis());

    public static Transaction getTransaction(int deletes, int updates) {
        return AlfrescoSolrUtils.getTransaction(deletes, updates, AlfrescoSolrUtils.generateId());
    }

    public static Transaction getTransaction(int deletes, int updates, long id) {
        return AlfrescoSolrUtils.getTransaction(deletes, updates, id, System.currentTimeMillis());
    }

    public static Transaction getTransaction(int deletes, int updates, long id, long timestamp) {
        long txnCommitTime = timestamp;
        Transaction transaction = new Transaction();
        transaction.setCommitTimeMs(txnCommitTime);
        transaction.setId(id);
        transaction.setDeletes((long)deletes);
        transaction.setUpdates((long)updates);
        return transaction;
    }

    public static int randomShardCountGreaterThanOne() {
        return AlfrescoSolrUtils.randomPositiveInteger() + 2;
    }

    public static int randomPositiveInteger() {
        return RANDOMIZER.nextInt(100);
    }

    public static Node getNode(Transaction txn, Acl acl, Node.SolrApiNodeStatus status) {
        Node node = new Node();
        node.setTxnId(txn.getId());
        node.setId(AlfrescoSolrUtils.generateId().longValue());
        node.setAclId(acl.getId());
        node.setStatus(status);
        return node;
    }

    public static Node getNode(long nodeId, Transaction txn, Acl acl, Node.SolrApiNodeStatus status) {
        Node node = new Node();
        node.setTxnId(txn.getId());
        node.setId(nodeId);
        node.setAclId(acl.getId());
        node.setStatus(status);
        return node;
    }

    public static NodeMetaData getNodeMetaData(Node node, Transaction txn, Acl acl, String owner, Set<NodeRef> ancestors, boolean createError) {
        NodeMetaData nodeMetaData = new NodeMetaData();
        nodeMetaData.setId(node.getId());
        nodeMetaData.setAclId(acl.getId());
        nodeMetaData.setTxnId(txn.getId());
        nodeMetaData.setOwner(owner);
        nodeMetaData.setAspects(new HashSet());
        nodeMetaData.setAncestors(ancestors);
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(ContentModel.PROP_IS_INDEXED, new StringPropertyValue("true"));
        props.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.US, 0L, "UTF-8", "text/plain", null));
        nodeMetaData.setProperties(props);
        if (!createError) {
            NodeRef nodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), AlfrescoSolrUtils.createGUID());
            nodeMetaData.setNodeRef(nodeRef);
        }
        nodeMetaData.setType(QName.createQName((String)TEST_NAMESPACE, (String)"testSuperType"));
        nodeMetaData.setAncestors(ancestors);
        nodeMetaData.setPaths(new ArrayList());
        nodeMetaData.setNamePaths(new ArrayList());
        return nodeMetaData;
    }

    public static String createGUID() {
        long id = AlfrescoSolrUtils.generateId();
        return "00000000-0000-" + id / 1000000000000L % 10000L + "-" + id / 100000000L % 10000L + "-" + id % 100000000L;
    }

    public static Set<NodeRef> ancestors(NodeRef ... refs) {
        HashSet<NodeRef> set = new HashSet<NodeRef>();
        for (NodeRef ref : refs) {
            set.add(ref);
        }
        return set;
    }

    public void indexTransaction(Transaction transaction, List<Node> nodes, List<NodeMetaData> nodeMetaDatas) {
        SOLRAPIQueueClient.NODE_MAP.put(transaction.getId(), nodes);
        for (NodeMetaData nodeMetaData : nodeMetaDatas) {
            SOLRAPIQueueClient.NODE_META_DATA_MAP.put(nodeMetaData.getId(), nodeMetaData);
        }
        SOLRAPIQueueClient.TRANSACTION_QUEUE.add(transaction);
    }

    public static Acl getAcl(AclChangeSet aclChangeSet) {
        Acl acl = new Acl(aclChangeSet.getId(), AlfrescoSolrUtils.generateId().longValue());
        return acl;
    }

    public static Acl getAcl(AclChangeSet aclChangeSet, long aclId) {
        Acl acl = new Acl(aclChangeSet.getId(), aclId);
        return acl;
    }

    public static AclChangeSet getAclChangeSet(int aclCount) {
        return new AclChangeSet(AlfrescoSolrUtils.generateId().longValue(), System.currentTimeMillis(), aclCount);
    }

    public static AclChangeSet getAclChangeSet(int aclCount, long id) {
        return new AclChangeSet(id, System.currentTimeMillis(), aclCount);
    }

    public static AclChangeSet getAclChangeSet(int aclCount, long id, long timestamp) {
        return new AclChangeSet(id, timestamp, aclCount);
    }

    private static synchronized Long generateId() {
        return id.incrementAndGet();
    }

    public static String add(SolrTestCaseJ4.XmlDoc doc, String ... args) {
        try {
            StringWriter r = new StringWriter();
            if (null == args || 0 == args.length) {
                r.write("<add>");
                r.write(doc.xml);
                r.write("</add>");
            } else {
                XML.writeUnescapedXML((Writer)r, (String)"add", (String)doc.xml, (Object[])args);
            }
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static AclReaders getAclReaders(AclChangeSet aclChangeSet, Acl acl, List<String> readers, List<String> denied, String tenant) {
        if (tenant == null) {
            tenant = "";
        }
        return new AclReaders(acl.getId(), readers, denied, aclChangeSet.getId(), tenant);
    }

    public static void indexAclChangeSet(AclChangeSet aclChangeSet, List<Acl> aclList, List<AclReaders> aclReadersList) {
        SOLRAPIQueueClient.ACL_MAP.put(aclChangeSet.getId(), aclList);
        for (AclReaders aclReaders : aclReadersList) {
            SOLRAPIQueueClient.ACL_READERS_MAP.put(aclReaders.getId(), aclReaders);
        }
        SOLRAPIQueueClient.ACL_CHANGE_SET_QUEUE.add(aclChangeSet);
    }

    public static List list(Object ... strings) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object s : strings) {
            list.add(s);
        }
        return list;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    public static Map map(Object ... params) {
        LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < params.length; i += 2) {
            ret.put(params[i], params[i + 1]);
        }
        return ret;
    }

    public static NodeRef addNode(SolrCore core, AlfrescoSolrDataModel dataModel, int txid, int dbid, int aclid, QName type, QName[] aspects, Map<QName, PropertyValue> properties, Map<QName, String> content, String owner, ChildAssociationRef[] parentAssocs, NodeRef[] ancestors, String[] paths, NodeRef nodeRef, boolean commit) {
        try (AbstractAlfrescoSolrIT.SolrServletRequest solrQueryRequest = null;){
            AlfrescoCoreAdminHandler admin = (AlfrescoCoreAdminHandler)core.getCoreContainer().getMultiCoreHandler();
            SolrInformationServer solrInformationServer = (SolrInformationServer)admin.getInformationServers().get(core.getName());
            solrQueryRequest = new AbstractAlfrescoSolrIT.SolrServletRequest(core, null);
            AddUpdateCommand addDocCmd = new AddUpdateCommand((SolrQueryRequest)solrQueryRequest);
            addDocCmd.overwrite = true;
            addDocCmd.solrDoc = AlfrescoSolrUtils.createDocument(dataModel, new Long(txid), new Long(dbid), nodeRef, type, aspects, properties, content, new Long(aclid), paths, owner, parentAssocs, ancestors, solrInformationServer);
            core.getUpdateHandler().addDoc(addDocCmd);
            if (commit) {
                core.getUpdateHandler().commit(new CommitUpdateCommand((SolrQueryRequest)solrQueryRequest, false));
            }
        }
        return nodeRef;
    }

    public static SolrInputDocument createDocument(AlfrescoSolrDataModel dataModel, Long txid, Long dbid, NodeRef nodeRef, QName type, QName[] aspects, Map<QName, PropertyValue> properties, Map<QName, String> content, Long aclId, String[] paths, String owner, ChildAssociationRef[] parentAssocs, NodeRef[] ancestors, SolrInformationServer solrInformationServer) {
        int n;
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        String id = AlfrescoSolrDataModel.getNodeDocumentId((String)"_DEFAULT_", (Long)dbid);
        doc.addField("id", (Object)id);
        doc.addField("_version_", (Object)0);
        doc.addField("DBID", (Object)("" + dbid));
        doc.addField("LID", (Object)String.valueOf(nodeRef));
        doc.addField("INTXID", (Object)("" + txid));
        doc.addField("ACLID", (Object)("" + aclId));
        doc.addField("DOC_TYPE", (Object)"Node");
        if (paths != null) {
            for (String path : paths) {
                doc.addField("PATH", (Object)path);
            }
        }
        if (owner != null) {
            doc.addField("OWNER", (Object)owner);
        }
        doc.addField("PARENTASSOCCRC", (Object)"0");
        StringBuilder qNameBuffer = new StringBuilder(64);
        StringBuilder assocTypeQNameBuffer = new StringBuilder(64);
        if (parentAssocs != null) {
            ChildAssociationRef[] childAssociationRefArray = parentAssocs;
            int path = childAssociationRefArray.length;
            for (n = 0; n < path; ++n) {
                ChildAssociationRef childAssocRef = childAssociationRefArray[n];
                if (qNameBuffer.length() > 0) {
                    qNameBuffer.append(";/");
                    assocTypeQNameBuffer.append(";/");
                }
                qNameBuffer.append(ISO9075.getXPathName((QName)childAssocRef.getQName()));
                assocTypeQNameBuffer.append(ISO9075.getXPathName((QName)childAssocRef.getTypeQName()));
                doc.addField("PARENT", Optional.ofNullable(childAssocRef.getParentRef()).map(Object::toString).orElse(null));
                if (!childAssocRef.isPrimary()) continue;
                doc.addField("PRIMARYPARENT", Optional.ofNullable(childAssocRef.getParentRef()).map(Object::toString).orElse(null));
                doc.addField("PRIMARYASSOCTYPEQNAME", (Object)ISO9075.getXPathName((QName)childAssocRef.getTypeQName()));
                doc.addField("PRIMARYASSOCQNAME", (Object)ISO9075.getXPathName((QName)childAssocRef.getQName()));
            }
            doc.addField("ASSOCTYPEQNAME", (Object)assocTypeQNameBuffer.toString());
            doc.addField("QNAME", (Object)qNameBuffer.toString());
        }
        if (ancestors != null) {
            NodeRef[] nodeRefArray = ancestors;
            int path = nodeRefArray.length;
            for (n = 0; n < path; ++n) {
                NodeRef ancestor = nodeRefArray[n];
                doc.addField("ANCESTOR", (Object)ancestor.toString());
            }
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (NodeRef ancestor : ancestors) {
                builder.append('/').append(ancestor.getId());
                doc.addField("APATH", (Object)(i++ + builder.toString()));
            }
            if (builder.length() > 0) {
                doc.addField("APATH", (Object)("F" + builder.toString()));
            }
            builder = new StringBuilder();
            for (int j = 0; j < ancestors.length; ++j) {
                NodeRef element = ancestors[ancestors.length - 1 - j];
                builder.insert(0, element.getId());
                builder.insert(0, '/');
                doc.addField("ANAME", (Object)(j + builder.toString()));
            }
            if (builder.length() > 0) {
                doc.addField("ANAME", (Object)("F" + builder.toString()));
            }
        }
        if (properties != null) {
            boolean isContentIndexedForNode = true;
            boolean transformContentFlag = true;
            solrInformationServer.populateProperties(properties, true, doc, true);
            if (content != null) {
                AlfrescoSolrUtils.addContentToDoc(doc, content);
            }
        }
        doc.addField("TYPE", (Object)String.valueOf(type));
        if (aspects != null) {
            for (QName aspect : aspects) {
                doc.addField("ASPECT", (Object)String.valueOf(aspect));
            }
        }
        doc.addField("ISNODE", (Object)"T");
        doc.addField("TENANT", (Object)"_DEFAULT_");
        return doc;
    }

    private static void addContentToDoc(SolrInputDocument doc, Map<QName, String> content) {
        AlfrescoSolrDataModel dataModel = AlfrescoSolrDataModel.getInstance();
        Locale locale = I18NUtil.getLocale();
        content.forEach((propertyQName, textContent) -> {
            String storedField = dataModel.getStoredContentField(propertyQName);
            doc.setField(storedField, (Object)("\u0000" + locale.toString() + "\u0000" + textContent));
        });
    }

    private static void addContentPropertyToDoc(SolrInputDocument cachedDoc, QName propertyQName, String locale, Map<QName, String> content) {
        StringBuilder builder = new StringBuilder();
        builder.append("\u0000").append(locale).append("\u0000");
        builder.append(content.get(propertyQName));
        for (AlfrescoSolrDataModel.FieldInstance field : AlfrescoSolrDataModel.getInstance().getIndexedFieldNamesForProperty(propertyQName).getFields()) {
            cachedDoc.removeField(field.getField());
            if (field.isLocalised()) {
                cachedDoc.addField(field.getField(), (Object)builder.toString());
                continue;
            }
            cachedDoc.addField(field.getField(), (Object)content.get(propertyQName));
        }
    }

    public static void addAcl(SolrCore core, AlfrescoSolrDataModel dataModel, int acltxid, int aclId, int maxReader, int totalReader) throws IOException {
        AbstractAlfrescoSolrIT.SolrServletRequest solrQueryRequest = new AbstractAlfrescoSolrIT.SolrServletRequest(core, null);
        AddUpdateCommand aclTxCmd = new AddUpdateCommand((SolrQueryRequest)solrQueryRequest);
        aclTxCmd.overwrite = true;
        SolrInputDocument aclTxSol = new SolrInputDocument(new String[0]);
        String aclTxId = AlfrescoSolrDataModel.getAclChangeSetDocumentId((Long)new Long(acltxid));
        aclTxSol.addField("id", (Object)aclTxId);
        aclTxSol.addField("_version_", (Object)"0");
        aclTxSol.addField("ACLTXID", (Object)acltxid);
        aclTxSol.addField("INACLTXID", (Object)acltxid);
        aclTxSol.addField("ACLTXCOMMITTIME", (Object)new Date().getTime());
        aclTxSol.addField("DOC_TYPE", (Object)"AclTx");
        aclTxCmd.solrDoc = aclTxSol;
        core.getUpdateHandler().addDoc(aclTxCmd);
        AddUpdateCommand aclCmd = new AddUpdateCommand((SolrQueryRequest)solrQueryRequest);
        aclCmd.overwrite = true;
        SolrInputDocument aclSol = new SolrInputDocument(new String[0]);
        String aclDocId = AlfrescoSolrDataModel.getAclDocumentId((String)"_DEFAULT_", (Long)new Long(aclId));
        aclSol.addField("id", (Object)aclDocId);
        aclSol.addField("_version_", (Object)"0");
        aclSol.addField("ACLID", (Object)aclId);
        aclSol.addField("INACLTXID", (Object)("" + acltxid));
        aclSol.addField("READER", (Object)"GROUP_EVERYONE");
        aclSol.addField("READER", (Object)"pig");
        for (int i = 0; i <= maxReader; ++i) {
            aclSol.addField("READER", (Object)("READER-" + (totalReader - i)));
        }
        aclSol.addField("DENIED", (Object)"something");
        aclSol.addField("DOC_TYPE", (Object)"Acl");
        aclCmd.solrDoc = aclSol;
        core.getUpdateHandler().addDoc(aclCmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStoreRoot(SolrCore core, AlfrescoSolrDataModel dataModel, NodeRef rootNodeRef, int txid, int dbid, int acltxid, int aclid) throws IOException {
        try (AbstractAlfrescoSolrIT.SolrServletRequest solrQueryRequest = null;){
            AlfrescoCoreAdminHandler admin = (AlfrescoCoreAdminHandler)core.getCoreContainer().getMultiCoreHandler();
            SolrInformationServer solrInformationServer = (SolrInformationServer)admin.getInformationServers().get(core.getName());
            solrQueryRequest = new AbstractAlfrescoSolrIT.SolrServletRequest(core, null);
            AddUpdateCommand addDocCmd = new AddUpdateCommand((SolrQueryRequest)solrQueryRequest);
            addDocCmd.overwrite = true;
            addDocCmd.solrDoc = AlfrescoSolrUtils.createDocument(dataModel, new Long(txid), new Long(dbid), rootNodeRef, ContentModel.TYPE_STOREROOT, new QName[]{ContentModel.ASPECT_ROOT}, null, null, new Long(aclid), new String[]{"/"}, "system", null, null, solrInformationServer);
            core.getUpdateHandler().addDoc(addDocCmd);
            AlfrescoSolrUtils.addAcl((SolrQueryRequest)solrQueryRequest, core, dataModel, acltxid, aclid, 0, 0);
            AddUpdateCommand txCmd = new AddUpdateCommand((SolrQueryRequest)solrQueryRequest);
            txCmd.overwrite = true;
            SolrInputDocument input = new SolrInputDocument(new String[0]);
            String id = AlfrescoSolrDataModel.getTransactionDocumentId((Long)new Long(txid));
            input.addField("id", (Object)id);
            input.addField("_version_", (Object)"0");
            input.addField("TXID", (Object)txid);
            input.addField("INTXID", (Object)txid);
            input.addField("TXCOMMITTIME", (Object)new Date().getTime());
            input.addField("DOC_TYPE", (Object)"Tx");
            txCmd.solrDoc = input;
            core.getUpdateHandler().addDoc(txCmd);
            core.getUpdateHandler().commit(new CommitUpdateCommand((SolrQueryRequest)solrQueryRequest, false));
        }
    }

    public static void addAcl(SolrQueryRequest solrQueryRequest, SolrCore core, AlfrescoSolrDataModel dataModel, int acltxid, int aclId, int maxReader, int totalReader) throws IOException {
        AddUpdateCommand aclTxCmd = new AddUpdateCommand(solrQueryRequest);
        aclTxCmd.overwrite = true;
        SolrInputDocument aclTxSol = new SolrInputDocument(new String[0]);
        String aclTxId = AlfrescoSolrDataModel.getAclChangeSetDocumentId((Long)new Long(acltxid));
        aclTxSol.addField("id", (Object)aclTxId);
        aclTxSol.addField("_version_", (Object)"0");
        aclTxSol.addField("ACLTXID", (Object)acltxid);
        aclTxSol.addField("INACLTXID", (Object)acltxid);
        aclTxSol.addField("ACLTXCOMMITTIME", (Object)new Date().getTime());
        aclTxSol.addField("DOC_TYPE", (Object)"AclTx");
        aclTxCmd.solrDoc = aclTxSol;
        core.getUpdateHandler().addDoc(aclTxCmd);
        AddUpdateCommand aclCmd = new AddUpdateCommand(solrQueryRequest);
        aclCmd.overwrite = true;
        SolrInputDocument aclSol = new SolrInputDocument(new String[0]);
        String aclDocId = AlfrescoSolrDataModel.getAclDocumentId((String)"_DEFAULT_", (Long)new Long(aclId));
        aclSol.addField("id", (Object)aclDocId);
        aclSol.addField("_version_", (Object)"0");
        aclSol.addField("ACLID", (Object)aclId);
        aclSol.addField("INACLTXID", (Object)("" + acltxid));
        aclSol.addField("READER", (Object)"GROUP_EVERYONE");
        aclSol.addField("READER", (Object)"pig");
        for (int i = 0; i <= maxReader; ++i) {
            aclSol.addField("READER", (Object)("READER-" + (totalReader - i)));
        }
        aclSol.addField("DENIED", (Object)"something");
        aclSol.addField("DOC_TYPE", (Object)"Acl");
        aclCmd.solrDoc = aclSol;
        core.getUpdateHandler().addDoc(aclCmd);
    }

    public static SolrCore getCore(CoreContainer coreContainer, String coreName) {
        return coreContainer.getCores().stream().filter(aCore -> coreName.equals(aCore.getName())).findFirst().get();
    }

    public static SolrCore createCoreUsingTemplate(CoreContainer coreContainer, AlfrescoCoreAdminHandler coreAdminHandler, String coreName, String templateName, int shards, int nodes, String ... extraParams) throws InterruptedException {
        SolrCore testingCore = null;
        ModifiableSolrParams coreParams = AlfrescoSolrUtils.params("action", "newcore", "storeRef", "workspace://SpacesStore", "coreName", coreName, "numShards", String.valueOf(shards), "nodeInstance", String.valueOf(nodes), "template", templateName);
        coreParams.add((SolrParams)AlfrescoSolrUtils.params(extraParams));
        LocalSolrQueryRequest request = new LocalSolrQueryRequest(null, (SolrParams)coreParams);
        SolrQueryResponse response = new SolrQueryResponse();
        coreAdminHandler.handleCustomAction((SolrQueryRequest)request, response);
        TimeUnit.SECONDS.sleep(1L);
        if (shards > 1) {
            NamedList action = (NamedList)response.getValues().get("action");
            List coreNames = action.getAll("core");
            Assert.assertEquals((long)shards, (long)coreNames.size());
            testingCore = AlfrescoSolrUtils.getCore(coreContainer, (String)coreNames.get(0));
        } else {
            NamedList action = (NamedList)response.getValues().get("action");
            Assert.assertEquals((Object)coreName, (Object)action.get("core"));
            testingCore = AlfrescoSolrUtils.getCore(coreContainer, coreName);
        }
        TimeUnit.SECONDS.sleep(4L);
        TestCase.assertNotNull((Object)testingCore);
        return testingCore;
    }

    public static void assertSummaryCorrect(SolrQueryResponse response, String coreName) {
        NamedList summary = (NamedList)response.getValues().get("Summary");
        TestCase.assertNotNull((Object)summary);
        NamedList coreSummary = (NamedList)summary.get(coreName);
        TestCase.assertNotNull((Object)coreSummary);
        TestCase.assertTrue((String)("There must be a searcher for " + coreName), ((Integer)coreSummary.get("Number of Searchers") > 0 ? 1 : 0) != 0);
    }

    public static void assertShardAndCoreSummaryConsistency(ShardState state, SolrCore core) {
        ModifiableSolrParams params = new ModifiableSolrParams().add("core", new String[]{core.getName()}).add("action", new String[]{"SUMMARY"});
        LocalSolrQueryRequest request = new LocalSolrQueryRequest(core, (SolrParams)params);
        SolrQueryResponse response = new SolrQueryResponse();
        AlfrescoSolrUtils.coreAdminHandler(core).handleRequest((SolrQueryRequest)request, response);
        NamedList summary = Optional.ofNullable(response.getValues()).map(values -> values.get("Summary")).map(NamedList.class::cast).map(values -> values.get(core.getName())).map(NamedList.class::cast).orElseGet(NamedList::new);
        Assert.assertEquals((Object)state.getLastIndexedChangeSetId(), (Object)summary.get("Id for last Change Set in index"));
        Assert.assertEquals((Object)state.getLastIndexedChangeSetCommitTime(), (Object)summary.get("Last Index Change Set Commit Time"));
        Assert.assertEquals((Object)state.getLastIndexedTxCommitTime(), (Object)summary.get("Last Index TX Commit Time"));
        Assert.assertEquals((Object)state.getLastIndexedTxId(), (Object)summary.get("Id for last TX in index"));
    }

    public static AlfrescoCoreAdminHandler coreAdminHandler(SolrCore core) {
        return Optional.of(core).map(SolrCore::getCoreContainer).map(CoreContainer::getMultiCoreHandler).map(AlfrescoCoreAdminHandler.class::cast).orElseThrow(() -> new IllegalStateException("Cannot retrieve the Core Admin Handler on this test core."));
    }

    public static class TestActChanges {
        private AclChangeSet aclChangeSet;
        private Acl acl;
        private Acl acl2;

        public AclChangeSet getChangeSet() {
            return this.aclChangeSet;
        }

        public Acl getFirstAcl() {
            return this.acl;
        }

        public Acl getSecondAcl() {
            return this.acl2;
        }

        public TestActChanges createBasicTestData() {
            this.aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
            this.acl = AlfrescoSolrUtils.getAcl(this.aclChangeSet);
            this.acl2 = AlfrescoSolrUtils.getAcl(this.aclChangeSet);
            AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(this.aclChangeSet, this.acl, AlfrescoSolrUtils.list("joel"), AlfrescoSolrUtils.list("phil"), null);
            AclReaders aclReaders2 = AlfrescoSolrUtils.getAclReaders(this.aclChangeSet, this.acl2, AlfrescoSolrUtils.list("jim"), AlfrescoSolrUtils.list("phil"), null);
            AlfrescoSolrUtils.indexAclChangeSet(this.aclChangeSet, AlfrescoSolrUtils.list(this.acl, this.acl2), AlfrescoSolrUtils.list(aclReaders, aclReaders2));
            return this;
        }
    }
}

