/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.apache.commons.io.FileUtils;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class CoresCreateUpdateDistributedIT
extends AbstractAlfrescoDistributedIT {
    String testFolder;

    @Before
    public void initData() throws Throwable {
        this.testFolder = CoresCreateUpdateDistributedIT.initSolrServers(0, CoresCreateUpdateDistributedIT.class.getSimpleName(), null);
    }

    @After
    public void destroyData() {
        CoresCreateUpdateDistributedIT.dismissSolrServers();
        try {
            FileUtils.deleteDirectory((File)new File(testDir.toPath().resolve(this.testFolder).toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void newCoreUsingAllDefaults() throws Exception {
        CoreContainer coreContainer = ((JettySolrRunner)jettyContainers.get(this.testFolder)).getCoreContainer();
        AlfrescoCoreAdminHandler coreAdminHandler = (AlfrescoCoreAdminHandler)coreContainer.getMultiCoreHandler();
        CoresCreateUpdateDistributedIT.assertNotNull((Object)coreAdminHandler);
        CoresCreateUpdateDistributedIT.createSimpleCore(coreAdminHandler, null, null, null, new String[0]);
        SolrCore defaultCore = AlfrescoSolrUtils.getCore(coreContainer, "alfresco");
        TimeUnit.SECONDS.sleep(3L);
        CoresCreateUpdateDistributedIT.assertNotNull((Object)defaultCore);
        SolrQueryResponse response = CoresCreateUpdateDistributedIT.callHandler(coreAdminHandler, defaultCore, "SUMMARY");
        AlfrescoSolrUtils.assertSummaryCorrect(response, defaultCore.getName());
    }

    @Test
    @Ignore(value="https://issues.alfresco.com/jira/browse/SEARCH-2524")
    public void newCoreWithUpdateSharedProperties() throws Exception {
        CoreContainer coreContainer = ((JettySolrRunner)jettyContainers.get(this.testFolder)).getCoreContainer();
        AlfrescoCoreAdminHandler coreAdminHandler = (AlfrescoCoreAdminHandler)coreContainer.getMultiCoreHandler();
        CoresCreateUpdateDistributedIT.assertNotNull((Object)coreAdminHandler);
        String coreName = "alfSharedCore";
        CoresCreateUpdateDistributedIT.updateShared(coreAdminHandler, "property.solr.host", "myhost", "property.my.property", "chocolate", "property.alfresco.identifier.property.0", "http://www.alfresco.org/model/content/1.0}userName");
        Properties props = AlfrescoSolrDataModel.getCommonConfig();
        CoresCreateUpdateDistributedIT.assertEquals((Object)props.getProperty("my.property"), (Object)"chocolate");
        CoresCreateUpdateDistributedIT.assertEquals((Object)props.getProperty("alfresco.identifier.property.0"), (Object)"http://www.alfresco.org/model/content/1.0}userName");
        CoresCreateUpdateDistributedIT.createSimpleCore(coreAdminHandler, coreName, StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.toString(), null, new String[0]);
        SolrCore defaultCore = AlfrescoSolrUtils.getCore(coreContainer, coreName);
        TimeUnit.SECONDS.sleep(3L);
        CoresCreateUpdateDistributedIT.assertNotNull((Object)defaultCore);
        String solrHost = props.getProperty("solr.host");
        CoresCreateUpdateDistributedIT.assertFalse((boolean)props.containsKey("new.property"));
        try {
            CoresCreateUpdateDistributedIT.updateShared(coreAdminHandler, "property.solr.host", "superhost", "property.new.property", "catchup", "property.alfresco.identifier.property.0", "not_this_time");
            CoresCreateUpdateDistributedIT.fail();
        }
        catch (SolrException se) {
            CoresCreateUpdateDistributedIT.assertEquals((long)SolrException.ErrorCode.BAD_REQUEST.code, (long)se.code());
        }
        CoresCreateUpdateDistributedIT.updateShared(coreAdminHandler, "property.solr.host", "superhost", "property.new.property", "catchup");
        props = AlfrescoSolrDataModel.getCommonConfig();
        CoresCreateUpdateDistributedIT.assertEquals((Object)props.getProperty("new.property"), (Object)"catchup");
        CoresCreateUpdateDistributedIT.assertNotEquals((Object)props.getProperty("solr.host"), (Object)solrHost);
    }

    @Test
    public void newCoreUsingArchiveStore() throws Exception {
        CoreContainer coreContainer = ((JettySolrRunner)jettyContainers.get(this.testFolder)).getCoreContainer();
        AlfrescoCoreAdminHandler coreAdminHandler = (AlfrescoCoreAdminHandler)coreContainer.getMultiCoreHandler();
        CoresCreateUpdateDistributedIT.assertNotNull((Object)coreAdminHandler);
        String coreName = "archive";
        CoresCreateUpdateDistributedIT.createSimpleCore(coreAdminHandler, coreName, StoreRef.STORE_REF_ARCHIVE_SPACESSTORE.toString(), "rerank", "property.alfresco.maxTotalBagels", "99", "property.alfresco.maxTotalConnections", "3456");
        SolrCore defaultCore = AlfrescoSolrUtils.getCore(coreContainer, coreName);
        TimeUnit.SECONDS.sleep(3L);
        CoresCreateUpdateDistributedIT.assertNotNull((Object)defaultCore);
        SolrQueryResponse response = CoresCreateUpdateDistributedIT.callHandler(coreAdminHandler, defaultCore, "SUMMARY");
        AlfrescoSolrUtils.assertSummaryCorrect(response, defaultCore.getName());
        CoresCreateUpdateDistributedIT.assertEquals((Object)"3456", (Object)defaultCore.getCoreDescriptor().getCoreProperty("alfresco.maxTotalConnections", "notset"));
        CoresCreateUpdateDistributedIT.assertEquals((Object)"99", (Object)defaultCore.getCoreDescriptor().getCoreProperty("alfresco.maxTotalBagels", "notset"));
        CoresCreateUpdateDistributedIT.updateCore(coreAdminHandler, coreName, "property.alfresco.maxTotalBagels", "101", "property.alfresco.maxTotalConnections", "55", "property.solr.is.great", "true");
        defaultCore = AlfrescoSolrUtils.getCore(coreContainer, coreName);
        CoresCreateUpdateDistributedIT.assertEquals((Object)"55", (Object)defaultCore.getCoreDescriptor().getCoreProperty("alfresco.maxTotalConnections", "notset"));
        CoresCreateUpdateDistributedIT.assertEquals((Object)"101", (Object)defaultCore.getCoreDescriptor().getCoreProperty("alfresco.maxTotalBagels", "notset"));
        CoresCreateUpdateDistributedIT.assertEquals((Object)"true", (Object)defaultCore.getCoreDescriptor().getCoreProperty("solr.is.great", "notset"));
    }

    public static void createSimpleCore(AlfrescoCoreAdminHandler coreAdminHandler, String coreName, String storeRef, String templateName, String ... extraParams) throws InterruptedException {
        ModifiableSolrParams coreParams = CoresCreateUpdateDistributedIT.params((String[])new String[]{"action", "NEWDEFAULTINDEX", "storeRef", storeRef, "coreName", coreName, "template", templateName});
        coreParams.add((SolrParams)CoresCreateUpdateDistributedIT.params((String[])extraParams));
        LocalSolrQueryRequest request = new LocalSolrQueryRequest(null, (SolrParams)coreParams);
        SolrQueryResponse response = new SolrQueryResponse();
        coreAdminHandler.handleCustomAction((SolrQueryRequest)request, response);
        TimeUnit.SECONDS.sleep(2L);
    }

    public static void updateCore(AlfrescoCoreAdminHandler coreAdminHandler, String coreName, String ... extraParams) throws InterruptedException {
        ModifiableSolrParams coreParams = CoresCreateUpdateDistributedIT.params((String[])new String[]{"action", "UPDATECORE", "coreName", coreName});
        coreParams.add((SolrParams)CoresCreateUpdateDistributedIT.params((String[])extraParams));
        LocalSolrQueryRequest request = new LocalSolrQueryRequest(null, (SolrParams)coreParams);
        SolrQueryResponse response = new SolrQueryResponse();
        coreAdminHandler.handleCustomAction((SolrQueryRequest)request, response);
        TimeUnit.SECONDS.sleep(2L);
    }

    public static void updateShared(AlfrescoCoreAdminHandler coreAdminHandler, String ... extraParams) throws InterruptedException {
        ModifiableSolrParams coreParams = CoresCreateUpdateDistributedIT.params((String[])new String[]{"action", "UPDATESHARED"});
        coreParams.add((SolrParams)CoresCreateUpdateDistributedIT.params((String[])extraParams));
        LocalSolrQueryRequest request = new LocalSolrQueryRequest(null, (SolrParams)coreParams);
        SolrQueryResponse response = new SolrQueryResponse();
        coreAdminHandler.handleCustomAction((SolrQueryRequest)request, response);
        TimeUnit.SECONDS.sleep(2L);
    }
}

