/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.alfresco.solr.HandlerOfResources;
import org.junit.Assert;
import org.junit.Test;

public class HandlerOfResourcesTest {
    @Test
    public void allowedPropertiesTest() {
        Assert.assertTrue((boolean)HandlerOfResources.allowedProperties(null, null));
        Assert.assertTrue((boolean)HandlerOfResources.allowedProperties((Properties)new Properties(), null));
        Assert.assertTrue((boolean)HandlerOfResources.allowedProperties((Properties)new Properties(), new ArrayList()));
        Properties props = new Properties();
        props.setProperty("king", "kong");
        props.setProperty("barbie", "doll");
        Assert.assertFalse((boolean)HandlerOfResources.allowedProperties((Properties)props, Collections.singletonList("bar")));
        Assert.assertTrue((boolean)HandlerOfResources.allowedProperties((Properties)props, Collections.singletonList("bark")));
        Assert.assertTrue((boolean)HandlerOfResources.allowedProperties((Properties)props, (List)HandlerOfResources.DISALLOWED_SHARED_UPDATES));
        props.setProperty("solr.host", "me");
        props.setProperty("solr.port", "233");
        Assert.assertTrue((boolean)HandlerOfResources.allowedProperties((Properties)props, (List)HandlerOfResources.DISALLOWED_SHARED_UPDATES));
        props.setProperty("alfresco.identifier.property.0", "xy");
        Assert.assertFalse((boolean)HandlerOfResources.allowedProperties((Properties)props, (List)HandlerOfResources.DISALLOWED_SHARED_UPDATES));
        props.remove("alfresco.identifier.property.0");
        props.setProperty("alfresco.suggestable.property.1", "xy");
        Assert.assertFalse((boolean)HandlerOfResources.allowedProperties((Properties)props, (List)HandlerOfResources.DISALLOWED_SHARED_UPDATES));
        props.remove("alfresco.suggestable.property.1");
        props.setProperty("alfresco.cross.locale.property.0", "xy");
        Assert.assertFalse((boolean)HandlerOfResources.allowedProperties((Properties)props, (List)HandlerOfResources.DISALLOWED_SHARED_UPDATES));
        props.remove("alfresco.cross.locale.property.0");
        props.setProperty("alfresco.cross.locale.datatype.2", "xy");
        Assert.assertFalse((boolean)HandlerOfResources.allowedProperties((Properties)props, (List)HandlerOfResources.DISALLOWED_SHARED_UPDATES));
        props.remove("alfresco.cross.locale.datatype.2");
    }
}

