/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.solr.query.AlfrescoLuceneQParserPlugin;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AlfrescoLuceneQParserTest {
    private AlfrescoLuceneQParserPlugin.AlfrescoLuceneQParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new AlfrescoLuceneQParserPlugin.AlfrescoLuceneQParser(null, null, null, null, null);
    }

    @Test
    public void forwardSlashesEscapedCorrectly() {
        Assert.assertEquals((String)"Nothing to escape", (Object)"abcdef", (Object)this.parser.escape("abcdef"));
        Assert.assertEquals((String)"Escape single slash", (Object)"abc\\/def", (Object)this.parser.escape("abc/def"));
        Assert.assertEquals((String)"Do not escape quoted slash", (Object)"abc\"/\"def", (Object)this.parser.escape("abc\"/\"def"));
        Assert.assertEquals((String)"Do not escape escaped slash", (Object)"abc\\/def", (Object)this.parser.escape("abc\\/def"));
        Assert.assertEquals((String)"Do not escape quoted escaped slash", (Object)"abc\"\\/\"def", (Object)this.parser.escape("abc\"\\/\"def"));
        Assert.assertEquals((String)"Escape multiple consecutive slashes", (Object)"abc\\/\\/def", (Object)this.parser.escape("abc//def"));
        Assert.assertEquals((Object)"abc\\/\\/\\/\\/\\/def\\/\\/\\/:\"bl/ah\"", (Object)this.parser.escape("abc/////def/\\//:\"bl/ah\""));
        String input = "(@\\{http\\://www.alfresco.org/model/imap/1.0\\}messageId:\"000000005E157E8B296B6B4DA1F00A30E4F21FE1C4002000\" OR @\\{http\\://www.westernacher.com/alfresco/models/wpsmail\\-v2\\}messageId:\"000000005E157E8B296B6B4DA1F00A30E4F21FE1C4002000\")";
        String expected = "(@\\{http\\:\\/\\/www.alfresco.org\\/model\\/imap\\/1.0\\}messageId:\"000000005E157E8B296B6B4DA1F00A30E4F21FE1C4002000\" OR @\\{http\\:\\/\\/www.westernacher.com\\/alfresco\\/models\\/wpsmail\\-v2\\}messageId:\"000000005E157E8B296B6B4DA1F00A30E4F21FE1C4002000\")";
        Assert.assertEquals((Object)"(@\\{http\\:\\/\\/www.alfresco.org\\/model\\/imap\\/1.0\\}messageId:\"000000005E157E8B296B6B4DA1F00A30E4F21FE1C4002000\" OR @\\{http\\:\\/\\/www.westernacher.com\\/alfresco\\/models\\/wpsmail\\-v2\\}messageId:\"000000005E157E8B296B6B4DA1F00A30E4F21FE1C4002000\")", (Object)this.parser.escape("(@\\{http\\://www.alfresco.org/model/imap/1.0\\}messageId:\"000000005E157E8B296B6B4DA1F00A30E4F21FE1C4002000\" OR @\\{http\\://www.westernacher.com/alfresco/models/wpsmail\\-v2\\}messageId:\"000000005E157E8B296B6B4DA1F00A30E4F21FE1C4002000\")"));
    }
}

