/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.util.List;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.PivotField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.common.util.NamedList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedAlfrescoSolrFacetingIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        DistributedAlfrescoSolrFacetingIT.initSolrServers(2, DistributedAlfrescoSolrFacetingIT.class.getSimpleName(), null);
        DistributedAlfrescoSolrFacetingIT.indexSampleDocumentsForFacetingMincount();
    }

    @AfterClass
    public static void destroyData() {
        DistributedAlfrescoSolrFacetingIT.dismissSolrServers();
    }

    @Test
    public void distributedSearch_fieldFacetingRequiringRefinement_shouldReturnCorrectCounts() throws Exception {
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 0, "id", "10", "suggest", "b", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "a b");
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 0, "id", "20", "suggest", "b", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "a");
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 0, "id", "30", "suggest", "b", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "b c");
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 1, "id", "40", "suggest", "b", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "c b");
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 1, "id", "50", "suggest", "b", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "c b");
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 1, "id", "60", "suggest", "b", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "c");
        DistributedAlfrescoSolrFacetingIT.commit(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true);
        String expectedFacetField = "{http://www.alfresco.org/model/content/1.0}content:[b (4), c (4)]";
        String jsonQuery = "{\"query\":\"(suggest:b)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.field", "{http://www.alfresco.org/model/content/1.0}content", "facet.limit", "2", "facet.overrequest.count", "0", "facet.overrequest.ratio", "1"}));
        List facetFields = queryResponse.getFacetFields();
        FacetField facetField = (FacetField)facetFields.get(0);
        Assert.assertThat((Object)facetField.toString(), (Matcher)Is.is((Object)expectedFacetField));
    }

    @Test
    public void fieldFaceting_mincountMissing_shouldReturnFacetsMincountOne() throws Exception {
        String expectedContentFacetField = "{http://www.alfresco.org/model/content/1.0}content:[contenttwo (4), contentone (1)]";
        String expectedNameFacetField = "{http://www.alfresco.org/model/content/1.0}name:[nametwo (4), nameone (1)]";
        String jsonQuery = "{\"query\":\"(suggest:a)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.field", "{http://www.alfresco.org/model/content/1.0}content", "facet.field", "{http://www.alfresco.org/model/content/1.0}name"}));
        List facetFields = queryResponse.getFacetFields();
        FacetField contentFacetField = (FacetField)facetFields.get(0);
        Assert.assertThat((Object)contentFacetField.toString(), (Matcher)Is.is((Object)expectedContentFacetField));
        FacetField nameFacetField = (FacetField)facetFields.get(1);
        Assert.assertThat((Object)nameFacetField.toString(), (Matcher)Is.is((Object)expectedNameFacetField));
    }

    @Test
    public void pivotFaceting_mincountMissing_shouldReturnFacetsMincountOne() throws Exception {
        String jsonQuery = "{\"query\":\"(suggest:a)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.pivot", "{http://www.alfresco.org/model/content/1.0}content,{http://www.alfresco.org/model/content/1.0}name"}));
        NamedList facetPivot = queryResponse.getFacetPivot();
        List firstLevelValues = (List)facetPivot.getVal(0);
        Assert.assertThat((Object)firstLevelValues.size(), (Matcher)Is.is((Object)2));
        PivotField firstLevelPivot0 = (PivotField)firstLevelValues.get(0);
        Assert.assertThat((Object)firstLevelPivot0.getValue(), (Matcher)Is.is((Object)"contenttwo"));
        Assert.assertThat((Object)firstLevelPivot0.getCount(), (Matcher)Is.is((Object)4));
        List firstLevelPivot0Children = firstLevelPivot0.getPivot();
        Assert.assertThat((Object)firstLevelPivot0Children.size(), (Matcher)Is.is((Object)1));
        PivotField secondLevelPivot0 = (PivotField)firstLevelPivot0Children.get(0);
        Assert.assertThat((Object)secondLevelPivot0.getValue(), (Matcher)Is.is((Object)"nametwo"));
        Assert.assertThat((Object)secondLevelPivot0.getCount(), (Matcher)Is.is((Object)4));
        PivotField firstLevelPivot1 = (PivotField)firstLevelValues.get(1);
        Assert.assertThat((Object)firstLevelPivot1.getValue(), (Matcher)Is.is((Object)"contentone"));
        Assert.assertThat((Object)firstLevelPivot1.getCount(), (Matcher)Is.is((Object)1));
        List firstLevelPivot1Children = firstLevelPivot1.getPivot();
        Assert.assertThat((Object)firstLevelPivot1Children.size(), (Matcher)Is.is((Object)1));
        PivotField secondLevelPivot1 = (PivotField)firstLevelPivot1Children.get(0);
        Assert.assertThat((Object)secondLevelPivot1.getValue(), (Matcher)Is.is((Object)"nameone"));
        Assert.assertThat((Object)secondLevelPivot1.getCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void fieldFaceting_mincountSetZero_shouldReturnFacetsMincountOne() throws Exception {
        String expectedContentFacetField = "{http://www.alfresco.org/model/content/1.0}content:[contenttwo (4), contentone (1)]";
        String expectedNameFacetField = "{http://www.alfresco.org/model/content/1.0}name:[nametwo (4), nameone (1)]";
        String jsonQuery = "{\"query\":\"(suggest:a)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.field", "{http://www.alfresco.org/model/content/1.0}content", "facet.field", "{http://www.alfresco.org/model/content/1.0}name", "facet.mincount", "0"}));
        List facetFields = queryResponse.getFacetFields();
        FacetField contentFacetField = (FacetField)facetFields.get(0);
        Assert.assertThat((Object)contentFacetField.toString(), (Matcher)Is.is((Object)expectedContentFacetField));
        FacetField nameFacetField = (FacetField)facetFields.get(1);
        Assert.assertThat((Object)nameFacetField.toString(), (Matcher)Is.is((Object)expectedNameFacetField));
    }

    @Test
    public void pivotFaceting_mincountSetZero_shouldReturnFacetsMincountOne() throws Exception {
        String jsonQuery = "{\"query\":\"(suggest:a)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.pivot", "{http://www.alfresco.org/model/content/1.0}content,{http://www.alfresco.org/model/content/1.0}name", "facet.pivot.mincount", "0"}));
        NamedList facetPivot = queryResponse.getFacetPivot();
        List firstLevelValues = (List)facetPivot.getVal(0);
        Assert.assertThat((Object)firstLevelValues.size(), (Matcher)Is.is((Object)2));
        PivotField firstLevelPivot0 = (PivotField)firstLevelValues.get(0);
        Assert.assertThat((Object)firstLevelPivot0.getValue(), (Matcher)Is.is((Object)"contenttwo"));
        Assert.assertThat((Object)firstLevelPivot0.getCount(), (Matcher)Is.is((Object)4));
        List firstLevelPivot0Children = firstLevelPivot0.getPivot();
        Assert.assertThat((Object)firstLevelPivot0Children.size(), (Matcher)Is.is((Object)1));
        PivotField secondLevelPivot0 = (PivotField)firstLevelPivot0Children.get(0);
        Assert.assertThat((Object)secondLevelPivot0.getValue(), (Matcher)Is.is((Object)"nametwo"));
        Assert.assertThat((Object)secondLevelPivot0.getCount(), (Matcher)Is.is((Object)4));
        PivotField firstLevelPivot1 = (PivotField)firstLevelValues.get(1);
        Assert.assertThat((Object)firstLevelPivot1.getValue(), (Matcher)Is.is((Object)"contentone"));
        Assert.assertThat((Object)firstLevelPivot1.getCount(), (Matcher)Is.is((Object)1));
        List firstLevelPivot1Children = firstLevelPivot1.getPivot();
        Assert.assertThat((Object)firstLevelPivot1Children.size(), (Matcher)Is.is((Object)1));
        PivotField secondLevelPivot1 = (PivotField)firstLevelPivot1Children.get(0);
        Assert.assertThat((Object)secondLevelPivot1.getValue(), (Matcher)Is.is((Object)"nameone"));
        Assert.assertThat((Object)secondLevelPivot1.getCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void fieldFaceting_mincountSetTwo_shouldReturnFacetsOriginalMincount() throws Exception {
        String expectedContentFacetField = "{http://www.alfresco.org/model/content/1.0}content:[contenttwo (4)]";
        String expectedNameFacetField = "{http://www.alfresco.org/model/content/1.0}name:[nametwo (4)]";
        String jsonQuery = "{\"query\":\"(suggest:a)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.field", "{http://www.alfresco.org/model/content/1.0}content", "facet.field", "{http://www.alfresco.org/model/content/1.0}name", "facet.mincount", "2"}));
        List facetFields = queryResponse.getFacetFields();
        FacetField contentFacetField = (FacetField)facetFields.get(0);
        Assert.assertThat((Object)contentFacetField.toString(), (Matcher)Is.is((Object)expectedContentFacetField));
        FacetField nameFacetField = (FacetField)facetFields.get(1);
        Assert.assertThat((Object)nameFacetField.toString(), (Matcher)Is.is((Object)expectedNameFacetField));
    }

    @Test
    public void pivotFaceting_mincountSetTwo_shouldReturnFacetsOriginalMincount() throws Exception {
        String jsonQuery = "{\"query\":\"(suggest:a)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.pivot", "{http://www.alfresco.org/model/content/1.0}content,{http://www.alfresco.org/model/content/1.0}name", "facet.pivot.mincount", "2"}));
        NamedList facetPivot = queryResponse.getFacetPivot();
        List firstLevelValues = (List)facetPivot.getVal(0);
        Assert.assertThat((Object)firstLevelValues.size(), (Matcher)Is.is((Object)1));
        PivotField firstLevelPivot0 = (PivotField)firstLevelValues.get(0);
        Assert.assertThat((Object)firstLevelPivot0.getValue(), (Matcher)Is.is((Object)"contenttwo"));
        Assert.assertThat((Object)firstLevelPivot0.getCount(), (Matcher)Is.is((Object)4));
        List firstLevelPivot0Children = firstLevelPivot0.getPivot();
        Assert.assertThat((Object)firstLevelPivot0Children.size(), (Matcher)Is.is((Object)1));
        PivotField secondLevelPivot0 = (PivotField)firstLevelPivot0Children.get(0);
        Assert.assertThat((Object)secondLevelPivot0.getValue(), (Matcher)Is.is((Object)"nametwo"));
        Assert.assertThat((Object)secondLevelPivot0.getCount(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void fieldFaceting_perFieldMincountSetZero_shoulReturnFacetsMincountOne() throws Exception {
        String expectedContentFacetField = "{http://www.alfresco.org/model/content/1.0}content:[contenttwo (4), contentone (1)]";
        String expectedNameFacetField = "{http://www.alfresco.org/model/content/1.0}name:[nametwo (4), nameone (1)]";
        String jsonQuery = "{\"query\":\"(suggest:a)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.field", "{http://www.alfresco.org/model/content/1.0}content", "facet.field", "{http://www.alfresco.org/model/content/1.0}name", "f.{http://www.alfresco.org/model/content/1.0}content.facet.mincount", "0", "f.{http://www.alfresco.org/model/content/1.0}name.facet.mincount", "0"}));
        List facetFields = queryResponse.getFacetFields();
        FacetField contentFacetField = (FacetField)facetFields.get(0);
        Assert.assertThat((Object)contentFacetField.toString(), (Matcher)Is.is((Object)expectedContentFacetField));
        FacetField nameFacetField = (FacetField)facetFields.get(1);
        Assert.assertThat((Object)nameFacetField.toString(), (Matcher)Is.is((Object)expectedNameFacetField));
    }

    @Test
    public void fieldFaceting_perFieldMincountSetTwo_shoulReturnFacetsMincountTwo() throws Exception {
        String expectedContentFacetField = "{http://www.alfresco.org/model/content/1.0}content:[contenttwo (4)]";
        String expectedNameFacetField = "{http://www.alfresco.org/model/content/1.0}name:[nametwo (4), nameone (1)]";
        String jsonQuery = "{\"query\":\"(suggest:a)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.field", "{http://www.alfresco.org/model/content/1.0}content", "facet.field", "{http://www.alfresco.org/model/content/1.0}name", "f.{http://www.alfresco.org/model/content/1.0}content.facet.mincount", "2", "f.{http://www.alfresco.org/model/content/1.0}name.facet.mincount", "0"}));
        List facetFields = queryResponse.getFacetFields();
        FacetField contentFacetField = (FacetField)facetFields.get(0);
        Assert.assertThat((Object)contentFacetField.toString(), (Matcher)Is.is((Object)expectedContentFacetField));
        FacetField nameFacetField = (FacetField)facetFields.get(1);
        Assert.assertThat((Object)nameFacetField.toString(), (Matcher)Is.is((Object)expectedNameFacetField));
    }

    @Test
    public void rangeFaceting_mincountMissing_shouldReturnFacetsMincountOne() throws Exception {
        String jsonQuery = "{\"query\":\"(suggest:a)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.range", "{http://www.alfresco.org/model/content/1.0}created", "facet.range.start", "2000-01-02T00:00:00Z", "facet.range.end", "2020-01-02T00:00:00Z", "facet.range.gap", "+100DAY"}));
        List facetRanges = queryResponse.getFacetRanges();
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)facetRanges.size(), (Matcher)Is.is((Object)1));
        RangeFacet createdDateRangeFacet = (RangeFacet)facetRanges.get(0);
        List createdDateCounts = createdDateRangeFacet.getCounts();
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)createdDateCounts.size(), (Matcher)Is.is((Object)4));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(0)).getValue(), (Matcher)Is.is((Object)"2014-10-15T00:00:00Z"));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(0)).getCount(), (Matcher)Is.is((Object)2));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(1)).getValue(), (Matcher)Is.is((Object)"2015-01-23T00:00:00Z"));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(1)).getCount(), (Matcher)Is.is((Object)1));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(2)).getValue(), (Matcher)Is.is((Object)"2015-11-19T00:00:00Z"));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(2)).getCount(), (Matcher)Is.is((Object)1));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(3)).getValue(), (Matcher)Is.is((Object)"2016-12-23T00:00:00Z"));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(3)).getCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void rangeFaceting_mincountSetZero_shouldReturnFacetsMincountOne() throws Exception {
        String jsonQuery = "{\"query\":\"(suggest:a)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.range", "{http://www.alfresco.org/model/content/1.0}created", "facet.range.start", "2000-01-02T00:00:00Z", "facet.range.end", "2020-01-02T00:00:00Z", "facet.range.gap", "+100DAY", "facet.mincount", "0"}));
        List facetRanges = queryResponse.getFacetRanges();
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)facetRanges.size(), (Matcher)Is.is((Object)1));
        RangeFacet createdDateRangeFacet = (RangeFacet)facetRanges.get(0);
        List createdDateCounts = createdDateRangeFacet.getCounts();
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)createdDateCounts.size(), (Matcher)Is.is((Object)4));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(0)).getValue(), (Matcher)Is.is((Object)"2014-10-15T00:00:00Z"));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(0)).getCount(), (Matcher)Is.is((Object)2));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(1)).getValue(), (Matcher)Is.is((Object)"2015-01-23T00:00:00Z"));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(1)).getCount(), (Matcher)Is.is((Object)1));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(2)).getValue(), (Matcher)Is.is((Object)"2015-11-19T00:00:00Z"));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(2)).getCount(), (Matcher)Is.is((Object)1));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(3)).getValue(), (Matcher)Is.is((Object)"2016-12-23T00:00:00Z"));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(3)).getCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void rangeFaceting_mincountSetTwo_shouldReturnFacetsMincountTwo() throws Exception {
        String jsonQuery = "{\"query\":\"(suggest:a)\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}";
        DistributedAlfrescoSolrFacetingIT.putHandleDefaults();
        QueryResponse queryResponse = this.query(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true, jsonQuery, DistributedAlfrescoSolrFacetingIT.params((String[])new String[]{"qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "0", "fl", "score,id", "facet", "true", "facet.range", "{http://www.alfresco.org/model/content/1.0}created", "facet.range.start", "2000-01-02T00:00:00Z", "facet.range.end", "2020-01-02T00:00:00Z", "facet.range.gap", "+100DAY", "facet.mincount", "2"}));
        List facetRanges = queryResponse.getFacetRanges();
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)facetRanges.size(), (Matcher)Is.is((Object)1));
        RangeFacet createdDateRangeFacet = (RangeFacet)facetRanges.get(0);
        List createdDateCounts = createdDateRangeFacet.getCounts();
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)createdDateCounts.size(), (Matcher)Is.is((Object)1));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(0)).getValue(), (Matcher)Is.is((Object)"2014-10-15T00:00:00Z"));
        DistributedAlfrescoSolrFacetingIT.assertThat((Object)((RangeFacet.Count)createdDateCounts.get(0)).getCount(), (Matcher)Is.is((Object)2));
    }

    private static void indexSampleDocumentsForFacetingMincount() throws Exception {
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 0, "id", "1", "suggest", "a", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "contentone", "text@s____@{http://www.alfresco.org/model/content/1.0}name", "nameone", "datetime@sd@{http://www.alfresco.org/model/content/1.0}created", "2015-01-02T00:00:00Z");
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 0, "id", "2", "suggest", "a", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "contenttwo", "text@s____@{http://www.alfresco.org/model/content/1.0}name", "nametwo", "datetime@sd@{http://www.alfresco.org/model/content/1.0}created", "2015-01-02T00:00:00Z");
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 0, "id", "3", "suggest", "a", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "contenttwo", "text@s____@{http://www.alfresco.org/model/content/1.0}name", "nametwo", "datetime@sd@{http://www.alfresco.org/model/content/1.0}created", "2015-02-01T00:00:00Z");
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 1, "id", "4", "suggest", "a", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "contenttwo", "text@s____@{http://www.alfresco.org/model/content/1.0}name", "nametwo", "datetime@sd@{http://www.alfresco.org/model/content/1.0}created", "2016-02-01T00:00:00Z");
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 1, "id", "5", "suggest", "a", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "contenttwo", "text@s____@{http://www.alfresco.org/model/content/1.0}name", "nametwo", "datetime@sd@{http://www.alfresco.org/model/content/1.0}created", "2017-02-01T00:00:00Z");
        DistributedAlfrescoSolrFacetingIT.index(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), 1, "id", "6", "suggest", "c", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "contentthree", "text@s____@{http://www.alfresco.org/model/content/1.0}name", "namethree", "datetime@sd@{http://www.alfresco.org/model/content/1.0}created", "2017-02-01T00:00:00Z");
        DistributedAlfrescoSolrFacetingIT.commit(DistributedAlfrescoSolrFacetingIT.getDefaultTestClient(), true);
    }
}

