/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

@LuceneTestCase.SuppressCodecs(value={"Appending", "Lucene3x", "Lucene40", "Lucene41", "Lucene42", "Lucene43", "Lucene44", "Lucene45", "Lucene46", "Lucene47", "Lucene48", "Lucene49"})
@SolrTestCaseJ4.SuppressSSL
public class SolrAuthIT
extends AbstractAlfrescoSolrIT {
    @BeforeClass
    public static void beforeClass() throws Exception {
        SolrAuthIT.initAlfrescoCore("schema.xml");
    }

    @Before
    public void setUp() throws Exception {
    }

    @Before
    public void loadAuth() throws Exception {
        this.assertU(SolrAuthIT.delQ("*:*"));
        this.assertU(SolrAuthIT.commit(new String[0]));
        String[] acldoc = new String[]{"id", "100", "_version_", "0", "READER", "GROUP_R1", "READER", "GROUP_R2", "ACLID", "5000"};
        this.assertU(SolrAuthIT.adoc(acldoc));
        this.assertU(SolrAuthIT.commit(new String[0]));
        String[] acldoc1 = new String[]{"id", "101", "_version_", "0", "READER", "GROUP_R3", "READER", "GROUP_R4", "ACLID", "6000", "DENIED", "GROUP_D1"};
        this.assertU(SolrAuthIT.adoc(acldoc1));
        this.assertU(SolrAuthIT.commit(new String[0]));
        String[] acldoc2 = new String[]{"id", "102", "_version_", "0", "READER", "GROUP_R3", "READER", "GROUP_R2", "ACLID", "7000"};
        this.assertU(SolrAuthIT.adoc(acldoc2));
        this.assertU(SolrAuthIT.commit(new String[0]));
        String[] acldoc3 = new String[]{"id", "103", "_version_", "0", "READER", "GROUP_R3", "READER", "GROUP_R5", "ACLID", "8000"};
        this.assertU(SolrAuthIT.adoc(acldoc3));
        this.assertU(SolrAuthIT.commit(new String[0]));
        String[] acldoc4 = new String[]{"id", "104", "_version_", "0", "READER", "GROUP_R5", "READER", "GROUP_R1", "ACLID", "9000"};
        this.assertU(SolrAuthIT.adoc(acldoc4));
        this.assertU(SolrAuthIT.commit(new String[0]));
        String[] doc = new String[]{"id", "1", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "YYYY", "ACLID", "5000", "OWNER", "jim"};
        this.assertU(SolrAuthIT.adoc(doc));
        this.assertU(SolrAuthIT.commit(new String[0]));
        String[] doc1 = new String[]{"id", "2", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "YYYY", "ACLID", "6000", "OWNER", "dave"};
        this.assertU(SolrAuthIT.adoc(doc1));
        String[] doc2 = new String[]{"id", "3", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "YYYY", "ACLID", "7000", "OWNER", "mary"};
        this.assertU(SolrAuthIT.adoc(doc2));
        this.assertU(SolrAuthIT.commit(new String[0]));
        String[] doc3 = new String[]{"id", "4", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "YYYY", "ACLID", "8000", "OWNER", "bill"};
        this.assertU(SolrAuthIT.adoc(doc3));
        String[] doc4 = new String[]{"id", "5", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "YYYY", "ACLID", "9000", "OWNER", "steve"};
        this.assertU(SolrAuthIT.adoc(doc4));
        this.assertU(SolrAuthIT.commit(new String[0]));
        String[] doc5 = new String[]{"id", "6", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "YYYY", "ACLID", "10000", "OWNER", "sara"};
        this.assertU(SolrAuthIT.adoc(doc5));
        this.assertU(SolrAuthIT.commit(new String[0]));
    }

    @Test
    public void testAuthInFilter() {
        this.testAuth("false");
    }

    @Test
    public void testAuthPostFilter() {
        this.testAuth("true");
    }

    public void testAuth(String postFilter) {
        System.setProperty("alfresco.postfilter", postFilter);
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("q", new String[]{"t1:YYYY"});
        params.add("qt", new String[]{"/afts"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        params.add("sort", new String[]{"id asc"});
        params.add("fq", new String[]{"{!afts}AUTHORITY_FILTER_FROM_JSON"});
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"GROUP_R2\",\"GROUP_R4\" ], \"tenants\": [ \"\" ]}");
        SolrAuthIT.assertQ((SolrQueryRequest)req, "*[count(//doc)=3]", "//result/doc[1]/str[@name='id'][.='1']", "//result/doc[2]/str[@name='id'][.='2']", "//result/doc[3]/str[@name='id'][.='3']");
        params = new ModifiableSolrParams();
        params.add("q", new String[]{"t1:YYYY"});
        params.add("qt", new String[]{"/afts"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        params.add("sort", new String[]{"id asc"});
        params.add("fq", new String[]{"{!afts}AUTHORITY_FILTER_FROM_JSON"});
        req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"GROUP_R2\",\"GROUP_R4\", \"steve\" ], \"tenants\": [ \"\" ]}");
        SolrAuthIT.assertQ((SolrQueryRequest)req, "*[count(//doc)=4]", "//result/doc[1]/str[@name='id'][.='1']", "//result/doc[2]/str[@name='id'][.='2']", "//result/doc[3]/str[@name='id'][.='3']", "//result/doc[4]/str[@name='id'][.='5']");
        params = new ModifiableSolrParams();
        params.add("q", new String[]{"t1:YYYY"});
        params.add("qt", new String[]{"/afts"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        params.add("sort", new String[]{"id asc"});
        params.add("fq", new String[]{"{!afts}AUTHORITY_FILTER_FROM_JSON"});
        req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"GROUP_R2\",\"GROUP_R4\", \"GROUP_D1\"], \"tenants\": [ \"\" ]}");
        SolrAuthIT.assertQ((SolrQueryRequest)req, "*[count(//doc)=2]", "//result/doc[1]/str[@name='id'][.='1']", "//result/doc[2]/str[@name='id'][.='3']");
        params = new ModifiableSolrParams();
        params.add("q", new String[]{"t1:YYYY"});
        params.add("qt", new String[]{"/afts"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        params.add("sort", new String[]{"id asc"});
        params.add("fq", new String[]{"{!afts}AUTHORITY_FILTER_FROM_JSON"});
        req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"ROLE_ADMINISTRATOR\"], \"tenants\": [ \"\" ]}");
        SolrAuthIT.assertQ((SolrQueryRequest)req, "*[count(//doc)=6]");
        params = new ModifiableSolrParams();
        params.add("q", new String[]{"t1:YYYY"});
        params.add("qt", new String[]{"/afts"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        params.add("sort", new String[]{"id asc"});
        params.add("fq", new String[]{"{!afts}AUTHORITY_FILTER_FROM_JSON"});
        req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"blah\"], \"tenants\": [ \"\" ]}");
        SolrAuthIT.assertQ((SolrQueryRequest)req, "*[count(//doc)=0]");
    }
}

