/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query.afts.requestHandler;

import java.util.HashMap;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.dataload.TestDataProvider;
import org.alfresco.solr.query.afts.requestHandler.AbstractRequestHandlerIT;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AFTSIdentifierFieldsIT
extends AbstractRequestHandlerIT {
    @BeforeClass
    public static void beforeClass() throws Exception {
        TestDataProvider dataProvider = new TestDataProvider(h);
        String[] usernames = new String[]{"Daniel", "Daniel2", "Daniele", "daniel.armstrong"};
        TEST_ROOT_NODEREF = dataProvider.getRootNode();
        IntStream.range(0, usernames.length).forEach(dbId -> {
            String username = usernames[dbId];
            HashMap<QName, PropertyValue> properties = new HashMap<QName, PropertyValue>();
            properties.put(ContentModel.PROP_CREATOR, (PropertyValue)new StringPropertyValue(username));
            AlfrescoSolrUtils.addNode(AFTSIdentifierFieldsIT.getCore(), dataModel, 1, dbId, 1, ContentModel.TYPE_CONTENT, null, properties, null, "the_owner_of_this_node_is" + username, null, new NodeRef[]{TEST_ROOT_NODEREF}, new String[]{"/" + String.valueOf(dataProvider.qName("a_qname_for_node_" + username))}, dataProvider.newNodeRef(), true);
        });
    }

    @Test
    public void testIdentifierProperty() {
        this.assertResponseCardinality("creator:'Daniel'", 1);
        this.assertResponseCardinality("creator:'daniel'", 0);
        this.assertResponseCardinality("creator:'Daniel2'", 1);
        this.assertResponseCardinality("creator:'Danie*'", 3);
        this.assertResponseCardinality("creator:'Daniel*'", 3);
        this.assertResponseCardinality("creator:'Daniela'", 0);
        this.assertResponseCardinality("creator:'daniel*'", 1);
        this.assertResponseCardinality("creator:'daniel.armstrong'", 1);
    }
}

