/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.schema.highlight;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.alfresco.solr.schema.highlight.CompositeReader;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class CompositeReaderTest {
    List<String> data = Arrays.asList("This is the", " whole string content ", " we are expecting as final result.");

    @Test(expected=IllegalArgumentException.class)
    public void noReadersSupplied_shouldThrowAnException() {
        CompositeReader reader = new CompositeReader(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyReadersListSupplied_shouldThrowAnException() {
        CompositeReader reader = new CompositeReader(new Reader[0]);
    }

    @Test
    public void oneWrappedReader() throws IOException {
        String expected = String.join((CharSequence)"", this.data);
        try (CompositeReader classUnderTest = new CompositeReader(new Reader[]{new CharArrayReader(expected.toCharArray())});){
            Assert.assertEquals((Object)expected, (Object)IOUtils.toString((Reader)classUnderTest));
        }
    }

    @Test
    public void threeWrappedReader_firstOneConsumed() throws IOException {
        List<String> chunks = Arrays.asList("This is the", " whole string content ", " we are expecting as final result.");
        String expected = String.join((CharSequence)"", chunks.subList(1, 3));
        Reader[] readers = (Reader[])chunks.stream().map(String::toCharArray).map(CharArrayReader::new).toArray(CharArrayReader[]::new);
        Assert.assertEquals((Object)chunks.iterator().next(), (Object)IOUtils.toString((Reader)readers[0]));
        try (CompositeReader classUnderTest = new CompositeReader(readers);){
            Assert.assertEquals((Object)expected, (Object)IOUtils.toString((Reader)classUnderTest));
        }
    }

    @Test
    public void threeWrappedReaders() throws IOException {
        List<String> chunks = Arrays.asList("This is the", " whole string content ", " we are expecting as final result.");
        String expected = String.join((CharSequence)"", chunks);
        Reader[] readers = (Reader[])chunks.stream().map(String::toCharArray).map(CharArrayReader::new).toArray(CharArrayReader[]::new);
        try (CompositeReader classUnderTest = new CompositeReader(readers);){
            Assert.assertEquals((Object)expected, (Object)IOUtils.toString((Reader)classUnderTest));
        }
    }
}

