/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.schema.highlight;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.alfresco.solr.AlfrescoAnalyzerWrapper;
import org.alfresco.solr.schema.highlight.LanguagePrefixedTokenStream;
import org.alfresco.util.Pair;
import org.apache.lucene.analysis.Analyzer;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LanguagePrefixedTokenStreamTest {
    private LanguagePrefixedTokenStream classUnderTest;
    @Mock
    private IndexSchema schema;

    @Before
    public void setUp() {
        this.classUnderTest = new LanguagePrefixedTokenStream(this.schema, "aFieldName", AlfrescoAnalyzerWrapper.Mode.INDEX);
    }

    @Test
    public void localisedFieldTypeName() {
        Arrays.stream(Locale.getAvailableLocales()).map(Locale::getLanguage).forEach(language -> Assert.assertEquals((Object)("text_" + language), (Object)this.classUnderTest.localisedFieldTypeName(language)));
    }

    @Test
    public void highlightingFieldTypeName() {
        Arrays.stream(Locale.getAvailableLocales()).map(Locale::getLanguage).forEach(language -> Assert.assertEquals((Object)("highlighted_text_" + language), (Object)this.classUnderTest.highlightingFieldTypeName(language)));
    }

    @Test
    public void localeMarkerLenghthWithValidLocale_shouldReturnTheMarkerLength() {
        Arrays.stream(Locale.getAvailableLocales()).map(Locale::getLanguage).forEach(language -> Assert.assertEquals((long)(language.length() + 2), (long)this.classUnderTest.localeMarkerLength(Optional.of(language))));
    }

    @Test
    public void localeMarkerLenghthWithInvalidLocale_shouldReturnZero() {
        Assert.assertEquals((long)0L, (long)this.classUnderTest.localeMarkerLength(Optional.empty()));
    }

    @Test
    public void analyzerInCaseTheHighlightingFieldTypeExists() {
        String language = "fr";
        String fieldTypeName = this.classUnderTest.highlightingFieldTypeName(language);
        FieldType highlightedFrenchFieldType = (FieldType)Mockito.mock(FieldType.class);
        Analyzer queryTimeAnalyzer = (Analyzer)Mockito.mock(Analyzer.class);
        Analyzer indexTimeAnalyzer = (Analyzer)Mockito.mock(Analyzer.class);
        Mockito.when((Object)highlightedFrenchFieldType.getIndexAnalyzer()).thenReturn((Object)indexTimeAnalyzer);
        Mockito.when((Object)highlightedFrenchFieldType.getQueryAnalyzer()).thenReturn((Object)queryTimeAnalyzer);
        Mockito.when((Object)this.schema.getFieldTypeByName(fieldTypeName)).thenReturn((Object)highlightedFrenchFieldType);
        Assert.assertSame((Object)indexTimeAnalyzer, (Object)this.classUnderTest.analyzer(language));
        this.classUnderTest = new LanguagePrefixedTokenStream(this.schema, "aFieldName", AlfrescoAnalyzerWrapper.Mode.QUERY);
        Assert.assertSame((Object)queryTimeAnalyzer, (Object)this.classUnderTest.analyzer(language));
    }

    @Test
    public void analyzerInCaseTheHighlightingFieldTypeDoesntExists_shouldFallbackToLocalisedFieldType() {
        String language = "fr";
        String highlightingFieldTypeName = this.classUnderTest.highlightingFieldTypeName(language);
        String localisedFieldTypeName = this.classUnderTest.localisedFieldTypeName(language);
        FieldType localisedFieldType = (FieldType)Mockito.mock(FieldType.class);
        Analyzer queryTimeAnalyzer = (Analyzer)Mockito.mock(Analyzer.class);
        Analyzer indexTimeAnalyzer = (Analyzer)Mockito.mock(Analyzer.class);
        Mockito.when((Object)localisedFieldType.getIndexAnalyzer()).thenReturn((Object)indexTimeAnalyzer);
        Mockito.when((Object)localisedFieldType.getQueryAnalyzer()).thenReturn((Object)queryTimeAnalyzer);
        Mockito.when((Object)this.schema.getFieldTypeByName(highlightingFieldTypeName)).thenReturn(null);
        Mockito.when((Object)this.schema.getFieldTypeByName(localisedFieldTypeName)).thenReturn((Object)localisedFieldType);
        Assert.assertSame((Object)indexTimeAnalyzer, (Object)this.classUnderTest.analyzer(language));
        this.classUnderTest = new LanguagePrefixedTokenStream(this.schema, "aFieldName", AlfrescoAnalyzerWrapper.Mode.QUERY);
        Assert.assertSame((Object)queryTimeAnalyzer, (Object)this.classUnderTest.analyzer(language));
    }

    @Test
    public void analyzerInCaseHighlightAndLocalisedFieldsDontExist_shouldFallbackToTextGeneral() {
        String language = "fr";
        String highlightingFieldTypeName = this.classUnderTest.highlightingFieldTypeName(language);
        String localisedFieldTypeName = this.classUnderTest.localisedFieldTypeName(language);
        FieldType textGeneralFieldType = (FieldType)Mockito.mock(FieldType.class);
        Analyzer queryTimeAnalyzer = (Analyzer)Mockito.mock(Analyzer.class);
        Analyzer indexTimeAnalyzer = (Analyzer)Mockito.mock(Analyzer.class);
        Mockito.when((Object)textGeneralFieldType.getIndexAnalyzer()).thenReturn((Object)indexTimeAnalyzer);
        Mockito.when((Object)textGeneralFieldType.getQueryAnalyzer()).thenReturn((Object)queryTimeAnalyzer);
        Mockito.when((Object)this.schema.getFieldTypeByName(highlightingFieldTypeName)).thenReturn(null);
        Mockito.when((Object)this.schema.getFieldTypeByName(localisedFieldTypeName)).thenReturn(null);
        Mockito.when((Object)this.schema.getFieldTypeByName("text___")).thenReturn((Object)textGeneralFieldType);
        Assert.assertSame((Object)indexTimeAnalyzer, (Object)this.classUnderTest.analyzer(language));
        this.classUnderTest = new LanguagePrefixedTokenStream(this.schema, "aFieldName", AlfrescoAnalyzerWrapper.Mode.QUERY);
        Assert.assertSame((Object)queryTimeAnalyzer, (Object)this.classUnderTest.analyzer(language));
    }

    @Test
    public void languageAndReaderWithNoData() throws IOException {
        StringReader emptyReader = new StringReader("");
        Pair data = this.classUnderTest.languageAndReaderFrom((Reader)emptyReader);
        Assert.assertTrue((boolean)((Optional)data.getFirst()).isEmpty());
    }
}

