/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedAclIdAlfrescoSolrTrackerIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        DistributedAclIdAlfrescoSolrTrackerIT.initSolrServers(2, DistributedAclIdAlfrescoSolrTrackerIT.class.getSimpleName(), DistributedAclIdAlfrescoSolrTrackerIT.getShardMethod());
    }

    @AfterClass
    public static void destroyData() {
        DistributedAclIdAlfrescoSolrTrackerIT.dismissSolrServers();
    }

    @Test
    public void testAclId() throws Exception {
        int i;
        DistributedAclIdAlfrescoSolrTrackerIT.putHandleDefaults();
        int numAcls = 250;
        AclChangeSet bulkAclChangeSet = AlfrescoSolrUtils.getAclChangeSet(numAcls);
        ArrayList<Acl> bulkAcls = new ArrayList<Acl>();
        ArrayList<AclReaders> bulkAclReaders = new ArrayList<AclReaders>();
        for (int i2 = 0; i2 < numAcls; ++i2) {
            Acl bulkAcl = AlfrescoSolrUtils.getAcl(bulkAclChangeSet);
            bulkAcls.add(bulkAcl);
            bulkAclReaders.add(AlfrescoSolrUtils.getAclReaders(bulkAclChangeSet, bulkAcl, Collections.singletonList("joel" + bulkAcl.getId()), Collections.singletonList("phil" + bulkAcl.getId()), null));
        }
        AlfrescoSolrUtils.indexAclChangeSet(bulkAclChangeSet, bulkAcls, bulkAclReaders);
        int numNodes = 1000;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (i = 0; i < numNodes; ++i) {
            int aclIndex = i % numAcls;
            Node node = AlfrescoSolrUtils.getNode(bigTxn, (Acl)bulkAcls.get(aclIndex), Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, (Acl)bulkAcls.get(aclIndex), "mike", null, false);
            nodeMetaDatas.add(nodeMetaData);
        }
        DistributedAclIdAlfrescoSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedAclIdAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes, 100000L);
        DistributedAclIdAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("DOC_TYPE", "Acl")), numAcls, 100000L);
        for (i = 0; i < numAcls; ++i) {
            Acl acl = (Acl)bulkAcls.get(i);
            long aclId = acl.getId();
            QueryResponse response = this.query(DistributedAclIdAlfrescoSolrTrackerIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel" + aclId + "\"], \"tenants\": [ \"\" ]}", DistributedAclIdAlfrescoSolrTrackerIT.params((String[])new String[]{"q", "t1:world", "qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "100", "sort", "id asc", "fq", "{!afts}AUTHORITY_FILTER_FROM_JSON"}));
            DistributedAclIdAlfrescoSolrTrackerIT.assertTrue((response.getResults().getNumFound() > 0L ? 1 : 0) != 0);
        }
    }

    protected static Properties getShardMethod() {
        Random random = DistributedAclIdAlfrescoSolrTrackerIT.random();
        ArrayList<ShardMethodEnum> methods = new ArrayList<ShardMethodEnum>();
        methods.add(ShardMethodEnum.ACL_ID);
        methods.add(ShardMethodEnum.MOD_ACL_ID);
        Collections.shuffle(methods, random);
        Properties prop = new Properties();
        prop.put("shard.method", ((ShardMethodEnum)methods.get(0)).toString());
        return prop;
    }
}

