/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.util.CachingDateFormat;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrQuery;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedDateMonthAlfrescoSolrTrackerIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        DistributedDateMonthAlfrescoSolrTrackerIT.initSolrServers(5, DistributedDateMonthAlfrescoSolrTrackerIT.getSimpleClassName(), DistributedDateMonthAlfrescoSolrTrackerIT.getShardMethod());
    }

    @AfterClass
    public static void destroyData() {
        DistributedDateMonthAlfrescoSolrTrackerIT.dismissSolrServers();
    }

    @Test
    public void testDateMonth() throws Exception {
        DistributedDateMonthAlfrescoSolrTrackerIT.putHandleDefaults();
        int numAcls = 25;
        AclChangeSet bulkAclChangeSet = AlfrescoSolrUtils.getAclChangeSet(numAcls);
        ArrayList<Acl> bulkAcls = new ArrayList<Acl>();
        ArrayList<AclReaders> bulkAclReaders = new ArrayList<AclReaders>();
        for (int i = 0; i < numAcls; ++i) {
            Acl bulkAcl = AlfrescoSolrUtils.getAcl(bulkAclChangeSet);
            bulkAcls.add(bulkAcl);
            bulkAclReaders.add(AlfrescoSolrUtils.getAclReaders(bulkAclChangeSet, bulkAcl, Collections.singletonList("joel" + bulkAcl.getId()), Collections.singletonList("phil" + bulkAcl.getId()), null));
        }
        AlfrescoSolrUtils.indexAclChangeSet(bulkAclChangeSet, bulkAcls, bulkAclReaders);
        int numNodes = 1000;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> nodeMetaData = new ArrayList<NodeMetaData>();
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).setTimeZone(TimeZone.getTimeZone("UTC"));
        Date[] dates = (Date[])IntStream.range(0, 5).peek(index -> calendar.set(1980, index, 21)).mapToObj(index -> calendar.getTime()).toArray(Date[]::new);
        int[] counts = new int[dates.length];
        for (int i = 0; i < numNodes; ++i) {
            int aclIndex = i % numAcls;
            int dateIndex = i % dates.length;
            String dateString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)dates[dateIndex]);
            int n = dateIndex;
            counts[n] = counts[n] + 1;
            Node node = AlfrescoSolrUtils.getNode(bigTxn, (Acl)bulkAcls.get(aclIndex), Node.SolrApiNodeStatus.UPDATED);
            node.setShardPropertyValue(dateString);
            nodes.add(node);
            NodeMetaData metadata = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, (Acl)bulkAcls.get(aclIndex), "mike", null, false);
            metadata.getProperties().put(ContentModel.PROP_CREATED, new StringPropertyValue(dateString));
            nodeMetaData.add(metadata);
        }
        DistributedDateMonthAlfrescoSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaData);
        DistributedDateMonthAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes, 100000L);
        DistributedDateMonthAlfrescoSolrTrackerIT.waitForDocCountAllCores((Query)new TermQuery(new Term("DOC_TYPE", "Acl")), numAcls, 100000L);
        Optional shardProperty = MetadataTracker.getShardProperty((String)"created");
        DistributedDateMonthAlfrescoSolrTrackerIT.assertTrue((boolean)shardProperty.isPresent());
        List fieldInstanceList = AlfrescoSolrDataModel.getInstance().getIndexedFieldNamesForProperty((QName)shardProperty.get()).getFields();
        AlfrescoSolrDataModel.FieldInstance fieldInstance = (AlfrescoSolrDataModel.FieldInstance)fieldInstanceList.get(0);
        String fieldName = fieldInstance.getField();
        SimpleDateFormat format = CachingDateFormat.getSolrDatetimeFormatWithoutMsecs();
        for (int i = 0; i < dates.length; ++i) {
            String startDate = format.format(dates[i]);
            GregorianCalendar gcal = new GregorianCalendar();
            gcal.setTime(dates[i]);
            ((Calendar)gcal).add(13, 1);
            String endDate = format.format(gcal.getTime());
            SolrQuery solrQuery = new SolrQuery("{!lucene}" + DistributedDateMonthAlfrescoSolrTrackerIT.escapeQueryChars(fieldName) + ":[" + DistributedDateMonthAlfrescoSolrTrackerIT.escapeQueryChars(startDate) + " TO " + DistributedDateMonthAlfrescoSolrTrackerIT.escapeQueryChars(endDate) + " } ");
            DistributedDateMonthAlfrescoSolrTrackerIT.assertCountAndColocation(solrQuery, counts[i]);
            DistributedDateMonthAlfrescoSolrTrackerIT.assertShardSequence(i, solrQuery, counts[i]);
        }
        nodes.clear();
        nodeMetaData.clear();
        Transaction bigTxn1 = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (int i = 0; i < numNodes; ++i) {
            int aclIndex = i % numAcls;
            Node node = AlfrescoSolrUtils.getNode(bigTxn1, (Acl)bulkAcls.get(aclIndex), Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            NodeMetaData metadata = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn1, (Acl)bulkAcls.get(aclIndex), "mike", null, false);
            nodeMetaData.add(metadata);
        }
        DistributedDateMonthAlfrescoSolrTrackerIT.indexTransaction(bigTxn1, nodes, nodeMetaData);
        DistributedDateMonthAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes * 2, 100000L);
        DistributedDateMonthAlfrescoSolrTrackerIT.assertNodesPerShardGreaterThan((int)((double)(numNodes * 2) * 0.17));
    }

    private static Properties getShardMethod() {
        Properties prop = new Properties();
        prop.put("shard.method", ShardMethodEnum.DATE.toString());
        prop.put("shard.date.grouping", "1");
        return prop;
    }
}

