/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
@SolrTestCaseJ4.SuppressObjectReleaseTracker(bugUrl="RAMDirectory")
public class DistributedPropertyBasedAlfrescoSolrTrackerIT
extends AbstractAlfrescoDistributedIT {
    private static final String[] DOMAINS = new String[]{"alfresco.com", "king.com", "gmail.com", "yahoo.com", "cookie.es"};
    private static final Map<String, Integer> domainsCount = new HashMap<String, Integer>();

    @BeforeClass
    public static void initData() throws Throwable {
        for (String domain : DOMAINS) {
            domainsCount.put(domain, 0);
        }
        DistributedPropertyBasedAlfrescoSolrTrackerIT.initSolrServers(4, DistributedPropertyBasedAlfrescoSolrTrackerIT.getSimpleClassName(), DistributedPropertyBasedAlfrescoSolrTrackerIT.getProperties());
    }

    @AfterClass
    public static void destroyData() {
        DistributedPropertyBasedAlfrescoSolrTrackerIT.dismissSolrServers();
    }

    @Test
    public void testProperty() throws Exception {
        int i;
        DistributedPropertyBasedAlfrescoSolrTrackerIT.putHandleDefaults();
        int numAcls = 25;
        AclChangeSet bulkAclChangeSet = AlfrescoSolrUtils.getAclChangeSet(numAcls);
        ArrayList<Acl> bulkAcls = new ArrayList<Acl>();
        ArrayList<AclReaders> bulkAclReaders = new ArrayList<AclReaders>();
        for (int i2 = 0; i2 < numAcls; ++i2) {
            Acl bulkAcl = AlfrescoSolrUtils.getAcl(bulkAclChangeSet);
            bulkAcls.add(bulkAcl);
            bulkAclReaders.add(AlfrescoSolrUtils.getAclReaders(bulkAclChangeSet, bulkAcl, Collections.singletonList("king" + bulkAcl.getId()), Collections.singletonList("king" + bulkAcl.getId()), null));
        }
        AlfrescoSolrUtils.indexAclChangeSet(bulkAclChangeSet, bulkAcls, bulkAclReaders);
        int numNodes = 1000;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        RandomizedContext context = RandomizedContext.current();
        Random ints = context.getRandom();
        for (i = 0; i < numNodes; ++i) {
            int aclIndex = i % numAcls;
            Node node = AlfrescoSolrUtils.getNode(bigTxn, (Acl)bulkAcls.get(aclIndex), Node.SolrApiNodeStatus.UPDATED);
            String domain = DOMAINS[ints.nextInt(DOMAINS.length)];
            domainsCount.put(domain, domainsCount.get(domain) + 1);
            String emailAddress = "peter.pan@" + domain;
            node.setShardPropertyValue(emailAddress);
            nodes.add(node);
            NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, (Acl)bulkAcls.get(aclIndex), "king", null, false);
            nodeMetaData.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue(emailAddress));
            nodeMetaDatas.add(nodeMetaData);
        }
        DistributedPropertyBasedAlfrescoSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedPropertyBasedAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes, 100000L);
        DistributedPropertyBasedAlfrescoSolrTrackerIT.waitForDocCountAllCores((Query)new TermQuery(new Term("DOC_TYPE", "Acl")), numAcls, 100000L);
        for (i = 0; i < DOMAINS.length; ++i) {
            DistributedPropertyBasedAlfrescoSolrTrackerIT.assertCountAndColocation((Query)new TermQuery(new Term("text@s____@{http://www.alfresco.org/model/content/1.0}name", "peter.pan@" + DOMAINS[i])), (int)domainsCount.get(DOMAINS[i]));
        }
        nodes.clear();
        nodeMetaDatas.clear();
        DistributedPropertyBasedAlfrescoSolrTrackerIT.deleteByQueryAllClients("*:*");
        DistributedPropertyBasedAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 0, 100000L);
        Transaction bigTxn1 = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (int i3 = 0; i3 < numNodes; ++i3) {
            int aclIndex = i3 % numAcls;
            Node node = AlfrescoSolrUtils.getNode(bigTxn1, (Acl)bulkAcls.get(aclIndex), Node.SolrApiNodeStatus.UPDATED);
            String domain = DOMAINS[ints.nextInt(DOMAINS.length)];
            domainsCount.put(domain, domainsCount.get(domain) + 1);
            String emailAddress = "peter.pan@" + domain;
            nodes.add(node);
            NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn1, (Acl)bulkAcls.get(aclIndex), "king", null, false);
            nodeMetaData.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue(emailAddress));
            nodeMetaDatas.add(nodeMetaData);
        }
        DistributedPropertyBasedAlfrescoSolrTrackerIT.indexTransaction(bigTxn1, nodes, nodeMetaDatas);
        DistributedPropertyBasedAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes, 100000L);
        DistributedPropertyBasedAlfrescoSolrTrackerIT.assertNodesPerShardGreaterThan((int)((double)numNodes * 0.21));
    }

    protected static Properties getProperties() {
        Properties prop = new Properties();
        prop.put("shard.method", ShardMethodEnum.PROPERTY.toString());
        prop.put("shard.regex", "^[A-Za-z0-9._%+-]+@([A-Za-z0-9.-]+\\.[A-Za-z]{2,6})$");
        prop.put("shard.key", ContentModel.PROP_EMAIL.toString());
        return prop;
    }
}

