/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.stream.IntStream;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.ExplicitShardIdWithStaticPropertyRouter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ExplicitShardIdWithStaticPropertyRouterTest {
    private ExplicitShardIdWithStaticPropertyRouter router;
    @Mock
    private Acl acl;
    @Mock
    private Node node;

    @Before
    public void setUp() {
        this.router = new ExplicitShardIdWithStaticPropertyRouter();
    }

    @Test
    public void aclsAreReplicatedAcrossShards() {
        IntStream.range(0, 100).forEach(index -> Assert.assertTrue((boolean)this.router.routeAcl(AlfrescoSolrUtils.randomPositiveInteger(), AlfrescoSolrUtils.randomPositiveInteger(), this.acl)));
    }

    @Test
    public void standaloneModeExplicitShardIdIsNull_shouldReturnFalse() {
        int shardCount = AlfrescoSolrUtils.randomShardCountGreaterThanOne();
        int shardInstance = AlfrescoSolrUtils.randomPositiveInteger();
        Mockito.when((Object)this.node.getExplicitShardId()).thenReturn(null);
        Assert.assertFalse((boolean)this.router.routeNode(shardCount, shardInstance, this.node));
    }

    @Test
    public void composableModeExplicitShardIdIsNull_shouldReturnFalse() {
        this.router = new ExplicitShardIdWithStaticPropertyRouter(false);
        int shardCount = AlfrescoSolrUtils.randomShardCountGreaterThanOne();
        int shardInstance = AlfrescoSolrUtils.randomPositiveInteger();
        Mockito.when((Object)this.node.getExplicitShardId()).thenReturn(null);
        Assert.assertNull((Object)this.router.routeNode(shardCount, shardInstance, this.node));
    }

    @Test
    public void explicitShardMatchesShardInstance() {
        int shardCount = AlfrescoSolrUtils.randomShardCountGreaterThanOne();
        int shardInstance = AlfrescoSolrUtils.randomPositiveInteger();
        Mockito.when((Object)this.node.getExplicitShardId()).thenReturn((Object)shardInstance);
        Assert.assertTrue((boolean)this.router.routeNode(shardCount, shardInstance, this.node));
    }

    @Test
    public void explicitShardDoesntMatchShardInstance() {
        int shardCount = AlfrescoSolrUtils.randomShardCountGreaterThanOne();
        int shardInstance = AlfrescoSolrUtils.randomPositiveInteger();
        Mockito.when((Object)this.node.getExplicitShardId()).thenReturn((Object)shardInstance);
        Assert.assertFalse((boolean)this.router.routeNode(shardCount, shardInstance + 1, this.node));
    }
}

