/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Collection;
import java.util.Set;
import org.alfresco.solr.tracker.AclTracker;
import org.alfresco.solr.tracker.ContentTracker;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.ModelTracker;
import org.alfresco.solr.tracker.Tracker;
import org.alfresco.solr.tracker.TrackerRegistry;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TrackerRegistryTest {
    private static TrackerRegistry reg = new TrackerRegistry();
    private static Tracker aclTracker = new AclTracker();
    private static Tracker contentTracker = new ContentTracker();
    private static Tracker metadataTracker = new MetadataTracker();
    private static Tracker modelTracker = new ModelTracker();
    private static final String CORE_NAME = "coreName";
    private static final String CORE2_NAME = "core2Name";
    private static final String CORE3_NAME = "core3Name";
    private static final String NOT_A_CORE_NAME = "not a core name";

    public static void registerTrackers(String coreName) {
        reg.register(coreName, aclTracker);
        reg.register(coreName, contentTracker);
        reg.register(coreName, metadataTracker);
        reg.register(coreName, modelTracker);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TrackerRegistryTest.registerTrackers(CORE_NAME);
    }

    @Test
    public void testGetCoreNames() {
        Set coreNames = reg.getCoreNames();
        Assert.assertNotNull((Object)coreNames);
        Assert.assertTrue((boolean)coreNames.contains(CORE_NAME));
        Assert.assertEquals((long)1L, (long)coreNames.size());
        TrackerRegistryTest.registerTrackers(CORE2_NAME);
        coreNames = reg.getCoreNames();
        Assert.assertNotNull((Object)coreNames);
        Assert.assertTrue((boolean)coreNames.contains(CORE_NAME));
        Assert.assertFalse((boolean)coreNames.contains(NOT_A_CORE_NAME));
        Assert.assertEquals((long)2L, (long)coreNames.size());
    }

    @Test
    public void testGetTrackersForCore() {
        Collection trackersForCore = reg.getTrackersForCore(CORE_NAME);
        Assert.assertNotNull((Object)trackersForCore);
        Assert.assertFalse((boolean)trackersForCore.isEmpty());
        Assert.assertTrue((boolean)trackersForCore.contains(aclTracker));
        Assert.assertTrue((boolean)trackersForCore.contains(contentTracker));
        Assert.assertTrue((boolean)trackersForCore.contains(modelTracker));
        Assert.assertTrue((boolean)trackersForCore.contains(metadataTracker));
        trackersForCore = reg.getTrackersForCore(NOT_A_CORE_NAME);
        Assert.assertTrue((boolean)trackersForCore.isEmpty());
    }

    @Test
    public void testHasTrackersForCore() {
        Assert.assertTrue((boolean)reg.hasTrackersForCore(CORE_NAME));
        Assert.assertFalse((boolean)reg.hasTrackersForCore(NOT_A_CORE_NAME));
    }

    @Test
    public void testGetTrackerForCore() {
        Assert.assertEquals((Object)aclTracker, (Object)reg.getTrackerForCore(CORE_NAME, AclTracker.class));
        Assert.assertEquals((Object)contentTracker, (Object)reg.getTrackerForCore(CORE_NAME, ContentTracker.class));
        Assert.assertEquals((Object)metadataTracker, (Object)reg.getTrackerForCore(CORE_NAME, MetadataTracker.class));
        Assert.assertEquals((Object)modelTracker, (Object)reg.getTrackerForCore(CORE_NAME, ModelTracker.class));
    }

    @Test
    public void testRemoveTrackersForCore() {
        TrackerRegistryTest.registerTrackers(CORE3_NAME);
        boolean thereWereTrackers = reg.removeTrackersForCore(CORE3_NAME);
        Assert.assertTrue((boolean)thereWereTrackers);
        Assert.assertTrue((boolean)reg.getTrackersForCore(CORE3_NAME).isEmpty());
        thereWereTrackers = reg.removeTrackersForCore(NOT_A_CORE_NAME);
        Assert.assertFalse((boolean)thereWereTrackers);
    }
}

