/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.handler.component.AlfrescoLukeRequestHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AlfrescoLukeRequestHandlerIT {
    private static final BytesRef TERM_TEXT = new BytesRef((CharSequence)"TermText");
    private static final int DOC_ID = 123;
    @Mock
    private Terms mockTerms;
    @Mock
    private TermsEnum mockTermsEnum;
    @Mock
    private PostingsEnum mockPostingsEnum;
    @Mock
    private LeafReader mockReader;
    @Mock
    private Bits mockBits;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockTerms.iterator()).thenReturn((Object)this.mockTermsEnum);
        Mockito.when((Object)this.mockTermsEnum.postings(null, 0)).thenReturn((Object)this.mockPostingsEnum);
    }

    @Test
    public void testFindLiveDoc() throws IOException {
        Mockito.when((Object)this.mockTermsEnum.next()).thenReturn((Object)TERM_TEXT);
        Mockito.when((Object)this.mockPostingsEnum.nextDoc()).thenReturn((Object)123);
        Mockito.when((Object)this.mockPostingsEnum.docID()).thenReturn((Object)123);
        Mockito.when((Object)this.mockReader.getLiveDocs()).thenReturn((Object)this.mockBits);
        Document document = new Document();
        Mockito.when((Object)this.mockReader.document(123)).thenReturn((Object)document);
        Document firstLiveDoc = AlfrescoLukeRequestHandler.getFirstLiveDoc((Terms)this.mockTerms, (LeafReader)this.mockReader);
        InOrder postingsInitialisedCheck = Mockito.inOrder((Object[])new Object[]{this.mockPostingsEnum});
        ((PostingsEnum)postingsInitialisedCheck.verify((Object)this.mockPostingsEnum)).nextDoc();
        ((PostingsEnum)postingsInitialisedCheck.verify((Object)this.mockPostingsEnum, Mockito.atLeastOnce())).docID();
        Assert.assertEquals((String)"Expected to find the document.", (Object)document, (Object)firstLiveDoc);
    }

    @Test
    public void testFindLiveDocWithNoDeletedDocuments() throws IOException {
        Mockito.when((Object)this.mockTermsEnum.next()).thenReturn((Object)TERM_TEXT);
        Mockito.when((Object)this.mockPostingsEnum.nextDoc()).thenReturn((Object)123);
        Mockito.when((Object)this.mockPostingsEnum.docID()).thenReturn((Object)123);
        Mockito.when((Object)this.mockReader.getLiveDocs()).thenReturn(null);
        Document document = new Document();
        Mockito.when((Object)this.mockReader.document(123)).thenReturn((Object)document);
        Document firstLiveDoc = AlfrescoLukeRequestHandler.getFirstLiveDoc((Terms)this.mockTerms, (LeafReader)this.mockReader);
        InOrder postingsInitialisedCheck = Mockito.inOrder((Object[])new Object[]{this.mockPostingsEnum});
        ((PostingsEnum)postingsInitialisedCheck.verify((Object)this.mockPostingsEnum)).nextDoc();
        ((PostingsEnum)postingsInitialisedCheck.verify((Object)this.mockPostingsEnum, Mockito.atLeastOnce())).docID();
        Assert.assertEquals((String)"Expected to find the document.", (Object)document, (Object)firstLiveDoc);
    }

    @Test
    public void testFindLiveDocWithNullTerm() throws IOException {
        Mockito.when((Object)this.mockTermsEnum.next()).thenReturn(null);
        Document firstLiveDoc = AlfrescoLukeRequestHandler.getFirstLiveDoc((Terms)this.mockTerms, (LeafReader)this.mockReader);
        Assert.assertNull((String)"Expected no document to be returned.", (Object)firstLiveDoc);
    }

    @Test
    public void testDocWasDeleted() throws IOException {
        Mockito.when((Object)this.mockTermsEnum.next()).thenReturn((Object)TERM_TEXT);
        Mockito.when((Object)this.mockPostingsEnum.nextDoc()).thenReturn((Object)123);
        Mockito.when((Object)this.mockPostingsEnum.docID()).thenReturn((Object)123);
        Mockito.when((Object)this.mockReader.getLiveDocs()).thenReturn((Object)this.mockBits);
        Document document = new Document();
        Mockito.when((Object)this.mockReader.document(123)).thenReturn((Object)document);
        Mockito.when((Object)this.mockBits.get(123)).thenReturn((Object)true);
        Document firstLiveDoc = AlfrescoLukeRequestHandler.getFirstLiveDoc((Terms)this.mockTerms, (LeafReader)this.mockReader);
        Assert.assertNull((String)"Expected no document to be returned.", (Object)firstLiveDoc);
    }

    @Test
    public void testNoMoreDocs() throws IOException {
        Mockito.when((Object)this.mockTermsEnum.next()).thenReturn((Object)TERM_TEXT);
        Mockito.when((Object)this.mockPostingsEnum.nextDoc()).thenReturn((Object)Integer.MAX_VALUE);
        Document firstLiveDoc = AlfrescoLukeRequestHandler.getFirstLiveDoc((Terms)this.mockTerms, (LeafReader)this.mockReader);
        Assert.assertNull((String)"Expected no document to be returned.", (Object)firstLiveDoc);
    }
}

