/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class SetLocaleComponent
extends SearchComponent {
    private static final Logger log = LoggerFactory.getLogger(SetLocaleComponent.class);

    public void prepare(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        String localeStr = params.get("locale");
        Locale locale = I18NUtil.parseLocale((String)localeStr);
        I18NUtil.setLocale((Locale)locale);
        log.info("Set locale to " + localeStr);
    }

    public void process(ResponseBuilder rb) throws IOException {
    }

    public String getDescription() {
        return "setLocale";
    }

    public String getSource() {
        return "";
    }
}

