/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class TempFileWarningLogger {
    private final Logger log;
    private final Path dir;
    private final String glob;

    public TempFileWarningLogger(Logger log, String prefix, String[] extensions, Path dir) {
        this.log = log;
        this.dir = dir;
        this.glob = prefix + ".{" + StringUtils.arrayToCommaDelimitedString((Object[])extensions) + "}";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public boolean checkFiles() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Looking for temp files matching " + this.glob + " in directory " + String.valueOf(this.dir));
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.dir, this.glob);){
            Iterator<Path> iterator = stream.iterator();
            if (iterator.hasNext()) {
                Path file = iterator.next();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Solr suggester temp file found matching file pattern: " + this.glob + ", path: " + String.valueOf(file));
                    this.log.debug("Removing suggester temp files.");
                }
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create directory stream", e);
        }
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public void removeFiles() {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.dir, this.glob);){
            for (Path file : stream) {
                file.toFile().delete();
            }
        }
        catch (IOException e) {
            this.log.debug("Unable to delete temp file", (Throwable)e);
        }
    }

    protected String getGlob() {
        return this.glob;
    }
}

