/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexSearcher;

public abstract class AbstractAuthorityQueryWeight
extends Weight {
    protected Query query;
    protected SolrIndexSearcher searcher;
    protected float value;
    protected boolean needsScores;

    public AbstractAuthorityQueryWeight(SolrIndexSearcher searcher, boolean needsScores, Query query, String authTermName, String authTermText) throws IOException {
        super(query);
        this.searcher = searcher;
        searcher.collectionStatistics(authTermName);
        IndexReaderContext context = searcher.getTopReaderContext();
        Term term = new Term(authTermName, authTermText);
        TermContext termContext = TermContext.build((IndexReaderContext)context, (Term)term);
        searcher.termStatistics(term, termContext);
        this.needsScores = needsScores;
    }

    public Explanation explain(LeafReaderContext context, int doc) {
        throw new UnsupportedOperationException();
    }

    public float getValueForNormalization() {
        return this.sumOfSquaredWeights();
    }

    public void normalize(float queryNorm, float topLevelBoost) {
    }

    protected float sumOfSquaredWeights() {
        return 0.0f;
    }
}

