/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.query.AbstractQParser;
import org.alfresco.solr.query.PostFilterQuery;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoFTSQParserPlugin
extends QParserPlugin {
    protected static final Logger log = LoggerFactory.getLogger(AlfrescoFTSQParserPlugin.class);
    private NamedList<Object> args;

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new AlfrescoFTSQParser(qstr, localParams, params, req, this.args);
    }

    public void init(NamedList args) {
        this.args = args;
    }

    public static class AlfrescoFTSQParser
    extends AbstractQParser {
        private Log logger = LogFactory.getLog(AlfrescoFTSQParser.class);
        private FTSQueryParser.RerankPhase rerankPhase = FTSQueryParser.RerankPhase.SINGLE_PASS_WITH_AUTO_PHRASE;
        private boolean postfilter;

        public AlfrescoFTSQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req, NamedList<Object> args) {
            super(qstr, localParams, params, req, args);
            Object arg = args.get("rerankPhase");
            if (arg != null) {
                this.rerankPhase = FTSQueryParser.RerankPhase.valueOf((String)arg.toString());
            }
            this.postfilter = Boolean.parseBoolean(System.getProperty("alfresco.postfilter", req.getCore().getCoreDescriptor().getCoreProperty("alfresco.postfilter", "true")));
            this.logger.debug((Object)("Post filter value: " + this.postfilter));
        }

        public Query parse() throws SyntaxError {
            try {
                Pair<SearchParameters, Boolean> searchParametersAndFilter = this.getSearchParameters();
                Query query = AlfrescoSolrDataModel.getInstance().getFTSQuery(searchParametersAndFilter, this.req, this.rerankPhase);
                if (log.isDebugEnabled()) {
                    log.debug("AFTS QP query as lucene:\t    " + String.valueOf(query));
                }
                if (this.authset && this.postfilter) {
                    return new PostFilterQuery(200, query);
                }
                assert (!this.authset || !Boolean.parseBoolean(System.getProperty("alfresco.postfilter", "false")));
                return query;
            }
            catch (ParseException e) {
                throw new SyntaxError((Throwable)e);
            }
        }
    }
}

