/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrDeniedScorer
extends AbstractSolrCachingScorer {
    SolrDeniedScorer(Weight weight, DocSet in, LeafReaderContext context, SolrIndexSearcher searcher) {
        super(weight, in, context, searcher);
    }

    public static SolrDeniedScorer createDenyScorer(Weight weight, LeafReaderContext context, SolrIndexSearcher searcher, String authority) throws IOException {
        DocSet deniedDocs = (DocSet)searcher.cacheLookup("alfrescoDeniedCache", (Object)authority);
        if (deniedDocs == null) {
            DocSet aclDocs = searcher.getDocSet((Query)new TermQuery(new Term("DENIED", authority)));
            deniedDocs = new BitDocSet(new FixedBitSet(searcher.maxDoc()));
            DocIterator it = aclDocs.iterator();
            while (it.hasNext()) {
                int docID = it.nextDoc();
                long aclID = searcher.getSlowAtomicReader().getNumericDocValues("ACLID").get(docID);
                SchemaField schemaField = searcher.getSchema().getField("ACLID");
                Query query = schemaField.getType().getFieldQuery(null, schemaField, Long.toString(aclID));
                DocSet docsForAclId = searcher.getDocSet(query);
                deniedDocs = deniedDocs.union(docsForAclId);
                deniedDocs = deniedDocs.andNot(aclDocs);
            }
            searcher.cacheInsert("alfrescoDeniedCache", (Object)authority, (Object)deniedDocs);
        }
        return new SolrDeniedScorer(weight, deniedDocs, context, searcher);
    }
}

