/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrConstants;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.SolrTestFiles;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.tracker.Tracker;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONValue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.BaseTestHarness;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.TestHarness;
import org.junit.AfterClass;
import org.junit.Assert;
import org.xml.sax.SAXException;

public abstract class AbstractAlfrescoSolrIT
implements SolrTestFiles,
AlfrescoSolrConstants {
    static AlfrescoCoreAdminHandler admin;
    private static Log LOG;
    private static boolean CORE_NOT_YET_CREATED;
    private static String testExecutionSolrHome;
    private static String testSolrCollection;
    private static String testSolrConf;
    private static String templateConf;
    protected static TestHarness h;
    protected static TestHarness.LocalRequestFactory lrf;
    protected static AlfrescoSolrDataModel dataModel;
    protected static NodeRef TEST_ROOT_NODEREF;
    protected static NodeRef TEST_NODEREF;
    protected static Date FTS_TEST_DATE;

    protected static void copyTestFiles() throws IOException {
        File testExecutionFolder = Paths.get(testExecutionSolrHome, new String[0]).toFile();
        for (String s : List.of("/conf", "/alfrescoModels", "/templates", "/collection1")) {
            FileUtils.copyDirectory((File)Paths.get("target/test-classes/test-files" + s, new String[0]).toFile(), (File)Paths.get(String.valueOf(testExecutionFolder) + s, new String[0]).toFile());
        }
    }

    @Deprecated
    protected static String query(SolrQueryRequest req) throws Exception {
        return h.query(req);
    }

    @Deprecated
    protected static SolrQueryResponse queryAndResponse(String handler, SolrQueryRequest req) throws Exception {
        return h.queryAndResponse(handler, req);
    }

    @Deprecated
    protected static void reload() throws Exception {
        h.reload();
    }

    protected void disableIndexing() {
        admin.actionDisableIndexing((SolrParams)new ModifiableSolrParams());
    }

    protected void enableIndexing() {
        admin.actionEnableIndexing((SolrParams)new ModifiableSolrParams());
    }

    @Deprecated
    protected static CoreAdminHandler getMultiCoreHandler() {
        return h.getCore().getCoreContainer().getMultiCoreHandler();
    }

    @Deprecated
    protected static SolrCore getCore() {
        return h.getCore();
    }

    @Deprecated
    protected static String validateUpdate(String update) throws SAXException {
        return h.validateUpdate(update);
    }

    @Deprecated
    protected static String validateErrorUpdate(String update) throws SAXException {
        return h.validateErrorUpdate(update);
    }

    @Deprecated
    public static void initAlfrescoCore(String schema) throws Exception {
        LOG.info((Object)"##################################### init Alfresco core ##############");
        LOG.info((Object)"####initCore");
        System.setProperty("solr.solr.home", "target/test-classes/test-files");
        System.setProperty("solr.directoryFactory", "solr.RAMDirectoryFactory");
        System.setProperty("solr.tests.maxBufferedDocs", "1000");
        System.setProperty("solr.tests.maxIndexingThreads", "10");
        System.setProperty("solr.tests.ramBufferSizeMB", "1024");
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        System.setProperty("alfresco.test", "true");
        System.setProperty("solr.tests.mergeScheduler", "org.apache.lucene.index.ConcurrentMergeScheduler");
        System.setProperty("solr.tests.mergePolicy", "org.apache.lucene.index.TieredMergePolicy");
        if (CORE_NOT_YET_CREATED) {
            testExecutionSolrHome = "target/test-execution-folder/" + System.currentTimeMillis() + "/solrhome";
            testSolrCollection = testExecutionSolrHome + "/collection1";
            testSolrConf = testSolrCollection + "/conf/";
            templateConf = testExecutionSolrHome + "/templates/%s/conf/";
            AbstractAlfrescoSolrIT.copyTestFiles();
            AbstractAlfrescoSolrIT.createAlfrescoCore(schema);
        }
        LOG.info((Object)"####initCore end");
        admin = Optional.of(h).map(TestHarness::getCoreContainer).map(CoreContainer::getMultiCoreHandler).map(AlfrescoCoreAdminHandler.class::cast).orElseThrow(RuntimeException::new);
    }

    @Deprecated
    public static void createAlfrescoCore(String schema) throws ParserConfigurationException, IOException, SAXException {
        Properties properties = new Properties();
        properties.put("solr.tests.maxBufferedDocs", "1000");
        properties.put("solr.tests.maxIndexingThreads", "10");
        properties.put("solr.tests.ramBufferSizeMB", "1024");
        properties.put("solr.tests.mergeScheduler", "org.apache.lucene.index.ConcurrentMergeScheduler");
        properties.put("alfresco.acl.tracker.cron", "0/10 * * * * ? *");
        properties.put("alfresco.content.tracker.cron", "0/10 * * * * ? *");
        properties.put("alfresco.metadata.tracker.cron", "0/10 * * * * ? *");
        properties.put("alfresco.cascade.tracker.cron", "0/10 * * * * ? *");
        properties.put("alfresco.commit.tracker.cron", "0/10 * * * * ? *");
        if ("schema.xml".equalsIgnoreCase(schema)) {
            String templateName = System.getProperty("templateName", "rerank");
            FileUtils.copyFile((File)Paths.get(String.format(templateConf, templateName) + schema, new String[0]).toFile(), (File)Paths.get(testSolrConf + schema, new String[0]).toFile());
        }
        SolrResourceLoader resourceLoader = new SolrResourceLoader(Paths.get(testExecutionSolrHome, new String[0]), null, properties);
        TestHarness.TestCoresLocator locator = new TestHarness.TestCoresLocator("collection1", "data", "solrconfig.xml", schema);
        NodeConfig nodeConfig = new NodeConfig.NodeConfigBuilder("name", resourceLoader).setUseSchemaCache(false).setCoreAdminHandlerClass(AlfrescoCoreAdminHandler.class.getName()).build();
        try {
            h = new TestHarness(nodeConfig, (CoresLocator)locator);
            AbstractAlfrescoSolrIT.h.coreName = "collection1";
            CORE_NOT_YET_CREATED = false;
        }
        catch (Exception e) {
            LOG.info((Object)"we hit an issue", (Throwable)e);
        }
        lrf = h.getRequestFactory("standard", 0, 20, new String[]{"version", "2.2"});
    }

    @AfterClass
    public static void tearDown() throws IOException {
        h.close();
        FileUtils.forceDelete((File)Paths.get("target/test-execution-folder", new String[0]).toFile());
        CORE_NOT_YET_CREATED = true;
    }

    public static String delQ(String q) {
        return TestHarness.deleteByQuery((String)q, (String[])new String[0]);
    }

    public void assertU(String update) {
        this.assertU(null, update);
    }

    public void assertU(String message, String update) {
        this.checkUpdateU(message, update, true);
    }

    public void assertFailedU(String update) {
        this.assertFailedU(null, update);
    }

    public void assertFailedU(String message, String update) {
        this.checkUpdateU(message, update, false);
    }

    private void checkUpdateU(String message, String update, boolean shouldSucceed) {
        try {
            Object m;
            Object object = m = null == message ? "" : message + " ";
            if (shouldSucceed) {
                String res = AbstractAlfrescoSolrIT.validateUpdate(update);
                if (res != null) {
                    Assert.fail((String)((String)m + "update was not successful: " + res));
                }
            } else {
                String res = AbstractAlfrescoSolrIT.validateErrorUpdate(update);
                if (res != null) {
                    Assert.fail((String)((String)m + "update succeeded, but should have failed: " + res));
                }
            }
        }
        catch (SAXException e) {
            throw new RuntimeException("Invalid XML", e);
        }
    }

    public static String commit(String ... args) {
        return TestHarness.commit((String[])args);
    }

    public static String adoc(String ... fieldsAndValues) {
        SolrTestCaseJ4.XmlDoc d = AbstractAlfrescoSolrIT.doc(fieldsAndValues);
        return AlfrescoSolrUtils.add(d, new String[0]);
    }

    public static SolrTestCaseJ4.XmlDoc doc(String ... fieldsAndValues) {
        SolrTestCaseJ4.XmlDoc d = new SolrTestCaseJ4.XmlDoc();
        d.xml = TestHarness.makeSimpleDoc((String[])fieldsAndValues);
        return d;
    }

    public static void assertQ(SolrQueryRequest req, String ... tests) {
        AbstractAlfrescoSolrIT.assertQ(null, req, tests);
    }

    public static void assertQ(String message, SolrQueryRequest req, String ... tests) {
        try {
            String results;
            String response = AbstractAlfrescoSolrIT.query(req);
            if (req.getParams().getBool("facet", false)) {
                String[] allTests = new String[tests.length + 1];
                System.arraycopy(tests, 0, allTests, 1, tests.length);
                allTests[0] = "*[count(//lst[@name='facet_counts']/*[@name='exception'])=0]";
                tests = allTests;
            }
            if (null != (results = BaseTestHarness.validateXPath((String)response, (String[])tests))) {
                String msg = "REQUEST FAILED: xpath=" + results + "\n\txml response was: " + response + "\n\trequest was:" + req.getParamString();
                LOG.error((Object)msg);
                throw new RuntimeException(msg);
            }
        }
        catch (XPathExpressionException e1) {
            throw new RuntimeException("XPath is invalid", e1);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException("Exception during query", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertQueryCollection(String query, Integer[] dbids) throws Exception {
        try (SolrQueryRequest solrReq = AbstractAlfrescoSolrIT.req((SolrParams)AbstractAlfrescoSolrIT.params("rows", "20", "qt", "/cmis", "q", query, "wt", "json"), new String[0]);){
            String response = AbstractAlfrescoSolrIT.query(solrReq);
            JSONObject json = (JSONObject)JSONValue.parse((String)response);
            JSONObject res = (JSONObject)json.get((Object)"response");
            JSONArray docs = (JSONArray)res.get((Object)"docs");
            Assert.assertTrue((dbids.length == docs.size() ? 1 : 0) != 0);
            int count = 0;
            for (Object doc : docs) {
                JSONObject item = (JSONObject)doc;
                BigInteger val = (BigInteger)item.get((Object)"DBID");
                Assert.assertEquals((long)dbids[count].intValue(), (long)val.intValue());
                ++count;
            }
        }
    }

    public SolrServletRequest areq(ModifiableSolrParams params, String json) {
        if (params.get("wt") == null) {
            params.add("wt", new String[]{"xml"});
        }
        SolrServletRequest req = new SolrServletRequest(AbstractAlfrescoSolrIT.getCore(), null);
        req.setParams((SolrParams)params);
        if (json != null) {
            ContentStreamBase.StringStream stream = new ContentStreamBase.StringStream(json);
            ArrayList<ContentStreamBase.StringStream> streams = new ArrayList<ContentStreamBase.StringStream>();
            streams.add(stream);
            req.setContentStreams(streams);
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForDocCount(Query query, long expectedNumFound, long waitMillis) throws Exception {
        Date date = new Date();
        long timeout = date.getTime() + waitMillis;
        RefCounted ref = null;
        int totalHits = 0;
        while (new Date().getTime() < timeout) {
            try {
                ref = AbstractAlfrescoSolrIT.getCore().getSearcher();
                SolrIndexSearcher searcher = (SolrIndexSearcher)ref.get();
                TopDocs topDocs = searcher.search(query, 10);
                totalHits = topDocs.totalHits;
                if ((long)topDocs.totalHits == expectedNumFound) {
                    LOG.warn((Object)("Query \"" + String.valueOf(query) + "\" returned " + totalHits + " as expected"));
                    return;
                }
                LOG.warn((Object)("Query \"" + String.valueOf(query) + "\" returned " + totalHits + ", expected " + expectedNumFound));
                Thread.sleep(2000L);
            }
            finally {
                ref.decref();
            }
        }
        throw new Exception("Wait error expected " + expectedNumFound + " found " + totalHits + " : " + query.toString());
    }

    @Deprecated
    public static SolrQueryRequest req(String ... q) {
        return lrf.makeRequest(q);
    }

    public void indexAclId(long aclId) throws Exception {
        CoreAdminHandler admin = AbstractAlfrescoSolrIT.getMultiCoreHandler();
        SolrQueryResponse resp = new SolrQueryResponse();
        admin.handleRequestBody(AbstractAlfrescoSolrIT.req("action", "INDEX", "name", AbstractAlfrescoSolrIT.getCore().getName(), "aclid", Long.toString(aclId)), resp);
    }

    public void reindexAclId(long aclId) throws Exception {
        CoreAdminHandler admin = AbstractAlfrescoSolrIT.getMultiCoreHandler();
        SolrQueryResponse resp = new SolrQueryResponse();
        admin.handleRequestBody(AbstractAlfrescoSolrIT.req("action", "REINDEX", "name", AbstractAlfrescoSolrIT.getCore().getName(), "aclid", Long.toString(aclId)), resp);
    }

    public static void reindexTransactionId(long txnId) throws Exception {
        CoreAdminHandler admin = AbstractAlfrescoSolrIT.getMultiCoreHandler();
        SolrQueryResponse resp = new SolrQueryResponse();
        admin.handleRequestBody(AbstractAlfrescoSolrIT.req("action", "REINDEX", "name", AbstractAlfrescoSolrIT.getCore().getName(), "txid", Long.toString(txnId)), resp);
    }

    public static void indexTransaction(Transaction transaction, List<Node> nodes, List<NodeMetaData> nodeMetaDatas) {
        SOLRAPIQueueClient.NODE_MAP.put(transaction.getId(), nodes);
        for (NodeMetaData nodeMetaData : nodeMetaDatas) {
            SOLRAPIQueueClient.NODE_META_DATA_MAP.put(nodeMetaData.getId(), nodeMetaData);
        }
        SOLRAPIQueueClient.TRANSACTION_QUEUE.add(transaction);
    }

    public static void indexTransaction(Transaction transaction, List<Node> nodes, List<NodeMetaData> nodeMetaDatas, List<String> content) {
        SOLRAPIQueueClient.NODE_MAP.put(transaction.getId(), nodes);
        int i = 0;
        for (NodeMetaData nodeMetaData : nodeMetaDatas) {
            SOLRAPIQueueClient.NODE_META_DATA_MAP.put(nodeMetaData.getId(), nodeMetaData);
            SOLRAPIQueueClient.NODE_CONTENT_MAP.put(nodeMetaData.getId(), Map.of(ContentModel.PROP_CONTENT, content.get(i++)));
        }
        SOLRAPIQueueClient.TRANSACTION_QUEUE.add(transaction);
    }

    public void purgeAclId(long aclId) throws Exception {
        CoreAdminHandler admin = AbstractAlfrescoSolrIT.getMultiCoreHandler();
        SolrQueryResponse resp = new SolrQueryResponse();
        admin.handleRequestBody(AbstractAlfrescoSolrIT.req("action", "PURGE", "name", AbstractAlfrescoSolrIT.getCore().getName(), "aclid", Long.toString(aclId)), resp);
    }

    public void purgeAclChangeSetId(long aclChangeSetId) throws Exception {
        CoreAdminHandler admin = AbstractAlfrescoSolrIT.getMultiCoreHandler();
        SolrQueryResponse resp = new SolrQueryResponse();
        admin.handleRequestBody(AbstractAlfrescoSolrIT.req("action", "PURGE", "name", AbstractAlfrescoSolrIT.getCore().getName(), "acltxid", Long.toString(aclChangeSetId)), resp);
    }

    public void purgeNodeId(long nodeId) throws Exception {
        CoreAdminHandler admin = AbstractAlfrescoSolrIT.getMultiCoreHandler();
        SolrQueryResponse resp = new SolrQueryResponse();
        admin.handleRequestBody(AbstractAlfrescoSolrIT.req("action", "PURGE", "name", AbstractAlfrescoSolrIT.getCore().getName(), "nodeid", Long.toString(nodeId)), resp);
    }

    public void purgeTransactionId(long txnId) throws Exception {
        CoreAdminHandler admin = AbstractAlfrescoSolrIT.getMultiCoreHandler();
        SolrQueryResponse resp = new SolrQueryResponse();
        admin.handleRequestBody(AbstractAlfrescoSolrIT.req("action", "PURGE", "name", AbstractAlfrescoSolrIT.getCore().getName(), "txid", Long.toString(txnId)), resp);
    }

    public void reindexNodeId(long nodeId) throws Exception {
        CoreAdminHandler admin = AbstractAlfrescoSolrIT.getMultiCoreHandler();
        SolrQueryResponse resp = new SolrQueryResponse();
        admin.handleRequestBody(AbstractAlfrescoSolrIT.req("action", "REINDEX", "name", AbstractAlfrescoSolrIT.getCore().getName(), "nodeid", Long.toString(nodeId)), resp);
    }

    public void reindexAclChangeSetId(long aclChangeSetId) throws Exception {
        CoreAdminHandler admin = AbstractAlfrescoSolrIT.getMultiCoreHandler();
        SolrQueryResponse resp = new SolrQueryResponse();
        admin.handleRequestBody(AbstractAlfrescoSolrIT.req("action", "REINDEX", "name", AbstractAlfrescoSolrIT.getCore().getName(), "acltxid", Long.toString(aclChangeSetId)), resp);
    }

    public void retry() throws Exception {
        CoreAdminHandler admin = AbstractAlfrescoSolrIT.getMultiCoreHandler();
        SolrQueryResponse resp = new SolrQueryResponse();
        admin.handleRequestBody(AbstractAlfrescoSolrIT.req("action", "RETRY", "name", AbstractAlfrescoSolrIT.getCore().getName()), resp);
    }

    public void clearIndex() {
        this.assertU(AbstractAlfrescoSolrIT.delQ("*:*"));
    }

    protected void assertAQuery(String queryString, Integer count) {
        this.assertAQuery(queryString, count, null, null, null, new String[0]);
    }

    protected void assertAQuery(String queryString, int count, Locale locale, String[] textAttributes, String[] allAttributes, String ... name) {
        RefCounted refCounted = null;
        try (SolrServletRequest solrQueryRequest = new SolrServletRequest(AbstractAlfrescoSolrIT.getCore(), null);){
            refCounted = AbstractAlfrescoSolrIT.getCore().getSearcher();
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            SearchParameters searchParameters = new SearchParameters();
            searchParameters.setQuery(queryString);
            if (locale != null) {
                searchParameters.addLocale(locale);
            }
            if (textAttributes != null) {
                for (String textAttribute : textAttributes) {
                    searchParameters.addTextAttribute(textAttribute);
                }
            }
            if (allAttributes != null) {
                for (String allAttribute : allAttributes) {
                    searchParameters.addAllAttribute(allAttribute);
                }
            }
            Query query = dataModel.getLuceneQueryParser(searchParameters, (SolrQueryRequest)solrQueryRequest, FTSQueryParser.RerankPhase.SINGLE_PASS).parse(queryString);
            LOG.debug((Object)("####### Query ######:" + String.valueOf(query)));
            TopDocs docs = solrIndexSearcher.search(query, count * 2 + 10);
            Assert.assertEquals((String)this.fixQueryString(queryString, name), (long)count, (long)docs.totalHits);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
        finally {
            Optional.ofNullable(refCounted).ifPresent(RefCounted::decref);
        }
    }

    private String fixQueryString(String queryString, String ... name) {
        if (name.length > 0) {
            return name[0].replace("\uffff", "<Unicode FFFF>");
        }
        return queryString.replace("\uffff", "<Unicode FFFF>");
    }

    public static SolrQueryRequest req(SolrParams params, String ... moreParams) {
        ModifiableSolrParams mp = new ModifiableSolrParams(params);
        for (int i = 0; i < moreParams.length; i += 2) {
            mp.add(moreParams[i], new String[]{moreParams[i + 1]});
        }
        return new LocalSolrQueryRequest(AbstractAlfrescoSolrIT.getCore(), (SolrParams)mp);
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    protected Collection<Tracker> getTrackers() {
        Collection trackers = admin.getTrackerRegistry().getTrackersForCore(AbstractAlfrescoSolrIT.getCore().getName());
        LOG.info((Object)("######### Number of trackers is " + trackers.size() + " ###########"));
        return trackers;
    }

    protected String escape(QName qname) {
        return this.escape(qname.toString());
    }

    protected String escape(String value) {
        return ClientUtils.escapeQueryChars((String)value);
    }

    static {
        LOG = LogFactory.getLog(AbstractAlfrescoSolrIT.class);
        CORE_NOT_YET_CREATED = true;
        dataModel = AlfrescoSolrDataModel.getInstance();
    }

    public static class SolrServletRequest
    extends SolrQueryRequestBase {
        public SolrServletRequest(SolrCore core, HttpServletRequest req) {
            super(core, (SolrParams)new MultiMapSolrParams(Collections.emptyMap()));
        }
    }
}

