/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.Properties;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.response.SolrQueryResponse;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AdminHandlerDistributedIT
extends AbstractAlfrescoDistributedIT {
    static String testFolder;
    static final String CORE_NAME = "newcoretesting";

    @BeforeClass
    public static void initData() throws Throwable {
        testFolder = AdminHandlerDistributedIT.initSolrServers(2, AdminHandlerDistributedIT.class.getSimpleName(), null);
    }

    @AfterClass
    public static void destroyData() {
        AdminHandlerDistributedIT.dismissSolrServers();
    }

    @Test
    public void newCoreUsingAdminHandler() throws Exception {
        CoreContainer coreContainer = ((JettySolrRunner)jettyContainers.get(testFolder)).getCoreContainer();
        AlfrescoCoreAdminHandler coreAdminHandler = (AlfrescoCoreAdminHandler)coreContainer.getMultiCoreHandler();
        AdminHandlerDistributedIT.assertNotNull((Object)coreAdminHandler);
        SolrCore testingCore = AlfrescoSolrUtils.createCoreUsingTemplate(coreContainer, coreAdminHandler, CORE_NAME, "rerank", 1, 1, new String[0]);
        Properties props = testingCore.getCoreDescriptor().getSubstitutableProperties();
        AdminHandlerDistributedIT.assertEquals((Object)ShardMethodEnum.DB_ID.toString(), (Object)props.get("shard.method"));
        SolrQueryResponse response = AdminHandlerDistributedIT.callHandler(coreAdminHandler, testingCore, "check");
        AdminHandlerDistributedIT.assertNotNull((Object)response);
        response = AdminHandlerDistributedIT.callHandler(coreAdminHandler, testingCore, "summary");
        AlfrescoSolrUtils.assertSummaryCorrect(response, testingCore.getName());
        response = AdminHandlerDistributedIT.callHandler(coreAdminHandler, testingCore, "Report");
        AdminHandlerDistributedIT.assertNotNull((Object)response);
        NamedList report = (NamedList)response.getValues().get("report");
        AdminHandlerDistributedIT.assertNotNull((Object)report.get(CORE_NAME));
        testingCore = AlfrescoSolrUtils.createCoreUsingTemplate(coreContainer, coreAdminHandler, "newcoretestingaclId", "rerank", 1, 1, "property.shard.method", ShardMethodEnum.ACL_ID.toString());
        props = testingCore.getCoreDescriptor().getSubstitutableProperties();
        AdminHandlerDistributedIT.assertEquals((Object)ShardMethodEnum.ACL_ID.toString(), (Object)props.get("shard.method"));
    }
}

