/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.SolrInformationServer;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.adapters.IOpenBitSet;
import org.alfresco.solr.adapters.SolrOpenBitSetAdapter;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.AclTracker;
import org.alfresco.solr.tracker.IndexHealthReport;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.TrackerRegistry;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AlfrescoCoreAdminHandlerTest {
    private AlfrescoCoreAdminHandler admin;
    @Mock
    TrackerRegistry registry;
    private ModifiableSolrParams params;

    @Before
    public void setUp() {
        this.admin = new AlfrescoCoreAdminHandler();
        this.admin.trackerRegistry = this.registry;
        Mockito.when((Object)this.registry.getCoreNames()).thenReturn(Set.of("alfresco", "archive"));
        this.params = new ModifiableSolrParams();
    }

    @Test
    public void noTargetCoreToFixInParams() {
        Assert.assertEquals((long)0L, (long)this.params.size());
        NamedList actionResponse = this.admin.actionFIX((SolrParams)this.params);
        Assert.assertEquals((long)0L, (long)actionResponse.size());
    }

    @Test
    public void unknownTargetCoreToFixInParams() {
        String invalidCoreName = "thisIsAnInvalidOrAtLeastUnknownCoreName";
        this.params.set("core", new String[]{invalidCoreName});
        NamedList actionResponse = this.admin.actionFIX((SolrParams)this.params);
        Assert.assertEquals((long)1L, (long)actionResponse.size());
        Assert.assertEquals((Object)("Unknown core:" + invalidCoreName), (Object)actionResponse.get("errorMessage"));
    }

    @Test
    public void fixOnSlaveNodeHasNoEffect() {
        this.params.set("core", new String[]{"alfresco"});
        Assert.assertFalse((boolean)this.admin.isMasterOrStandalone("alfresco"));
        NamedList actionResponse = this.admin.actionFIX((SolrParams)this.params);
        Assert.assertEquals((long)1L, (long)actionResponse.size());
        Assert.assertEquals((Object)"Requested action cannot be performed on slave nodes.", (Object)actionResponse.get("errorMessage"));
    }

    @Test
    public void maxTransactionScheduledParameterIsNotNull() {
        int expectedMaxTransactionToSchedule = 12876;
        this.params.set("core", new String[]{"alfresco"});
        this.params.set("maxScheduledTransactions", expectedMaxTransactionToSchedule);
        this.admin = new AlfrescoCoreAdminHandler();
        Assert.assertEquals((long)expectedMaxTransactionToSchedule, (long)this.admin.getMaxTransactionToSchedule((SolrParams)this.params));
    }

    @Test
    public void maxTransactionScheduledIsNull_shouldBeGatheredFromCoreProperties() {
        this.params.set("core", new String[]{"alfresco"});
        int expectedMaxTransactionToSchedule = 17892;
        Properties coreProperties = new Properties();
        coreProperties.setProperty("alfresco.admin.fix.maxScheduledTransactions", String.valueOf(expectedMaxTransactionToSchedule));
        CoreContainer coreContainer = (CoreContainer)Mockito.mock(CoreContainer.class);
        SolrCore core = (SolrCore)Mockito.mock(SolrCore.class);
        SolrResourceLoader resourceLoader = (SolrResourceLoader)Mockito.mock(SolrResourceLoader.class);
        Mockito.when((Object)coreContainer.getCore("alfresco")).thenReturn((Object)core);
        Mockito.when((Object)core.getResourceLoader()).thenReturn((Object)resourceLoader);
        Mockito.when((Object)resourceLoader.getCoreProperties()).thenReturn((Object)coreProperties);
        this.admin = new AlfrescoCoreAdminHandler(coreContainer);
        Assert.assertEquals((long)expectedMaxTransactionToSchedule, (long)this.admin.getMaxTransactionToSchedule((SolrParams)this.params));
    }

    @Test
    public void maxTransactionScheduledParameterAndConfigurationIsNull_shouldGetTheHardCodedDefault() {
        this.params.set("core", new String[]{"alfresco"});
        Properties coreProperties = new Properties();
        CoreContainer coreContainer = (CoreContainer)Mockito.mock(CoreContainer.class);
        SolrCore core = (SolrCore)Mockito.mock(SolrCore.class);
        SolrResourceLoader resourceLoader = (SolrResourceLoader)Mockito.mock(SolrResourceLoader.class);
        Mockito.when((Object)coreContainer.getCore("alfresco")).thenReturn((Object)core);
        Mockito.when((Object)core.getResourceLoader()).thenReturn((Object)resourceLoader);
        Mockito.when((Object)resourceLoader.getCoreProperties()).thenReturn((Object)coreProperties);
        this.admin = new AlfrescoCoreAdminHandler(coreContainer);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.admin.getMaxTransactionToSchedule((SolrParams)this.params));
    }

    @Test
    public void masterOrStandaloneNode_implicitDryRunParameterIsEchoed() {
        this.admin = new AlfrescoCoreAdminHandler(){

            NamedList<Object> fixOnSpecificCore(String coreName, Long fromTxCommitTime, Long toTxCommitTime, boolean dryRun, int maxTransactionsToSchedule) {
                return new NamedList();
            }

            boolean isMasterOrStandalone(String coreName) {
                return true;
            }
        };
        this.admin.trackerRegistry = this.registry;
        this.params.set("core", new String[]{"alfresco"});
        NamedList actionResponse = this.admin.actionFIX((SolrParams)this.params);
        Assert.assertEquals((Object)true, (Object)actionResponse.get("dryRun"));
        Assert.assertEquals((Object)"notScheduled", (Object)actionResponse.get("status"));
    }

    @Test
    public void masterOrStandaloneNodeWithTrackersDisabled_DryRunParameterShouldBeForcedToTrue() {
        this.admin = new AlfrescoCoreAdminHandler(){

            NamedList<Object> fixOnSpecificCore(String coreName, Long fromTxCommitTime, Long toTxCommitTime, boolean dryRun, int maxTransactionsToSchedule) {
                return new NamedList();
            }

            boolean isMasterOrStandalone(String coreName) {
                return true;
            }
        };
        this.admin.trackerRegistry = this.registry;
        class TestMetadataTracker
        extends MetadataTracker {
            protected TestMetadataTracker() {
                super(new Properties(), (SOLRAPIClient)Mockito.mock(SOLRAPIClient.class), "alfresco", (InformationServer)Mockito.mock(InformationServer.class));
                this.state = new TrackerState();
            }

            protected void doTrack(String iterationId) {
            }
        }
        TestMetadataTracker metadataTracker = new TestMetadataTracker();
        class TestAclTracker
        extends AclTracker {
            protected TestAclTracker() {
                super(new Properties(), (SOLRAPIClient)Mockito.mock(SOLRAPIClient.class), "alfresco", (InformationServer)Mockito.mock(InformationServer.class));
                this.state = new TrackerState();
            }

            protected void doTrack(String iterationId) {
            }
        }
        TestAclTracker aclTracker = new TestAclTracker();
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("alfresco", MetadataTracker.class))).thenReturn((Object)metadataTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("alfresco", AclTracker.class))).thenReturn((Object)aclTracker);
        Mockito.when((Object)this.registry.getTrackersForCore("alfresco")).thenReturn(List.of(metadataTracker, aclTracker));
        this.params.set("core", new String[]{"alfresco"});
        this.admin.actionDisableIndexing((SolrParams)this.params);
        this.params.set("dryRun", false);
        NamedList actionResponse = this.admin.actionFIX((SolrParams)this.params);
        Assert.assertEquals((Object)false, (Object)actionResponse.get("dryRun"));
        Assert.assertEquals((Object)"notScheduled", (Object)actionResponse.get("status"));
        Assert.assertNotNull((String)"There should be a message which informs the requestor about the actual dryRun execution", (Object)actionResponse.get("additionalInfo"));
    }

    @Test
    public void masterOrStandaloneNode_explicitDryRunParameterIsEchoed() {
        this.assertThatExplicitParameterIsEchoed("dryRun", true);
        this.assertThatExplicitParameterIsEchoed("dryRun", false);
    }

    @Test
    public void masterOrStandaloneNode_explicitFromCommitTimeParameterIsEchoed() {
        this.assertThatExplicitParameterIsEchoed("fromTxCommitTime", System.currentTimeMillis());
    }

    @Test
    public void masterOrStandaloneNode_explicitToCommitTimeParameterIsEchoed() {
        this.assertThatExplicitParameterIsEchoed("toTxCommitTime", System.currentTimeMillis());
    }

    @Test
    public void masterOrStandaloneNode_explicitMaxTransactionsToScheduleParameterIsEchoed() {
        this.assertThatExplicitParameterIsEchoed("maxScheduledTransactions", Integer.MAX_VALUE);
    }

    @Test
    public void manageTransactionsToBeFixed_shouldRespectTheInputGlobalLimit() {
        AtomicInteger limit = new AtomicInteger(4);
        AtomicInteger transactionCount = new AtomicInteger();
        SolrOpenBitSetAdapter transactions = new SolrOpenBitSetAdapter();
        IntStream.range(1, 7).forEach(arg_0 -> ((IOpenBitSet)transactions).set(arg_0));
        Consumer<Long> counter = tx -> transactionCount.incrementAndGet();
        this.admin.manageTransactionsToBeFixed((IOpenBitSet)transactions, tx -> 0, counter, limit);
        Assert.assertEquals((long)-1L, (long)limit.get());
        Assert.assertEquals((long)4L, (long)transactionCount.get());
    }

    @Test
    public void subsequentInvocationsToManageTransactionsToBeFixed_shouldRespectTheInputGlobalLimit() {
        AtomicInteger limit = new AtomicInteger(13);
        AtomicInteger transactionCount = new AtomicInteger();
        SolrOpenBitSetAdapter firstTransactionSet = new SolrOpenBitSetAdapter();
        IntStream.range(1, 7).forEach(arg_0 -> ((IOpenBitSet)firstTransactionSet).set(arg_0));
        Consumer<Long> counter = tx -> transactionCount.incrementAndGet();
        this.admin.manageTransactionsToBeFixed((IOpenBitSet)firstTransactionSet, tx -> 0, counter, limit);
        Assert.assertEquals((long)7L, (long)limit.get());
        Assert.assertEquals((long)6L, (long)transactionCount.get());
        SolrOpenBitSetAdapter secondTransactionSet = new SolrOpenBitSetAdapter();
        IntStream.range(10, 21).forEach(arg_0 -> ((IOpenBitSet)secondTransactionSet).set(arg_0));
        this.admin.manageTransactionsToBeFixed((IOpenBitSet)secondTransactionSet, tx -> 0, counter, limit);
        Assert.assertEquals((String)"Global transaction limit should have been exceeded", (long)-1L, (long)limit.get());
        Assert.assertEquals((long)13L, (long)transactionCount.get());
        SolrOpenBitSetAdapter thirdTransactionSet = new SolrOpenBitSetAdapter();
        IntStream.range(31, 42).forEach(arg_0 -> ((IOpenBitSet)thirdTransactionSet).set(arg_0));
        Consumer<Long> thisShoulndtBeInvoked = tx -> {
            throw new RuntimeException("We should never be here, as the global limit has been already exceeded.");
        };
        this.admin.manageTransactionsToBeFixed((IOpenBitSet)thirdTransactionSet, tx -> 0, thisShoulndtBeInvoked, limit);
        Assert.assertEquals((long)-2L, (long)limit.get());
        Assert.assertEquals((long)13L, (long)transactionCount.get());
    }

    @Test
    public void noAclTransactionToReindex_shouldReturnAnEmptyResponse() {
        IndexHealthReport emptyReport = (IndexHealthReport)Mockito.mock(IndexHealthReport.class);
        Mockito.when((Object)emptyReport.getAclTxInIndexButNotInDb()).thenReturn((Object)new SolrOpenBitSetAdapter());
        Mockito.when((Object)emptyReport.getDuplicatedAclTxInIndex()).thenReturn((Object)new SolrOpenBitSetAdapter());
        Mockito.when((Object)emptyReport.getMissingAclTxFromIndex()).thenReturn((Object)new SolrOpenBitSetAdapter());
        NamedList subReport = this.admin.aclTxToReindex("alfresco", (AclTracker)Mockito.mock(AclTracker.class), emptyReport, tx -> {}, Integer.MAX_VALUE);
        Assert.assertEquals((Object)0L, (Object)Optional.of(subReport.get("aclTxInIndexNotInDb")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("aclTxInIndexNotInDb section not found in response.")));
        Assert.assertEquals((Object)0L, (Object)Optional.of(subReport.get("duplicatedAclTxInIndex")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("duplicatedAclTxInIndex section not found in response.")));
        Assert.assertEquals((Object)0L, (Object)Optional.of(subReport.get("missingAclTxInIndex")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("missingAclTxInIndex section not found in response.")));
    }

    @Test
    public void noTransactionToReindex_shouldReturnAnEmptyResponse() {
        IndexHealthReport emptyReport = (IndexHealthReport)Mockito.mock(IndexHealthReport.class);
        Mockito.when((Object)emptyReport.getTxInIndexButNotInDb()).thenReturn((Object)new SolrOpenBitSetAdapter());
        Mockito.when((Object)emptyReport.getDuplicatedTxInIndex()).thenReturn((Object)new SolrOpenBitSetAdapter());
        Mockito.when((Object)emptyReport.getMissingTxFromIndex()).thenReturn((Object)new SolrOpenBitSetAdapter());
        NamedList subReport = this.admin.txToReindex("alfresco", (MetadataTracker)Mockito.mock(MetadataTracker.class), emptyReport, tx -> {}, Integer.MAX_VALUE);
        Assert.assertEquals((Object)0L, (Object)Optional.of(subReport.get("txInIndexNotInDb")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("txInIndexNotInDb section not found in response.")));
        Assert.assertEquals((Object)0L, (Object)Optional.of(subReport.get("duplicatedTxInIndex")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("duplicatedTxInIndex section not found in response.")));
        Assert.assertEquals((Object)0L, (Object)Optional.of(subReport.get("missingTxInIndex")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("missingTxInIndex section not found in response.")));
    }

    @Test
    public void maxTransactionsGlobalLimitShouldBeAppliedInCascade() {
        SolrInformationServer server = (SolrInformationServer)Mockito.mock(SolrInformationServer.class);
        Mockito.when((Object)server.getDocListSize(ArgumentMatchers.anyString())).thenReturn((Object)0);
        ConcurrentHashMap<String, SolrInformationServer> informationServers = new ConcurrentHashMap<String, SolrInformationServer>();
        informationServers.put("alfresco", server);
        this.admin.informationServers = informationServers;
        SolrOpenBitSetAdapter txInIndexButNotInDb = new SolrOpenBitSetAdapter();
        SolrOpenBitSetAdapter duplicatedTxInIndex = new SolrOpenBitSetAdapter();
        SolrOpenBitSetAdapter missingTxFromIndex = new SolrOpenBitSetAdapter();
        IntStream.range(1, 10).forEach(arg_0 -> ((IOpenBitSet)txInIndexButNotInDb).set(arg_0));
        IntStream.range(21, 32).forEach(arg_0 -> ((IOpenBitSet)duplicatedTxInIndex).set(arg_0));
        IntStream.range(50, 61).forEach(arg_0 -> ((IOpenBitSet)missingTxFromIndex).set(arg_0));
        int maxTransactionToSchedule = (int)(txInIndexButNotInDb.cardinality() + duplicatedTxInIndex.cardinality() + missingTxFromIndex.cardinality() - 5L);
        IndexHealthReport emptyReport = (IndexHealthReport)Mockito.mock(IndexHealthReport.class);
        Mockito.when((Object)emptyReport.getTxInIndexButNotInDb()).thenReturn((Object)txInIndexButNotInDb);
        Mockito.when((Object)emptyReport.getDuplicatedTxInIndex()).thenReturn((Object)duplicatedTxInIndex);
        Mockito.when((Object)emptyReport.getMissingTxFromIndex()).thenReturn((Object)missingTxFromIndex);
        NamedList subReport = this.admin.txToReindex("alfresco", (MetadataTracker)Mockito.mock(MetadataTracker.class), emptyReport, tx -> {}, maxTransactionToSchedule);
        Assert.assertEquals((Object)txInIndexButNotInDb.cardinality(), (Object)Optional.of(subReport.get("txInIndexNotInDb")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("txInIndexNotInDb section not found in response.")));
        Assert.assertEquals((Object)duplicatedTxInIndex.cardinality(), (Object)Optional.of(subReport.get("duplicatedTxInIndex")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("duplicatedTxInIndex section not found in response.")));
        Assert.assertEquals((Object)(missingTxFromIndex.cardinality() - 5L), (Object)Optional.of(subReport.get("missingTxInIndex")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("missingTxInIndex section not found in response.")));
    }

    @Test
    public void maxAclTransactionsGlobalLimitShouldBeAppliedInCascade() {
        SolrInformationServer server = (SolrInformationServer)Mockito.mock(SolrInformationServer.class);
        Mockito.when((Object)server.getDocListSize(ArgumentMatchers.anyString())).thenReturn((Object)0);
        ConcurrentHashMap<String, SolrInformationServer> informationServers = new ConcurrentHashMap<String, SolrInformationServer>();
        informationServers.put("alfresco", server);
        this.admin.informationServers = informationServers;
        SolrOpenBitSetAdapter txInIndexButNotInDb = new SolrOpenBitSetAdapter();
        SolrOpenBitSetAdapter duplicatedTxInIndex = new SolrOpenBitSetAdapter();
        SolrOpenBitSetAdapter missingTxFromIndex = new SolrOpenBitSetAdapter();
        IntStream.range(1, 10).forEach(arg_0 -> ((IOpenBitSet)txInIndexButNotInDb).set(arg_0));
        IntStream.range(21, 32).forEach(arg_0 -> ((IOpenBitSet)duplicatedTxInIndex).set(arg_0));
        IntStream.range(50, 61).forEach(arg_0 -> ((IOpenBitSet)missingTxFromIndex).set(arg_0));
        int maxTransactionToSchedule = (int)(txInIndexButNotInDb.cardinality() + duplicatedTxInIndex.cardinality() + missingTxFromIndex.cardinality() - 5L);
        IndexHealthReport emptyReport = (IndexHealthReport)Mockito.mock(IndexHealthReport.class);
        Mockito.when((Object)emptyReport.getAclTxInIndexButNotInDb()).thenReturn((Object)txInIndexButNotInDb);
        Mockito.when((Object)emptyReport.getDuplicatedAclTxInIndex()).thenReturn((Object)duplicatedTxInIndex);
        Mockito.when((Object)emptyReport.getMissingAclTxFromIndex()).thenReturn((Object)missingTxFromIndex);
        NamedList subReport = this.admin.aclTxToReindex("alfresco", (AclTracker)Mockito.mock(AclTracker.class), emptyReport, tx -> {}, maxTransactionToSchedule);
        Assert.assertEquals((Object)txInIndexButNotInDb.cardinality(), (Object)Optional.of(subReport.get("aclTxInIndexNotInDb")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("aclTxInIndexNotInDb section not found in response.")));
        Assert.assertEquals((Object)duplicatedTxInIndex.cardinality(), (Object)Optional.of(subReport.get("duplicatedAclTxInIndex")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("duplicatedAclTxInIndex section not found in response.")));
        Assert.assertEquals((Object)(missingTxFromIndex.cardinality() - 5L), (Object)Optional.of(subReport.get("missingAclTxInIndex")).map(NamedList.class::cast).map(NamedList::size).map(Number::longValue).orElseThrow(() -> new RuntimeException("missingAclTxInIndex section not found in response.")));
    }

    @Test
    public void disableIndexingActionParameter_shouldTriggerTheDisableIndexingAction() {
        final AtomicBoolean invocationMarker = new AtomicBoolean();
        this.admin = new AlfrescoCoreAdminHandler(){

            NamedList<Object> fixOnSpecificCore(String coreName, Long fromTxCommitTime, Long toTxCommitTime, boolean dryRun, int maxTransactionsToSchedule) {
                return new NamedList();
            }

            NamedList<Object> actionDisableIndexing(SolrParams params) throws JSONException {
                invocationMarker.set(true);
                return new SimpleOrderedMap();
            }
        };
        this.params.set("action", new String[]{"DISABLE-INDEXING"});
        SolrQueryRequest request = (SolrQueryRequest)Mockito.mock(SolrQueryRequest.class);
        Mockito.when((Object)request.getParams()).thenReturn((Object)this.params);
        this.admin.handleCustomAction(request, (SolrQueryResponse)Mockito.mock(SolrQueryResponse.class));
        Assert.assertTrue((boolean)invocationMarker.get());
    }

    @Test
    public void enableIndexingActionParameter_shouldTriggerTheIndexingEnabling() {
        final AtomicBoolean invocationMarker = new AtomicBoolean();
        this.admin = new AlfrescoCoreAdminHandler(){

            NamedList<Object> fixOnSpecificCore(String coreName, Long fromTxCommitTime, Long toTxCommitTime, boolean dryRun, int maxTransactionsToSchedule) {
                return new NamedList();
            }

            NamedList<Object> actionEnableIndexing(SolrParams params) throws JSONException {
                invocationMarker.set(true);
                return new SimpleOrderedMap();
            }
        };
        this.params.set("action", new String[]{"ENABLE-INDEXING"});
        SolrQueryRequest request = (SolrQueryRequest)Mockito.mock(SolrQueryRequest.class);
        Mockito.when((Object)request.getParams()).thenReturn((Object)this.params);
        this.admin.handleCustomAction(request, (SolrQueryResponse)Mockito.mock(SolrQueryResponse.class));
        Assert.assertTrue((boolean)invocationMarker.get());
    }

    @Test
    public void unknownCoreNameInDisableIndexingCommand_shouldReturnAnErrorResponse() {
        String unknownCoreName = "ThisShouldBeAnInexistentCore";
        AlfrescoCoreAdminHandler.CORE_PARAMETER_NAMES.forEach(parameter -> {
            this.params.set(parameter, new String[]{unknownCoreName});
            NamedList response = this.admin.actionDisableIndexing((SolrParams)this.params);
            Assert.assertEquals((Object)("Unknown core:" + unknownCoreName), (Object)response.get("errorMessage"));
        });
    }

    @Test
    public void unknownCoreNameInEnableIndexingCommand_shouldReturnAnErrorResponse() {
        String unknownCoreName = "ThisShouldBeAnInexistentCore";
        AlfrescoCoreAdminHandler.CORE_PARAMETER_NAMES.forEach(parameter -> {
            this.params.set(parameter, new String[]{unknownCoreName});
            NamedList response = this.admin.actionEnableIndexing((SolrParams)this.params);
            Assert.assertEquals((Object)("Unknown core:" + unknownCoreName), (Object)response.get("errorMessage"));
        });
    }

    @Test
    public void disableIndexingOnSpecificSlaveCore_shouldReturnAnErrorResponse() {
        Assert.assertFalse((boolean)this.admin.isMasterOrStandalone("alfresco"));
        AlfrescoCoreAdminHandler.CORE_PARAMETER_NAMES.forEach(parameter -> {
            this.params.set(parameter, new String[]{"alfresco"});
            NamedList response = this.admin.actionDisableIndexing((SolrParams)this.params);
            Assert.assertEquals((Object)"Requested action cannot be performed on slave nodes.", (Object)response.get("errorMessage"));
        });
    }

    @Test
    public void enableIndexingOnSpecificSlaveCore_shouldReturnAnErrorResponse() {
        Assert.assertFalse((boolean)this.admin.isMasterOrStandalone("alfresco"));
        AlfrescoCoreAdminHandler.CORE_PARAMETER_NAMES.forEach(parameter -> {
            this.params.set(parameter, new String[]{"alfresco"});
            NamedList response = this.admin.actionEnableIndexing((SolrParams)this.params);
            Assert.assertEquals((Object)"Requested action cannot be performed on slave nodes.", (Object)response.get("errorMessage"));
        });
    }

    @Test
    public void disableIndexingWithoutIndicatingSpecificCore_shouldHaveNoEffectIfAllCoresAreSlave() {
        this.admin = (AlfrescoCoreAdminHandler)Mockito.spy((Object)new AlfrescoCoreAdminHandler());
        this.admin.trackerRegistry = this.registry;
        Mockito.when((Object)this.registry.getCoreNames()).thenReturn(Set.of("alfresco", "archive"));
        this.admin.actionDisableIndexing((SolrParams)this.params);
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)0))).disableIndexingOnSpecificCore(ArgumentMatchers.anyString());
    }

    @Test
    public void enableIndexingWithoutIndicatingSpecificCore_shouldHaveNoEffectIfAllCoresAreSlave() {
        this.admin = (AlfrescoCoreAdminHandler)Mockito.spy((Object)new AlfrescoCoreAdminHandler());
        this.admin.trackerRegistry = this.registry;
        Mockito.when((Object)this.registry.getCoreNames()).thenReturn(Set.of("alfresco", "archive"));
        this.admin.actionEnableIndexing((SolrParams)this.params);
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)0))).enableIndexingOnSpecificCore(ArgumentMatchers.anyString());
    }

    @Test
    public void disableIndexingWithoutIndicatingSpecificCore_shouldAffectOnlyMasterOrStandaloneCores() {
        this.admin = (AlfrescoCoreAdminHandler)Mockito.spy((Object)new AlfrescoCoreAdminHandler());
        this.admin.trackerRegistry = this.registry;
        Mockito.when((Object)this.registry.getCoreNames()).thenReturn(Set.of("alfresco", "archive", "version"));
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("alfresco", MetadataTracker.class))).thenReturn((Object)((MetadataTracker)Mockito.mock(MetadataTracker.class)));
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("archive", MetadataTracker.class))).thenReturn((Object)((MetadataTracker)Mockito.mock(MetadataTracker.class)));
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("version", MetadataTracker.class))).thenReturn(null);
        this.admin.actionDisableIndexing((SolrParams)this.params);
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).disableIndexingOnSpecificCore("alfresco");
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).disableIndexingOnSpecificCore("archive");
    }

    @Test
    public void enableIndexingWithoutIndicatingSpecificCore_shouldAffectOnlyMasterOrStandaloneCores() {
        this.admin = (AlfrescoCoreAdminHandler)Mockito.spy((Object)new AlfrescoCoreAdminHandler());
        this.admin.trackerRegistry = this.registry;
        Mockito.when((Object)this.registry.getCoreNames()).thenReturn(Set.of("alfresco", "archive", "version"));
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("alfresco", MetadataTracker.class))).thenReturn((Object)((MetadataTracker)Mockito.mock(MetadataTracker.class)));
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("archive", MetadataTracker.class))).thenReturn((Object)((MetadataTracker)Mockito.mock(MetadataTracker.class)));
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("version", MetadataTracker.class))).thenReturn(null);
        this.admin.actionEnableIndexing((SolrParams)this.params);
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).enableIndexingOnSpecificCore("alfresco");
        ((AlfrescoCoreAdminHandler)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).enableIndexingOnSpecificCore("archive");
    }

    @Test
    public void retryActionOnSlaveNode_shouldReturnWarningMessage() {
        this.admin.coreNames().forEach(coreName -> Assert.assertFalse((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionRETRY((SolrParams)this.params);
        Assert.assertNotNull((Object)actionResponse.get("WARNING"));
    }

    @Test
    public void retryActionWhenIndexingIsDisabled_shouldReturnAnInfoMessage() {
        InformationServer srv = (InformationServer)Mockito.mock(InformationServer.class);
        this.admin.informationServers = new ConcurrentHashMap();
        this.admin.informationServers.put("alfresco", srv);
        this.admin.informationServers.put("archive", srv);
        MetadataTracker metadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("alfresco", MetadataTracker.class))).thenReturn((Object)metadataTracker);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("archive", MetadataTracker.class))).thenReturn((Object)metadataTracker);
        Mockito.when((Object)metadataTracker.isEnabled()).thenReturn((Object)false);
        this.admin.coreNames().forEach(coreName -> Assert.assertTrue((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionRETRY((SolrParams)this.params);
        this.admin.coreNames().stream().map(arg_0 -> ((NamedList)actionResponse).get(arg_0)).map(NamedList.class::cast).forEach(response -> {
            Assert.assertEquals((Object)"notScheduled", (Object)response.get("status"));
            Assert.assertNotNull((Object)response.get("additionalInfo"));
        });
        Mockito.verifyNoInteractions((Object[])new Object[]{srv});
    }

    @Test
    public void retryActionWhenIndexingIsEnabled_shouldCollectThingsToReindex() throws Exception {
        Set<Long> alfrescoErrorNodeIds = Set.of(Long.valueOf(123452L), Long.valueOf(13579L), Long.valueOf(24680L), Long.valueOf(98765L));
        Set<Long> archiveErrorNodeIds = Set.of(Long.valueOf(1234520L), Long.valueOf(913579L), Long.valueOf(124680L), Long.valueOf(598765L));
        InformationServer alfrescoInformationServer = (InformationServer)Mockito.mock(InformationServer.class);
        InformationServer archiveInformationServer = (InformationServer)Mockito.mock(InformationServer.class);
        this.admin.informationServers = new ConcurrentHashMap();
        this.admin.informationServers.put("alfresco", alfrescoInformationServer);
        this.admin.informationServers.put("archive", archiveInformationServer);
        Mockito.when((Object)alfrescoInformationServer.getErrorDocIds()).thenReturn(alfrescoErrorNodeIds);
        Mockito.when((Object)archiveInformationServer.getErrorDocIds()).thenReturn(archiveErrorNodeIds);
        MetadataTracker alfrescoMetadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        MetadataTracker archiveMetadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("alfresco", MetadataTracker.class))).thenReturn((Object)alfrescoMetadataTracker);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("archive", MetadataTracker.class))).thenReturn((Object)archiveMetadataTracker);
        Mockito.when((Object)alfrescoMetadataTracker.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)archiveMetadataTracker.isEnabled()).thenReturn((Object)true);
        this.admin.coreNames().forEach(coreName -> Assert.assertTrue((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionRETRY((SolrParams)this.params);
        this.admin.coreNames().stream().map(arg_0 -> ((NamedList)actionResponse).get(arg_0)).map(NamedList.class::cast).forEach(response -> Assert.assertEquals((Object)"scheduled", (Object)response.get("status")));
        alfrescoErrorNodeIds.forEach(id -> ((MetadataTracker)Mockito.verify((Object)alfrescoMetadataTracker)).addNodeToReindex(id));
        archiveErrorNodeIds.forEach(id -> ((MetadataTracker)Mockito.verify((Object)archiveMetadataTracker)).addNodeToReindex(id));
    }

    @Test
    public void indexActionOnSlaveNode_shouldReturnWarningMessage() {
        this.admin.coreNames().forEach(coreName -> Assert.assertFalse((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionINDEX((SolrParams)this.params);
        Assert.assertNotNull((Object)actionResponse.get("WARNING"));
    }

    @Test
    public void indexActionWhenIndexingIsDisabled_shouldReturnAnInfoMessage() {
        MetadataTracker metadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        AclTracker aclTracker = (AclTracker)Mockito.mock(AclTracker.class);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("alfresco", MetadataTracker.class))).thenReturn((Object)metadataTracker);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("archive", MetadataTracker.class))).thenReturn((Object)metadataTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("alfresco", AclTracker.class))).thenReturn((Object)aclTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("archive", AclTracker.class))).thenReturn((Object)aclTracker);
        Mockito.when((Object)metadataTracker.isEnabled()).thenReturn((Object)false);
        Mockito.when((Object)aclTracker.isEnabled()).thenReturn((Object)false);
        this.admin.coreNames().forEach(coreName -> Assert.assertTrue((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionINDEX((SolrParams)this.params);
        this.admin.coreNames().stream().map(arg_0 -> ((NamedList)actionResponse).get(arg_0)).map(NamedList.class::cast).forEach(response -> {
            Assert.assertEquals((Object)"notScheduled", (Object)response.get("status"));
            Assert.assertNotNull((Object)response.get("additionalInfo"));
        });
    }

    @Test
    public void indexActionWhenIndexingIsEnabled_shouldCollectThingsToReindex() {
        String txIdParam = "123452";
        String aclTxIdParam = "13579";
        String nodeIdParam = "24680";
        String aclIdParam = "98765";
        this.params.set("txid", new String[]{"123452"});
        this.params.set("acltxid", new String[]{"13579"});
        this.params.set("nodeid", new String[]{"24680"});
        this.params.set("aclid", new String[]{"98765"});
        MetadataTracker alfrescoMetadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        AclTracker alfrescoAclTracker = (AclTracker)Mockito.mock(AclTracker.class);
        MetadataTracker archiveMetadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        AclTracker archiveAclTracker = (AclTracker)Mockito.mock(AclTracker.class);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("alfresco", MetadataTracker.class))).thenReturn((Object)alfrescoMetadataTracker);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("archive", MetadataTracker.class))).thenReturn((Object)archiveMetadataTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("alfresco", AclTracker.class))).thenReturn((Object)alfrescoAclTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("archive", AclTracker.class))).thenReturn((Object)archiveAclTracker);
        Mockito.when((Object)alfrescoMetadataTracker.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)alfrescoAclTracker.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)archiveMetadataTracker.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)archiveAclTracker.isEnabled()).thenReturn((Object)true);
        this.admin.coreNames().forEach(coreName -> Assert.assertTrue((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionINDEX((SolrParams)this.params);
        this.admin.coreNames().stream().map(arg_0 -> ((NamedList)actionResponse).get(arg_0)).map(NamedList.class::cast).forEach(response -> Assert.assertEquals((Object)"scheduled", (Object)response.get("status")));
        ((MetadataTracker)Mockito.verify((Object)alfrescoMetadataTracker)).addTransactionToIndex(Long.valueOf(Long.parseLong("123452")));
        ((MetadataTracker)Mockito.verify((Object)alfrescoMetadataTracker)).addNodeToIndex(Long.valueOf(Long.parseLong("24680")));
        ((AclTracker)Mockito.verify((Object)alfrescoAclTracker)).addAclChangeSetToIndex(Long.valueOf(Long.parseLong("13579")));
        ((AclTracker)Mockito.verify((Object)alfrescoAclTracker)).addAclToIndex(Long.valueOf(Long.parseLong("98765")));
        ((MetadataTracker)Mockito.verify((Object)archiveMetadataTracker)).addTransactionToIndex(Long.valueOf(Long.parseLong("123452")));
        ((MetadataTracker)Mockito.verify((Object)archiveMetadataTracker)).addNodeToIndex(Long.valueOf(Long.parseLong("24680")));
        ((AclTracker)Mockito.verify((Object)archiveAclTracker)).addAclChangeSetToIndex(Long.valueOf(Long.parseLong("13579")));
        ((AclTracker)Mockito.verify((Object)archiveAclTracker)).addAclToIndex(Long.valueOf(Long.parseLong("98765")));
    }

    @Test
    public void reindexActionOnSlaveNode_shouldReturnWarningMessage() {
        this.admin.coreNames().forEach(coreName -> Assert.assertFalse((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionREINDEX((SolrParams)this.params);
        Assert.assertNotNull((Object)actionResponse.get("WARNING"));
    }

    @Test
    public void reindexActionWhenIndexingIsDisabled_shouldReturnAnInfoMessage() {
        MetadataTracker metadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        AclTracker aclTracker = (AclTracker)Mockito.mock(AclTracker.class);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("alfresco", MetadataTracker.class))).thenReturn((Object)metadataTracker);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("archive", MetadataTracker.class))).thenReturn((Object)metadataTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("alfresco", AclTracker.class))).thenReturn((Object)aclTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("archive", AclTracker.class))).thenReturn((Object)aclTracker);
        Mockito.when((Object)metadataTracker.isEnabled()).thenReturn((Object)false);
        Mockito.when((Object)aclTracker.isEnabled()).thenReturn((Object)false);
        this.admin.coreNames().forEach(coreName -> Assert.assertTrue((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionREINDEX((SolrParams)this.params);
        this.admin.coreNames().stream().map(arg_0 -> ((NamedList)actionResponse).get(arg_0)).map(NamedList.class::cast).forEach(response -> {
            Assert.assertEquals((Object)"notScheduled", (Object)response.get("status"));
            Assert.assertNotNull((Object)response.get("additionalInfo"));
        });
    }

    @Test
    public void reindexActionWhenIndexingIsEnabled_shouldCollectThingsToReindex() {
        String txIdParam = "123452";
        String aclTxIdParam = "13579";
        String nodeIdParam = "24680";
        String aclIdParam = "98765";
        this.params.set("txid", new String[]{"123452"});
        this.params.set("acltxid", new String[]{"13579"});
        this.params.set("nodeid", new String[]{"24680"});
        this.params.set("aclid", new String[]{"98765"});
        MetadataTracker alfrescoMetadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        AclTracker alfrescoAclTracker = (AclTracker)Mockito.mock(AclTracker.class);
        MetadataTracker archiveMetadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        AclTracker archiveAclTracker = (AclTracker)Mockito.mock(AclTracker.class);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("alfresco", MetadataTracker.class))).thenReturn((Object)alfrescoMetadataTracker);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("archive", MetadataTracker.class))).thenReturn((Object)archiveMetadataTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("alfresco", AclTracker.class))).thenReturn((Object)alfrescoAclTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("archive", AclTracker.class))).thenReturn((Object)archiveAclTracker);
        Mockito.when((Object)alfrescoMetadataTracker.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)alfrescoAclTracker.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)archiveMetadataTracker.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)archiveAclTracker.isEnabled()).thenReturn((Object)true);
        this.admin.coreNames().forEach(coreName -> Assert.assertTrue((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionREINDEX((SolrParams)this.params);
        this.admin.coreNames().stream().map(arg_0 -> ((NamedList)actionResponse).get(arg_0)).map(NamedList.class::cast).forEach(response -> Assert.assertEquals((Object)"scheduled", (Object)response.get("status")));
        ((MetadataTracker)Mockito.verify((Object)alfrescoMetadataTracker)).addTransactionToReindex(Long.valueOf(Long.parseLong("123452")));
        ((MetadataTracker)Mockito.verify((Object)alfrescoMetadataTracker)).addNodeToReindex(Long.valueOf(Long.parseLong("24680")));
        ((AclTracker)Mockito.verify((Object)alfrescoAclTracker)).addAclChangeSetToReindex(Long.valueOf(Long.parseLong("13579")));
        ((AclTracker)Mockito.verify((Object)alfrescoAclTracker)).addAclToReindex(Long.valueOf(Long.parseLong("98765")));
        ((MetadataTracker)Mockito.verify((Object)archiveMetadataTracker)).addTransactionToReindex(Long.valueOf(Long.parseLong("123452")));
        ((MetadataTracker)Mockito.verify((Object)archiveMetadataTracker)).addNodeToReindex(Long.valueOf(Long.parseLong("24680")));
        ((AclTracker)Mockito.verify((Object)archiveAclTracker)).addAclChangeSetToReindex(Long.valueOf(Long.parseLong("13579")));
        ((AclTracker)Mockito.verify((Object)archiveAclTracker)).addAclToReindex(Long.valueOf(Long.parseLong("98765")));
    }

    @Test
    public void purgeActionOnSlaveNode_shouldReturnWarningMessage() {
        this.admin.coreNames().forEach(coreName -> Assert.assertFalse((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionPURGE((SolrParams)this.params);
        Assert.assertNotNull((Object)actionResponse.get("WARNING"));
    }

    @Test
    public void purgeActionWhenIndexingIsDisabled_shouldReturnAnInfoMessage() {
        MetadataTracker metadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        AclTracker aclTracker = (AclTracker)Mockito.mock(AclTracker.class);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("alfresco", MetadataTracker.class))).thenReturn((Object)metadataTracker);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("archive", MetadataTracker.class))).thenReturn((Object)metadataTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("alfresco", AclTracker.class))).thenReturn((Object)aclTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("archive", AclTracker.class))).thenReturn((Object)aclTracker);
        Mockito.when((Object)metadataTracker.isEnabled()).thenReturn((Object)false);
        Mockito.when((Object)aclTracker.isEnabled()).thenReturn((Object)false);
        this.admin.coreNames().forEach(coreName -> Assert.assertTrue((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionPURGE((SolrParams)this.params);
        this.admin.coreNames().stream().map(arg_0 -> ((NamedList)actionResponse).get(arg_0)).map(NamedList.class::cast).forEach(response -> {
            Assert.assertEquals((Object)"notScheduled", (Object)response.get("status"));
            Assert.assertNotNull((Object)response.get("additionalInfo"));
        });
    }

    @Test
    public void purgeActionWhenIndexingIsEnabled_shouldCollectTransactionsToPurge() {
        String txIdParam = "123452";
        String aclTxIdParam = "13579";
        String nodeIdParam = "24680";
        String aclIdParam = "98765";
        this.params.set("txid", new String[]{"123452"});
        this.params.set("acltxid", new String[]{"13579"});
        this.params.set("nodeid", new String[]{"24680"});
        this.params.set("aclid", new String[]{"98765"});
        MetadataTracker alfrescoMetadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        AclTracker alfrescoAclTracker = (AclTracker)Mockito.mock(AclTracker.class);
        MetadataTracker archiveMetadataTracker = (MetadataTracker)Mockito.mock(MetadataTracker.class);
        AclTracker archiveAclTracker = (AclTracker)Mockito.mock(AclTracker.class);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("alfresco", MetadataTracker.class))).thenReturn((Object)alfrescoMetadataTracker);
        Mockito.when((Object)((MetadataTracker)this.registry.getTrackerForCore("archive", MetadataTracker.class))).thenReturn((Object)archiveMetadataTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("alfresco", AclTracker.class))).thenReturn((Object)alfrescoAclTracker);
        Mockito.when((Object)((AclTracker)this.registry.getTrackerForCore("archive", AclTracker.class))).thenReturn((Object)archiveAclTracker);
        Mockito.when((Object)alfrescoMetadataTracker.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)alfrescoAclTracker.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)archiveMetadataTracker.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)archiveAclTracker.isEnabled()).thenReturn((Object)true);
        this.admin.coreNames().forEach(coreName -> Assert.assertTrue((boolean)this.admin.isMasterOrStandalone(coreName)));
        NamedList actionResponse = this.admin.actionPURGE((SolrParams)this.params);
        this.admin.coreNames().stream().map(arg_0 -> ((NamedList)actionResponse).get(arg_0)).map(NamedList.class::cast).forEach(response -> Assert.assertEquals((Object)"scheduled", (Object)response.get("status")));
        ((MetadataTracker)Mockito.verify((Object)alfrescoMetadataTracker)).addTransactionToPurge(Long.valueOf(Long.parseLong("123452")));
        ((MetadataTracker)Mockito.verify((Object)alfrescoMetadataTracker)).addNodeToPurge(Long.valueOf(Long.parseLong("24680")));
        ((AclTracker)Mockito.verify((Object)alfrescoAclTracker)).addAclChangeSetToPurge(Long.valueOf(Long.parseLong("13579")));
        ((AclTracker)Mockito.verify((Object)alfrescoAclTracker)).addAclToPurge(Long.valueOf(Long.parseLong("98765")));
        ((MetadataTracker)Mockito.verify((Object)archiveMetadataTracker)).addTransactionToPurge(Long.valueOf(Long.parseLong("123452")));
        ((MetadataTracker)Mockito.verify((Object)archiveMetadataTracker)).addNodeToPurge(Long.valueOf(Long.parseLong("24680")));
        ((AclTracker)Mockito.verify((Object)archiveAclTracker)).addAclChangeSetToPurge(Long.valueOf(Long.parseLong("13579")));
        ((AclTracker)Mockito.verify((Object)archiveAclTracker)).addAclToPurge(Long.valueOf(Long.parseLong("98765")));
    }

    private <T> void assertThatExplicitParameterIsEchoed(String parameterName, T parameterValue) {
        this.admin = new AlfrescoCoreAdminHandler(){

            NamedList<Object> fixOnSpecificCore(String coreName, Long fromTxCommitTime, Long toTxCommitTime, boolean dryRun, int maxTransactionsToSchedule) {
                return new NamedList();
            }

            boolean isMasterOrStandalone(String coreName) {
                return true;
            }
        };
        this.admin.trackerRegistry = this.registry;
        this.params.set("core", new String[]{"alfresco"});
        this.params.set(parameterName, new String[]{parameterValue.toString()});
        NamedList actionResponse = this.admin.actionFIX((SolrParams)this.params);
        Assert.assertEquals(parameterValue, (Object)actionResponse.get(parameterName));
    }
}

