/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.tracker.ActivatableTracker;
import org.alfresco.solr.tracker.Tracker;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.quartz.SchedulerException;

@SolrTestCaseJ4.SuppressSSL
public class AlfrescoIndexingStatePersistenceAcrossReloadsIT
extends AbstractAlfrescoSolrIT {
    @BeforeClass
    public static void beforeClass() throws Exception {
        AlfrescoIndexingStatePersistenceAcrossReloadsIT.initAlfrescoCore("schema.xml");
        admin = (AlfrescoCoreAdminHandler)AlfrescoIndexingStatePersistenceAcrossReloadsIT.getCore().getCoreContainer().getMultiCoreHandler();
    }

    @After
    public void clearQueue() {
        SOLRAPIQueueClient.NODE_META_DATA_MAP.clear();
        SOLRAPIQueueClient.TRANSACTION_QUEUE.clear();
        SOLRAPIQueueClient.ACL_CHANGE_SET_QUEUE.clear();
        SOLRAPIQueueClient.ACL_READERS_MAP.clear();
        SOLRAPIQueueClient.ACL_MAP.clear();
        SOLRAPIQueueClient.NODE_MAP.clear();
    }

    @Test
    public void testIndexingStateAcrossReloads() throws Exception {
        long localId = 0L;
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1, ++localId);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Collections.singletonList(acl), Collections.singletonList(aclReaders));
        int numNodes = 1;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes, ++localId);
        for (int i = 0; i < numNodes; ++i) {
            Node node = AlfrescoSolrUtils.getNode(bigTxn, acl, Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, acl, "mike", null, false);
            nodeMetaDatas.add(nodeMetaData);
        }
        AlfrescoIndexingStatePersistenceAcrossReloadsIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        AlfrescoIndexingStatePersistenceAcrossReloadsIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes, 100000L);
        Collection<Tracker> trackers = this.getTrackers();
        this.disableIndexing();
        Collection activatableTrackers = this.getTrackers().stream().filter(tracker -> tracker instanceof ActivatableTracker).map(ActivatableTracker.class::cast).collect(Collectors.toList());
        Assert.assertFalse((boolean)activatableTrackers.isEmpty());
        activatableTrackers.forEach(tracker -> Assert.assertTrue((boolean)tracker.isDisabled()));
        this.reloadAndAssertCorrect(trackers, trackers.size(), this.getJobsCount());
        Collection activatableTrackersBelongingToReloadedCore = this.getTrackers().stream().filter(tracker -> tracker instanceof ActivatableTracker).map(ActivatableTracker.class::cast).collect(Collectors.toList());
        Assert.assertFalse((boolean)activatableTrackersBelongingToReloadedCore.isEmpty());
        activatableTrackersBelongingToReloadedCore.forEach(tracker -> Assert.assertTrue((boolean)tracker.isDisabled()));
        this.enableIndexing();
        activatableTrackersBelongingToReloadedCore.forEach(tracker -> Assert.assertTrue((boolean)tracker.isEnabled()));
        Transaction bigTxn2 = AlfrescoSolrUtils.getTransaction(0, numNodes, ++localId);
        for (int i = 0; i < numNodes; ++i) {
            Node node = AlfrescoSolrUtils.getNode(bigTxn2, acl, Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn2, acl, "mike", null, false);
            nodeMetaDatas.add(nodeMetaData);
        }
        AlfrescoIndexingStatePersistenceAcrossReloadsIT.indexTransaction(bigTxn2, nodes, nodeMetaDatas);
        AlfrescoIndexingStatePersistenceAcrossReloadsIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes * 2, 500000L);
    }

    private void reloadAndAssertCorrect(Collection<Tracker> trackers, int numOfTrackers, int jobs) throws Exception {
        AlfrescoIndexingStatePersistenceAcrossReloadsIT.reload();
        TimeUnit.SECONDS.sleep(1L);
        Collection<Tracker> reloadedTrackers = this.getTrackers();
        Assert.assertEquals((String)"After a reload the number of trackers should be the same", (long)numOfTrackers, (long)this.getTrackers().size());
        Assert.assertEquals((String)"After a reload the number of jobs should be the same", (long)jobs, (long)this.getJobsCount());
        trackers.forEach(tracker -> Assert.assertFalse((String)"The reloaded trackers should be different.", (boolean)reloadedTrackers.contains(tracker)));
    }

    private int getJobsCount() throws SchedulerException {
        return admin.getScheduler().getJobsCount();
    }
}

