/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.SolrInformationServer;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.NodeMetaDataParameters;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.StringPropertyValue;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.BasicResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SolrInformationServerTest {
    private SolrInformationServer infoServer;
    @Mock
    private AlfrescoCoreAdminHandler adminHandler;
    @Mock
    private SolrResourceLoader resourceLoader;
    @Mock
    private SolrCore core;
    @Mock
    private SOLRAPIClient client;
    @Mock
    private SolrRequestHandler handler;
    @Mock
    private SolrQueryResponse response;
    private SolrQueryRequest request;
    @Mock
    private UpdateRequestProcessorChain updateRequestProcessorChain;
    @Mock
    private UpdateRequestProcessor updateRequestProcessor;

    @Before
    public void setUp() {
        Mockito.when((Object)this.core.getResourceLoader()).thenReturn((Object)this.resourceLoader);
        Mockito.when((Object)this.core.getRequestHandler("/get")).thenReturn((Object)this.handler);
        Mockito.when((Object)this.core.getRequestHandler("/native")).thenReturn((Object)this.handler);
        Mockito.when((Object)this.resourceLoader.getCoreProperties()).thenReturn((Object)new Properties());
        this.infoServer = new SolrInformationServer(this.adminHandler, this.core, this.client){

            SolrQueryResponse newSolrQueryResponse() {
                return SolrInformationServerTest.this.response;
            }
        };
        this.request = this.infoServer.newSolrQueryRequest();
        Mockito.when((Object)this.core.getUpdateProcessingChain(null)).thenReturn((Object)this.updateRequestProcessorChain);
        Mockito.when((Object)this.updateRequestProcessorChain.createProcessor((SolrQueryRequest)ArgumentMatchers.any(), (SolrQueryResponse)ArgumentMatchers.any())).thenReturn((Object)this.updateRequestProcessor);
    }

    @Test
    public void testGetStateOk() {
        String id = String.valueOf(System.currentTimeMillis());
        SolrDocument state = new SolrDocument();
        SimpleOrderedMap responseContent = new SimpleOrderedMap();
        responseContent.add("doc", (Object)state);
        Mockito.when((Object)this.response.getValues()).thenReturn((Object)responseContent);
        SolrDocument document = this.infoServer.getState(this.core, this.request, id);
        Assert.assertEquals((Object)id, (Object)this.request.getParams().get("id"));
        ((SolrCore)Mockito.verify((Object)this.core)).getRequestHandler("/get");
        ((SolrQueryResponse)Mockito.verify((Object)this.response)).getValues();
        Assert.assertSame((Object)state, (Object)document);
    }

    @Test
    public void setUnitOfTimeFieldsWithDatetimeField_shouldSetDateAndTimeFields() {
        DataTypeDefinition datatype = (DataTypeDefinition)Mockito.mock(DataTypeDefinition.class);
        Mockito.when((Object)datatype.getName()).thenReturn((Object)DataTypeDefinition.DATETIME);
        SolrInputDocument document = new SolrInputDocument(new String[0]);
        String fieldPrefix = "datetime@sd@";
        String fieldSuffix = "{http://www.alfresco.org/model/content/1.0}created";
        String sourceFieldName = fieldPrefix + fieldSuffix;
        this.infoServer.setUnitOfTimeFields((arg_0, arg_1) -> ((SolrInputDocument)document).setField(arg_0, arg_1), sourceFieldName, "1972-09-16T17:33:18Z", datatype);
        Assert.assertEquals((long)1972L, (long)this.unitOfTimeFieldValue(document, "part@sd@" + fieldSuffix + "_unit_of_time_year"));
        Assert.assertEquals((long)3L, (long)this.unitOfTimeFieldValue(document, "part@sd@" + fieldSuffix + "_unit_of_time_quarter"));
        Assert.assertEquals((long)9L, (long)this.unitOfTimeFieldValue(document, "part@sd@" + fieldSuffix + "_unit_of_time_month"));
        Assert.assertEquals((long)16L, (long)this.unitOfTimeFieldValue(document, "part@sd@" + fieldSuffix + "_unit_of_time_day_of_month"));
        Assert.assertEquals((long)17L, (long)this.unitOfTimeFieldValue(document, "part@sd@" + fieldSuffix + "_unit_of_time_hour"));
        Assert.assertEquals((long)33L, (long)this.unitOfTimeFieldValue(document, "part@sd@" + fieldSuffix + "_unit_of_time_minute"));
        Assert.assertEquals((long)18L, (long)this.unitOfTimeFieldValue(document, "part@sd@" + fieldSuffix + "_unit_of_time_second"));
    }

    @Test
    public void setUnitOfTimeFieldsWithDatetimeField_shouldSetOnlyDateFields() {
        DataTypeDefinition datatype = (DataTypeDefinition)Mockito.mock(DataTypeDefinition.class);
        Mockito.when((Object)datatype.getName()).thenReturn((Object)DataTypeDefinition.DATE);
        SolrInputDocument document = new SolrInputDocument(new String[0]);
        String fieldPrefix = "datetime@sd@";
        String fieldSuffix = "{http://www.alfresco.org/model/content/1.0}created";
        String sourceFieldName = fieldPrefix + fieldSuffix;
        this.infoServer.setUnitOfTimeFields((arg_0, arg_1) -> ((SolrInputDocument)document).setField(arg_0, arg_1), sourceFieldName, "1972-09-16T17:33:18Z", datatype);
        Assert.assertEquals((long)1972L, (long)this.unitOfTimeFieldValue(document, "part@sd@" + fieldSuffix + "_unit_of_time_year"));
        Assert.assertEquals((long)3L, (long)this.unitOfTimeFieldValue(document, "part@sd@" + fieldSuffix + "_unit_of_time_quarter"));
        Assert.assertEquals((long)9L, (long)this.unitOfTimeFieldValue(document, "part@sd@" + fieldSuffix + "_unit_of_time_month"));
        Assert.assertEquals((long)16L, (long)this.unitOfTimeFieldValue(document, "part@sd@" + fieldSuffix + "_unit_of_time_day_of_month"));
        Assert.assertFalse((boolean)document.containsKey((Object)("part@sd@" + fieldSuffix + "_unit_of_time_hour")));
        Assert.assertFalse((boolean)document.containsKey((Object)("part@sd@" + fieldSuffix + "_unit_of_time_minute")));
        Assert.assertFalse((boolean)document.containsKey((Object)("part@sd@" + fieldSuffix + "_unit_of_time_second")));
    }

    @Test
    public void destructuringCannotBeAppliedToMultivaluedFields() {
        PropertyDefinition multiValuedProperty = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)multiValuedProperty.isMultiValued()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.infoServer.canBeDestructured(multiValuedProperty, "datetime@sd@{http://www.alfresco.org/model/content/1.0}created"));
    }

    @Test
    public void destructuringCannotBeAppliedToProperties() {
        PropertyDefinition multiValuedProperty = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)multiValuedProperty.isMultiValued()).thenReturn((Object)false);
        Assert.assertFalse((String)"Destructuring can only be applied to Node properties (e.g. dynamic fields in Solr schema)", (boolean)this.infoServer.canBeDestructured(multiValuedProperty, "this_is_a_field_that_doesnt_follow_the_dynamic_naming"));
    }

    @Test
    public void destructuringCanBeAppliedToDateFields() {
        PropertyDefinition propertyThatCanBeDestructured = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)propertyThatCanBeDestructured.isMultiValued()).thenReturn((Object)false);
        DataTypeDefinition date = (DataTypeDefinition)Mockito.mock(DataTypeDefinition.class);
        Mockito.when((Object)date.getName()).thenReturn((Object)DataTypeDefinition.DATE);
        Mockito.when((Object)propertyThatCanBeDestructured.getDataType()).thenReturn((Object)date);
        Assert.assertTrue((String)"Destructuring must be supported in Date fields!", (boolean)this.infoServer.canBeDestructured(propertyThatCanBeDestructured, "date@sd@{http://www.alfresco.org/model/content/1.0}created"));
    }

    @Test
    public void destructuringCanBeAppliedToDateTimeFields() {
        PropertyDefinition propertyThatCanBeDestructured = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)propertyThatCanBeDestructured.isMultiValued()).thenReturn((Object)false);
        DataTypeDefinition datetime = (DataTypeDefinition)Mockito.mock(DataTypeDefinition.class);
        Mockito.when((Object)datetime.getName()).thenReturn((Object)DataTypeDefinition.DATETIME);
        Mockito.when((Object)propertyThatCanBeDestructured.getDataType()).thenReturn((Object)datetime);
        Assert.assertTrue((String)"Destructuring must be supported in Datetime fields!", (boolean)this.infoServer.canBeDestructured(propertyThatCanBeDestructured, "datetime@sd@{http://www.alfresco.org/model/content/1.0}created"));
    }

    @Test
    public void destructuringCanBeAppliedOnlyToDateOrDatetimeFields() {
        Stream.of(DataTypeDefinition.ANY, DataTypeDefinition.ENCRYPTED, DataTypeDefinition.TEXT, DataTypeDefinition.MLTEXT, DataTypeDefinition.CONTENT, DataTypeDefinition.INT, DataTypeDefinition.LONG, DataTypeDefinition.FLOAT, DataTypeDefinition.DOUBLE, DataTypeDefinition.BOOLEAN, DataTypeDefinition.QNAME, DataTypeDefinition.CATEGORY, DataTypeDefinition.NODE_REF, DataTypeDefinition.CHILD_ASSOC_REF, DataTypeDefinition.ASSOC_REF, DataTypeDefinition.PATH, DataTypeDefinition.LOCALE, DataTypeDefinition.PERIOD).map(qname -> {
            PropertyDefinition propertyThatCannotBeDestructured = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
            DataTypeDefinition def = (DataTypeDefinition)Mockito.mock(DataTypeDefinition.class);
            Mockito.when((Object)def.getName()).thenReturn(qname);
            Mockito.when((Object)propertyThatCannotBeDestructured.getDataType()).thenReturn((Object)def);
            return propertyThatCannotBeDestructured;
        }).forEach(property -> Assert.assertFalse((String)"Destructuring must be supported only on Date or Datetime fields!", (boolean)this.infoServer.canBeDestructured(property, "somedatatype@sd@{http://www.alfresco.org/model/content/1.0}somefield")));
    }

    private int unitOfTimeFieldValue(SolrInputDocument doc, String fieldName) {
        return Optional.ofNullable(doc.getFieldValue(fieldName)).map(Number.class::cast).map(Number::intValue).orElseThrow(() -> new IllegalArgumentException(fieldName + " hasn't been set."));
    }

    @Test
    public void testGetStateWithStateNotFound_returnsNull() {
        String id = String.valueOf(System.currentTimeMillis());
        SimpleOrderedMap responseContent = new SimpleOrderedMap();
        responseContent.add("doc", null);
        Mockito.when((Object)this.response.getValues()).thenReturn((Object)responseContent);
        SolrDocument document = this.infoServer.getState(this.core, this.request, id);
        Assert.assertEquals((Object)id, (Object)this.request.getParams().get("id"));
        ((SolrCore)Mockito.verify((Object)this.core)).getRequestHandler("/get");
        ((SolrQueryResponse)Mockito.verify((Object)this.response)).getValues();
        Assert.assertNull((Object)document);
    }

    @Test
    public void testPathsFieldStorage() {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        NodeMetaData nodeMetaData = new NodeMetaData();
        nodeMetaData.setAncestorPaths(List.of("/1/2/4/7/10", "/1/2/5/8/10", "/1/2/6/9/10"));
        nodeMetaData.setPaths(List.of());
        List expectedANames = Stream.of("0/10", "1/7/10", "1/8/10", "1/9/10", "2/4/7/10", "2/5/8/10", "2/6/9/10", "3/2/4/7/10", "3/2/5/8/10", "3/2/6/9/10", "4/1/2/4/7/10", "4/1/2/5/8/10", "4/1/2/6/9/10", "F/1/2/4/7/10", "F/1/2/5/8/10", "F/1/2/6/9/10").collect(Collectors.toCollection(ArrayList::new));
        List expectedAPaths = Stream.of("0/1", "1/1/2", "2/1/2/4", "2/1/2/5", "2/1/2/6", "3/1/2/4/7", "3/1/2/5/8", "3/1/2/6/9", "4/1/2/4/7/10", "4/1/2/5/8/10", "4/1/2/6/9/10", "F/1/2/4/7/10", "F/1/2/5/8/10", "F/1/2/6/9/10").collect(Collectors.toCollection(ArrayList::new));
        this.infoServer.updatePathRelatedFields(nodeMetaData, doc);
        List anames = doc.getFieldValues("ANAME").stream().map(aname -> aname.toString()).collect(Collectors.toList()).stream().sorted().collect(Collectors.toList());
        Assert.assertEquals((Object)expectedANames, anames);
        List apaths = doc.getFieldValues("APATH").stream().map(aname -> aname.toString()).collect(Collectors.toList()).stream().sorted().collect(Collectors.toList());
        Assert.assertEquals((Object)expectedAPaths, apaths);
    }

    @Test
    public void testPathsFieldStorageIterations() {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        NodeMetaData nodeMetaData = new NodeMetaData();
        nodeMetaData.setAncestorPaths(List.of("/1/2/4/7/10", "/1/2/5/8/10", "/1/2/6/9/10"));
        nodeMetaData.setPaths(List.of());
        IntStream.range(0, 2).forEach(i -> {
            this.infoServer.updatePathRelatedFields(nodeMetaData, doc);
            Assert.assertEquals((long)doc.getFieldValues("ANAME").size(), (long)16L);
            Assert.assertEquals((long)doc.getFieldValues("APATH").size(), (long)14L);
        });
    }

    @Test
    public void testAddContentOutdatedAndUpdatedCounts() {
        SimpleOrderedMap responseContent = new SimpleOrderedMap();
        DocList docList = (DocList)Mockito.mock(DocList.class);
        Mockito.when((Object)docList.matches()).thenReturn((Object)3);
        BasicResultContext basicResultContext = (BasicResultContext)Mockito.mock(BasicResultContext.class);
        Mockito.when((Object)basicResultContext.getDocList()).thenReturn((Object)docList);
        responseContent.add("response", (Object)basicResultContext);
        SimpleOrderedMap facetQueries = new SimpleOrderedMap();
        facetQueries.add("OUTDATED", (Object)1);
        SimpleOrderedMap facetCounts = new SimpleOrderedMap();
        facetCounts.add("facet_queries", (Object)facetQueries);
        responseContent.add("facet_counts", (Object)facetCounts);
        ((SolrRequestHandler)Mockito.doAnswer(arg_0 -> SolrInformationServerTest.lambda$testAddContentOutdatedAndUpdatedCounts$6((NamedList)responseContent, arg_0)).when((Object)this.handler)).handleRequest((SolrQueryRequest)ArgumentMatchers.any(SolrQueryRequest.class), (SolrQueryResponse)ArgumentMatchers.any(SolrQueryResponse.class));
        NamedList report = new NamedList();
        this.infoServer.addContentOutdatedAndUpdatedCounts(report);
        Assert.assertEquals((String)"Expected two content nodes to be in sync.", (Object)report.get("Node count whose content is in sync"), (Object)2L);
        Assert.assertEquals((String)"Expected one content node to need an update.", (Object)report.get("Node count whose content needs to be updated"), (Object)1L);
    }

    @Test
    public void testUnindexedNode() throws IOException, AuthenticationException {
        NodeMetaData nodeMetaData = new NodeMetaData();
        nodeMetaData.setProperties(Map.of(ContentModel.PROP_IS_INDEXED, new StringPropertyValue("false")));
        nodeMetaData.setAspects(Set.of(ContentModel.ASPECT_INDEX_CONTROL));
        nodeMetaData.setType(ContentModel.TYPE_CONTENT);
        nodeMetaData.setNodeRef(new NodeRef("workspace://SpacesStore/f7c71f35-b592-40e2-a15f-fccbadd6b4d3"));
        Mockito.when((Object)this.client.getNodesMetaData((NodeMetaDataParameters)ArgumentMatchers.any(NodeMetaDataParameters.class))).thenReturn(Arrays.asList(nodeMetaData));
        ((SolrRequestHandler)Mockito.doAnswer(invocationOnMock -> {
            SolrQueryRequest request = (SolrQueryRequest)invocationOnMock.getArgument(0);
            SolrQueryResponse response = (SolrQueryResponse)invocationOnMock.getArgument(1);
            NamedList namedList = new NamedList();
            BasicResultContext rc = new BasicResultContext((DocList)new DocSlice(1, 1, new int[0], new float[0], 0, 0.0f), null, null, null, request);
            namedList.add("response", (Object)rc);
            response.setAllValues(namedList);
            return null;
        }).when((Object)this.handler)).handleRequest((SolrQueryRequest)ArgumentMatchers.any(), (SolrQueryResponse)ArgumentMatchers.any());
        ((UpdateRequestProcessor)Mockito.doAnswer(invocationOnMock -> {
            AddUpdateCommand cmd = (AddUpdateCommand)invocationOnMock.getArgument(0);
            Assert.assertEquals((Object)"UnindexedNode", (Object)cmd.solrDoc.get((Object)"DOC_TYPE").getValue());
            return null;
        }).when((Object)this.updateRequestProcessor)).processAdd((AddUpdateCommand)ArgumentMatchers.any());
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getStatus()).thenReturn((Object)Node.SolrApiNodeStatus.UPDATED);
        Mockito.when((Object)node.getId()).thenReturn((Object)865L);
        this.infoServer.indexNode(node, false);
        ((UpdateRequestProcessor)Mockito.verify((Object)this.updateRequestProcessor)).processAdd((AddUpdateCommand)ArgumentMatchers.any());
    }

    @Test
    public void testGetFacets() {
        SimpleOrderedMap responseContent = new SimpleOrderedMap();
        SimpleOrderedMap txidFacet = new SimpleOrderedMap();
        txidFacet.add("1", (Object)1);
        txidFacet.add("2", (Object)1);
        txidFacet.add("3", (Object)1);
        NamedList facetCounts = new NamedList();
        facetCounts.add("facet_queries", (Object)new SimpleOrderedMap());
        facetCounts.add("facet_fields", (Object)new SimpleOrderedMap());
        SimpleOrderedMap facetFields = (SimpleOrderedMap)facetCounts.get("facet_fields");
        facetFields.add("TXID", (Object)txidFacet);
        responseContent.add("facet_counts", (Object)facetCounts);
        ((SolrRequestHandler)Mockito.doAnswer(invocation -> {
            SolrQueryResponse solrQueryResponse = (SolrQueryResponse)invocation.getArgument(1);
            solrQueryResponse.setAllValues((NamedList)responseContent);
            return null;
        }).when((Object)this.handler)).handleRequest((SolrQueryRequest)ArgumentMatchers.any(SolrQueryRequest.class), (SolrQueryResponse)ArgumentMatchers.any(SolrQueryResponse.class));
        NamedList actualResult = this.infoServer.getFacets(this.request, "TXID:[1 TO 3]", "TXID", 1, 3L);
        NamedList<Integer> expectedResult = new NamedList<Integer>(){
            {
                this.add("1", 1);
                this.add("2", 1);
                this.add("3", 1);
            }
        };
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    private static /* synthetic */ Object lambda$testAddContentOutdatedAndUpdatedCounts$6(NamedList responseContent, InvocationOnMock invocation) throws Throwable {
        SolrQueryResponse solrQueryResponse = (SolrQueryResponse)invocation.getArgument(1);
        solrQueryResponse.setAllValues(responseContent);
        return null;
    }
}

