/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.lifecycle;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.solr.SolrInformationServer;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.lifecycle.SolrCoreLoadListener;
import org.alfresco.solr.tracker.AclTracker;
import org.alfresco.solr.tracker.CascadeTracker;
import org.alfresco.solr.tracker.ContentTracker;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.SolrTrackerScheduler;
import org.alfresco.solr.tracker.Tracker;
import org.alfresco.solr.tracker.TrackerRegistry;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.xml.sax.InputSource;

@RunWith(value=MockitoJUnitRunner.class)
public class SolrCoreLoadListenerTest {
    private SolrCoreLoadListener listener;
    @Mock
    private SolrCore core;
    @Mock
    private SolrTrackerScheduler scheduler;
    @Mock
    private SOLRAPIClient api;
    @Mock
    private SolrInformationServer informationServer;
    @Mock
    private TrackerRegistry registry;
    private Properties coreProperties;
    private String coreName = "XYZ";

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.listener = new SolrCoreLoadListener(this.core);
        Mockito.when((Object)this.core.getName()).thenReturn((Object)this.coreName);
        this.coreProperties = new Properties();
    }

    @Test
    public void coreTrackersRegistrationAndScheduling() {
        List coreTrackers = this.listener.createAndScheduleCoreTrackers(this.core, this.registry, this.coreProperties, this.scheduler, this.api, this.informationServer);
        ((TrackerRegistry)Mockito.verify((Object)this.registry)).register((String)ArgumentMatchers.eq((Object)this.coreName), (Tracker)ArgumentMatchers.any(AclTracker.class));
        ((TrackerRegistry)Mockito.verify((Object)this.registry)).register((String)ArgumentMatchers.eq((Object)this.coreName), (Tracker)ArgumentMatchers.any(ContentTracker.class));
        ((TrackerRegistry)Mockito.verify((Object)this.registry)).register((String)ArgumentMatchers.eq((Object)this.coreName), (Tracker)ArgumentMatchers.any(MetadataTracker.class));
        ((TrackerRegistry)Mockito.verify((Object)this.registry)).register((String)ArgumentMatchers.eq((Object)this.coreName), (Tracker)ArgumentMatchers.any(CascadeTracker.class));
        ((SolrTrackerScheduler)Mockito.verify((Object)this.scheduler)).schedule((Tracker)ArgumentMatchers.any(AclTracker.class), (String)ArgumentMatchers.eq((Object)this.coreName), (Properties)ArgumentMatchers.same((Object)this.coreProperties));
        ((SolrTrackerScheduler)Mockito.verify((Object)this.scheduler)).schedule((Tracker)ArgumentMatchers.any(ContentTracker.class), (String)ArgumentMatchers.eq((Object)this.coreName), (Properties)ArgumentMatchers.same((Object)this.coreProperties));
        ((SolrTrackerScheduler)Mockito.verify((Object)this.scheduler)).schedule((Tracker)ArgumentMatchers.any(MetadataTracker.class), (String)ArgumentMatchers.eq((Object)this.coreName), (Properties)ArgumentMatchers.same((Object)this.coreProperties));
        ((SolrTrackerScheduler)Mockito.verify((Object)this.scheduler)).schedule((Tracker)ArgumentMatchers.any(CascadeTracker.class), (String)ArgumentMatchers.eq((Object)this.coreName), (Properties)ArgumentMatchers.same((Object)this.coreProperties));
        Set trackerTypes = coreTrackers.stream().map(Tracker::getType).collect(Collectors.toSet());
        Assert.assertEquals((String)"Unexpected trackers found.", Set.of(Tracker.Type.ACL, Tracker.Type.CONTENT, Tracker.Type.METADATA, Tracker.Type.NODE_STATE_PUBLISHER, Tracker.Type.CASCADE), trackerTypes);
    }

    @Test
    public void testDisabledCascadeTracking() {
        this.coreProperties.put("alfresco.cascade.tracker.enabled", "false");
        List coreTrackers = this.listener.createAndScheduleCoreTrackers(this.core, this.registry, this.coreProperties, this.scheduler, this.api, this.informationServer);
        ((TrackerRegistry)Mockito.verify((Object)this.registry)).register((String)ArgumentMatchers.eq((Object)this.coreName), (Tracker)ArgumentMatchers.any(AclTracker.class));
        ((TrackerRegistry)Mockito.verify((Object)this.registry)).register((String)ArgumentMatchers.eq((Object)this.coreName), (Tracker)ArgumentMatchers.any(ContentTracker.class));
        ((TrackerRegistry)Mockito.verify((Object)this.registry)).register((String)ArgumentMatchers.eq((Object)this.coreName), (Tracker)ArgumentMatchers.any(MetadataTracker.class));
        ((TrackerRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).register((String)ArgumentMatchers.eq((Object)this.coreName), (Tracker)ArgumentMatchers.any(CascadeTracker.class));
        ((SolrTrackerScheduler)Mockito.verify((Object)this.scheduler)).schedule((Tracker)ArgumentMatchers.any(AclTracker.class), (String)ArgumentMatchers.eq((Object)this.coreName), (Properties)ArgumentMatchers.same((Object)this.coreProperties));
        ((SolrTrackerScheduler)Mockito.verify((Object)this.scheduler)).schedule((Tracker)ArgumentMatchers.any(ContentTracker.class), (String)ArgumentMatchers.eq((Object)this.coreName), (Properties)ArgumentMatchers.same((Object)this.coreProperties));
        ((SolrTrackerScheduler)Mockito.verify((Object)this.scheduler)).schedule((Tracker)ArgumentMatchers.any(MetadataTracker.class), (String)ArgumentMatchers.eq((Object)this.coreName), (Properties)ArgumentMatchers.same((Object)this.coreProperties));
        ((SolrTrackerScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.never())).schedule((Tracker)ArgumentMatchers.any(CascadeTracker.class), (String)ArgumentMatchers.eq((Object)this.coreName), (Properties)ArgumentMatchers.same((Object)this.coreProperties));
        Set trackerTypes = coreTrackers.stream().map(Tracker::getType).collect(Collectors.toSet());
        Assert.assertEquals((String)"Unexpected trackers found.", Set.of(Tracker.Type.ACL, Tracker.Type.CONTENT, Tracker.Type.METADATA, Tracker.Type.NODE_STATE_PUBLISHER), trackerTypes);
    }

    @Test
    public void trackersShutDownProcedure() {
        List<Tracker> coreTrackers = Arrays.asList((Tracker)Mockito.mock(AclTracker.class), (Tracker)Mockito.mock(ContentTracker.class), (Tracker)Mockito.mock(MetadataTracker.class), (Tracker)Mockito.mock(CascadeTracker.class));
        this.listener.shutdownTrackers(this.core, coreTrackers, this.scheduler, false);
        coreTrackers.forEach(tracker -> ((Tracker)Mockito.verify((Object)tracker)).setShutdown(true));
        coreTrackers.forEach(tracker -> ((SolrTrackerScheduler)Mockito.verify((Object)this.scheduler)).deleteJobForTrackerInstance(this.core.getName(), tracker));
        coreTrackers.forEach(tracker -> ((Tracker)Mockito.verify((Object)tracker)).shutdown());
    }

    @Test
    public void noReplicationHandlerDefined_thenContentStoreIsInReadWriteMode() throws Exception {
        this.prepare("solrconfig_no_replication_handler_defined.xml");
        Assert.assertFalse((String)"If no replication handler is defined, then we expect to run a RW content store.", (boolean)this.listener.isSlaveModeEnabledFor(this.core));
    }

    @Test
    public void emptyReplicationHandlerDefined_thenContentStoreIsInReadWriteMode() throws Exception {
        this.prepare("solrconfig_empty_replication_handler.xml");
        Assert.assertFalse((String)"If an empty replication handler is defined, then we expect to run a RW content store.", (boolean)this.listener.isSlaveModeEnabledFor(this.core));
    }

    @Test
    public void slaveReplicationHandlerDefinedButDisabled_thenContentStoreIsInReadWriteMode() throws Exception {
        this.prepare("solrconfig_slave_disabled_replication_handler.xml");
        Assert.assertFalse((String)"If a slave replication handler is defined but disabled, then we expect to run a RW content store.", (boolean)this.listener.isSlaveModeEnabledFor(this.core));
    }

    @Test
    public void masterReplicationHandlerDefined_thenContentStoreIsInReadWriteMode() throws Exception {
        this.prepare("solrconfig_master_replication_handler.xml");
        Assert.assertFalse((String)"If a master replication handler is defined but disabled, then we expect to run a RW content store.", (boolean)this.listener.isSlaveModeEnabledFor(this.core));
    }

    @Test
    public void masterReplicationHandlerDefinedButDisabled_thenContentStoreIsInReadWriteMode() throws Exception {
        this.prepare("solrconfig_master_disabled_replication_handler.xml");
        Assert.assertFalse((String)"If a master replication handler is defined but disabled, then we expect to run a RW content store.", (boolean)this.listener.isSlaveModeEnabledFor(this.core));
    }

    @Test
    public void slaveReplicationHandlerDefined_thenContentStoreIsInReadOnlyMode() throws Exception {
        this.prepare("solrconfig_slave_replication_handler.xml");
        Assert.assertTrue((String)"If a slave replication handler is defined, then we expect to run a RO content store.", (boolean)this.listener.isSlaveModeEnabledFor(this.core));
    }

    private void prepare(String configName) throws Exception {
        SolrConfig solrConfig = new SolrConfig(configName, new InputSource(this.getClass().getResourceAsStream("/test-files/" + configName)));
        Mockito.when((Object)this.core.getSolrConfig()).thenReturn((Object)solrConfig);
    }
}

