/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.alfresco.solr.query.AuthDataLoad;
import org.alfresco.util.Pair;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.RefCounted;
import org.junit.Assert;
import org.junit.Test;

public class AuthQueryIT
extends AuthDataLoad {
    @Test
    public void checkAuth() throws IOException, ParseException {
        Object refCounted = null;
        try {
            this.assertFTSQuery("TEXT:\"Test\" ", count, new String[0]);
            this.assertFTSQuery("TEXT:\"doc\"", count, new String[0]);
            this.assertFTSQuery("TEXT:\"number\"", count, new String[0]);
            this.assertFTSQuery("AUTHORITY:\"GROUP_EVERYONE\" AND DOC_TYPE:Node", 103, new String[0]);
            this.assertFTSQuery("AUTHORITY:\"READER-1000\" AND DOC_TYPE:Node", 100, new String[0]);
            this.assertFTSQuery("AUTHORITY:\"READER-902\" AND DOC_TYPE:Node", 2, new String[0]);
            this.assertFTSQuery("AUTHORITY:\"READER-901\" AND DOC_TYPE:Node", 1, new String[0]);
            this.buildAndRunAuthQuery(count, 8);
            this.buildAndRunAuthQuery(count, 9);
            this.buildAndRunAuthQuery(count, 10);
            this.buildAndRunAuthQuery(count, 98);
            this.buildAndRunAuthQuery(count, 99);
            this.buildAndRunAuthQuery(count, 100);
            this.buildAndRunAuthQuery(count, 998);
            this.buildAndRunAuthQuery(count, 999);
            this.buildAndRunAuthQuery(count, 1000);
            this.buildAndRunAuthQuery(count, 9998);
            this.buildAndRunAuthQuery(count, 9999);
            this.buildAndRunAuthQuery(count, 10000);
            this.buildAndRunAuthQuery(count, 10000);
            this.buildAndRunAuthQuery(count, 10000);
            this.buildAndRunAuthQuery(count, 20000);
            this.buildAndRunAuthQuery(count, 20000);
            this.buildAndRunAuthQuery(count, 20000);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFTSQuery(String queryString, int count, String ... name) throws IOException, ParseException {
        AbstractAlfrescoSolrIT.SolrServletRequest solrQueryRequest = null;
        RefCounted refCounted = null;
        try {
            solrQueryRequest = new AbstractAlfrescoSolrIT.SolrServletRequest(AuthQueryIT.getCore(), null);
            refCounted = AuthQueryIT.getCore().getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            SearchParameters searchParameters = new SearchParameters();
            searchParameters.setQuery(queryString);
            Query query = dataModel.getFTSQuery(new Pair((Object)searchParameters, (Object)Boolean.FALSE), (SolrQueryRequest)solrQueryRequest, FTSQueryParser.RerankPhase.SINGLE_PASS);
            TopDocs docs = solrIndexSearcher.search(query, count * 2 + 10);
            Assert.assertEquals((long)count, (long)docs.totalHits);
        }
        finally {
            refCounted.decref();
            solrQueryRequest.close();
        }
    }

    private void buildAndRunAuthQuery(long count, int loop) throws IOException, ParseException {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i <= loop; ++i) {
            if (i % 100 == 1) {
                if (i == 1) {
                    builder.append("|AUTHORITY:\"");
                } else {
                    builder.append("\" |AUTHORITY:\"");
                }
            }
            builder.append("|READER-" + i);
        }
        builder.append("\"");
        this.assertFTSQuery(builder.toString(), 0, "Auth-" + loop);
    }
}

