/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query.cmis;

import java.util.Date;
import java.util.GregorianCalendar;
import org.alfresco.solr.query.cmis.LoadCMISData;
import org.alfresco.util.ISO8601DateFormat;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Before;
import org.junit.Test;

public class CmisIT
extends LoadCMISData {
    @Before
    public void setup() throws Exception {
        CmisIT.addTypeTestData(testCMISFolder00NodeRef, testCMISRootNodeRef, testCMISBaseFolderNodeRef, testCMISBaseFolderQName, testCMISFolder00QName, testCMISDate00);
    }

    @Test
    public void checkDtext() {
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document"), this.expectedDocCount(12));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth = 'Un tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth <> 'tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth LIKE 'U_ to%sed'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth NOT LIKE 't__eni%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth IN ('Un tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth NOT IN ('Un tokenized')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth < 'tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth < 'Un tokenised'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth < 'V'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth < 'U'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth <= 'tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth <= 'Un tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth <= 'V'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth <= 'U'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth > 'tokenised'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth > 'Un tokenised'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth > 'V'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth > 'U'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth >= 'tokenised'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth >= 'Un tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth >= 'V'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth >= 'U'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised = 'Un tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised <> 'tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised LIKE 'U_ to%sed'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised NOT LIKE 't__eni%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised IN ('Un tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised NOT IN ('Un tokenized')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised < 'tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised < 'Un tokenised'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised < 'V'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised < 'U'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised <= 'tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised <= 'Un tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised <= 'V'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised <= 'U'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised > 'tokenised'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised > 'Un tokenised'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised > 'V'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised > 'U'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised >= 'tokenised'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised >= 'Un tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised >= 'V'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised >= 'U'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised = 'tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised <> 'tokenized'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised LIKE 'to%sed'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised NOT LIKE 'Ut__eniz%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised IN ('tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised NOT IN ('tokenized')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias = 'Un tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias <> 'tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias LIKE 'U_ to%sed'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias NOT LIKE 't__eni%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias IN ('Un tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias NOT IN ('Un tokenized')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias = 'Un tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias <> 'tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias LIKE 'U_ to%sed'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias NOT LIKE 't__eni%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias IN ('Un tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias NOT IN ('Un tokenized')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias = 'tokenised'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias <> 'tokenized'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias LIKE 'to%sed'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'Ut__eniz%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias IN ('tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias NOT IN ('tokenized')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE 'Un tokenised' =  ANY cmistest:multipleTextBoth "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextBoth IN ('Un tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextBoth NOT IN ('Un tokenized')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE 'Un tokenised' =  ANY cmistest:multipleTextUntokenised "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextUntokenised IN ('Un tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextUntokenised NOT IN ('Un tokenized')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE 'tokenised' =  ANY cmistest:multipleTextTokenised "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextTokenised IN ('tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextTokenised NOT IN ('tokenized')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleTextBoth as alias FROM cmistest:extendedContent WHERE 'Un tokenised' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleTextBoth as alias FROM cmistest:extendedContent WHERE ANY alias IN ('Un tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleTextBoth as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN ('Un tokenized')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleTextUntokenised alias FROM cmistest:extendedContent WHERE 'Un tokenised' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleTextUntokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('Un tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleTextUntokenised alias FROM cmistest:extendedContent WHERE ANY alias NOT IN ('Un tokenized')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:multipleTextTokenised alias FROM cmistest:extendedContent T WHERE 'tokenised' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:multipleTextTokenised alias FROM cmistest:extendedContent T WHERE ANY alias IN ('tokenised', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT T.cmistest:multipleTextTokenised alias FROM cmistest:extendedContent T WHERE ANY alias NOT IN ('tokenized')"), this.expectedDocCount(1));
    }

    @Test
    public void checkDmltext() {
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'AAAA BBBB'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'AAAA'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = '%AAAA'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = '%AAA'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'BBBB'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'CCCC DDDD'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth <> 'EEEE FFFF'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth LIKE 'AAA_ B%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth LIKE 'CCC_ D%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth NOT LIKE 'B%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth NOT LIKE 'D%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth IN ('AAAA BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth IN ('CCCC DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth NOT IN ('EEEE FFFF')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised = 'AAAA BBBB'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised = 'CCCC DDDD'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised <> 'EEEE FFFF'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised LIKE 'AAA_ B%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised LIKE 'CCC_ D%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised NOT LIKE 'B%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised NOT LIKE 'D%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised IN ('AAAA BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised IN ('CCCC DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised NOT IN ('EEEE FFFF')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised = 'AAAA'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised = 'BBBB'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised = 'CCCC'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised = 'DDDD'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised <> 'EEEE'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised LIKE 'A%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised LIKE '_B__'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised LIKE '%C'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised LIKE 'D%D'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised NOT LIKE 'CCCC_'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised IN ('AAAA', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised IN ('BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised IN ('CCCC', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised IN ('DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised NOT IN ('EEEE')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias = 'AAAA BBBB'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias = 'AAAA'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias = 'BBBB'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias = 'CCCC DDDD'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias <> 'EEEE FFFF'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias LIKE 'AAA_ B%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias LIKE 'CCC_ D%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'B%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'D%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias IN ('AAAA BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias IN ('CCCC DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias NOT IN ('EEEE FFFF')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias = 'AAAA BBBB'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias = 'CCCC DDDD'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias <> 'EEEE FFFF'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias LIKE 'AAA_ B%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias LIKE 'CCC_ D%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'B%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'D%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias IN ('AAAA BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias IN ('CCCC DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias NOT IN ('EEEE FFFF')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias = 'AAAA'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias = 'BBBB'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias = 'CCCC'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias = 'DDDD'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias <> 'EEEE'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias LIKE 'A%'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias LIKE '_B__'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias LIKE '%C'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias LIKE 'D%D'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'CCCC_'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias IN ('AAAA', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias IN ('BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias IN ('CCCC', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias IN ('DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias NOT IN ('EEEE')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE 'AAAA BBBB' =  ANY cmistest:multipleMLTextBoth "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE 'CCCC DDDD' =  ANY cmistest:multipleMLTextBoth "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextBoth IN ('AAAA BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextBoth IN ('CCCC DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextBoth NOT IN ('EEEE FFFF')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE 'AAAA BBBB' =  ANY cmistest:multipleMLTextUntokenised "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE 'CCCC DDDD' =  ANY cmistest:multipleMLTextUntokenised "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextUntokenised IN ('AAAA BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextUntokenised IN ('CCCC DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextUntokenised NOT IN ('EEEE FFFF')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE 'AAAA' =  ANY cmistest:multipleMLTextTokenised "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE 'BBBB' =  ANY cmistest:multipleMLTextTokenised "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE 'CCCC' =  ANY cmistest:multipleMLTextTokenised "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE 'DDDD' =  ANY cmistest:multipleMLTextTokenised "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextTokenised IN ('AAAA', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextTokenised IN ('BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextTokenised IN ('CCCC', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextTokenised IN ('DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextTokenised NOT IN ('EEEE')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextBoth alias FROM cmistest:extendedContent WHERE 'AAAA BBBB' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextBoth alias FROM cmistest:extendedContent WHERE 'CCCC DDDD' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextBoth alias FROM cmistest:extendedContent WHERE ANY alias IN ('AAAA BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextBoth alias FROM cmistest:extendedContent WHERE ANY alias IN ('CCCC DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextBoth alias FROM cmistest:extendedContent WHERE ANY alias NOT IN ('EEEE FFFF')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextUntokenised alias FROM cmistest:extendedContent WHERE 'AAAA BBBB' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextUntokenised alias FROM cmistest:extendedContent WHERE 'CCCC DDDD' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextUntokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('AAAA BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextUntokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('CCCC DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextUntokenised alias FROM cmistest:extendedContent WHERE ANY alias NOT IN ('EEEE FFFF')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE 'AAAA' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE 'BBBB' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE 'CCCC' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE 'DDDD' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('AAAA', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('BBBB', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('CCCC', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('DDDD', 'Monkey')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE ANY alias NOT IN ('EEEE')"), this.expectedDocCount(1));
    }

    @Test
    public void checkDfloat() {
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat = 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat = 1.1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat <> 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat <> 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat < 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat < 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat <= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat <= 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat > 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat > 0.9"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat >= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat >= 0.9"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat NOT IN (1.1)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias = 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias = 1.1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias <> 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias <> 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias < 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias < 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias <= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias <= 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias > 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias > 0.9"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias >= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias >= 0.9"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias NOT IN (1.1)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE '1' =  ANY cmistest:multipleFloat "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE '1.1' =  ANY cmistest:multipleFloat "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleFloat IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleFloat IN (1.1, 2.2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleFloat NOT IN (1.1, 2.2)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleFloat NOT IN (1.3, 2.3)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE '1' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE '1.1' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE ANY alias IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE ANY alias IN (1.1, 2.2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1.1, 2.2)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1.3, 2.3)"), this.expectedDocCount(1));
    }

    @Test
    public void checkDdouble() {
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble = 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble = 1.1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble <> 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble <> 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble < 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble < 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble <= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble <= 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble > 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble > 0.9"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble >= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble >= 0.9"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble NOT IN (1.1)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias = 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias = 1.1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias <> 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias <> 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias < 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias < 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias <= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias <= 1.1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias > 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias > 0.9"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias >= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias >= 0.9"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias NOT IN (1.1)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE '1' =  ANY cmistest:multipleDouble "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE '1.1' =  ANY cmistest:multipleDouble "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDouble IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDouble IN (1.1, 2.2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDouble NOT IN (1.1, 2.2)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDouble NOT IN (1.3, 2.3)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE '1' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE '1.1' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE ANY alias IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE ANY alias IN (1.1, 2.2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1.1, 2.2)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1.3, 2.3)"), this.expectedDocCount(1));
    }

    @Test
    public void checkDint() {
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger = 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger = 2"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger <> 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger <> 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger < 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger < 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger <= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger <= 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger > 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger > 0"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger >= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger >= 0"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger NOT IN (2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias = 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias = 2"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias <> 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias <> 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias < 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias < 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias <= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias <= 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias > 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias > 0"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias >= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias >= 0"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias NOT IN (2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE '1' =  ANY cmistest:multipleInteger "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE '2' =  ANY cmistest:multipleInteger "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleInteger IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleInteger IN (2, 3)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleInteger NOT IN (1, 2)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleInteger NOT IN (2, 3)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleInteger NOT IN (3, 4)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE '1' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE '2' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE ANY alias IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE ANY alias IN (2, 3)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1, 2)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (2, 3)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (3, 4)"), this.expectedDocCount(1));
    }

    @Test
    public void checkDLong() {
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong = 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong = 2"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong <> 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong <> 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong < 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong < 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong <= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong <= 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong > 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong > 0"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong >= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong >= 0"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong NOT IN (2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias = 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias = 2"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias <> 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias <> 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias < 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias < 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias <= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias <= 2"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias > 1"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias > 0"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias >= 1"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias >= 0"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias NOT IN (2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE '1' =  ANY cmistest:multipleLong "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE '2' =  ANY cmistest:multipleLong "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleLong IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleLong IN (2, 3)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleLong NOT IN (1, 2)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleLong NOT IN (2, 3)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleLong NOT IN (3, 4)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE '1' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE '2' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE ANY alias IN (1, 2)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE ANY alias IN (2, 3)"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1, 2)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (2, 3)"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (3, 4)"), this.expectedDocCount(1));
    }

    @Test
    public void checkDdate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(testCMISDate00);
        cal.add(5, -1);
        Date date0 = cal.getTime();
        cal.add(5, 2);
        Date date2 = cal.getTime();
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent"), this.expectedDocCount(1));
        String d0 = ISO8601DateFormat.format((Date)date0);
        String d1 = ISO8601DateFormat.format((Date)testCMISDate00);
        String d2 = ISO8601DateFormat.format((Date)date2);
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate = TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate = TIMESTAMP '" + d2 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate <> TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate <> TIMESTAMP '" + d2 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate < TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate < TIMESTAMP '" + d2 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate <= TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate <= TIMESTAMP '" + d2 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate > TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate > TIMESTAMP '" + d0 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate >= TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate >= TIMESTAMP '" + d0 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate NOT IN (TIMESTAMP '" + d2 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias = TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias = TIMESTAMP '" + d2 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias <> TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias <> TIMESTAMP '" + d2 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias < TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias < TIMESTAMP '" + d2 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias <= TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias <= TIMESTAMP '" + d2 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias > TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias > TIMESTAMP '" + d0 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias >= TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias >= TIMESTAMP '" + d0 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias NOT IN (TIMESTAMP '" + d2 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY cmistest:multipleDate "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY cmistest:multipleDate "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDate IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDate IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDate NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDate NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDate NOT IN (TIMESTAMP '" + d0 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "')"), this.expectedDocCount(1));
    }

    public void check_D_datetime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(testCMISDate00);
        cal.add(5, -1);
        Date date0 = cal.getTime();
        cal.add(5, 2);
        Date date2 = cal.getTime();
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent"), this.expectedDocCount(1));
        String d0 = ISO8601DateFormat.format((Date)date0);
        String d1 = ISO8601DateFormat.format((Date)testCMISDate00);
        String d2 = ISO8601DateFormat.format((Date)date2);
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime = TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime = TIMESTAMP '" + d2 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime <> TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime <> TIMESTAMP '" + d2 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime < TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime < TIMESTAMP '" + d2 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime <= TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime <= TIMESTAMP '" + d2 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime > TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime > TIMESTAMP '" + d0 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime >= TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime >= TIMESTAMP '" + d0 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime NOT IN (TIMESTAMP '" + d2 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias = TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias = TIMESTAMP '" + d2 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias <> TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias <> TIMESTAMP '" + d2 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias < TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias < TIMESTAMP '" + d2 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias <= TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias <= TIMESTAMP '" + d2 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias > TIMESTAMP '" + d1 + "'"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias > TIMESTAMP '" + d0 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias >= TIMESTAMP '" + d1 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias >= TIMESTAMP '" + d0 + "'"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias NOT IN (TIMESTAMP '" + d2 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY cmistest:multipleDatetime "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY cmistest:multipleDatetime "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDatetime IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDatetime IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDatetime NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDatetime NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDatetime NOT IN (TIMESTAMP '" + d0 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "')"), this.expectedDocCount(1));
    }

    @Test
    public void checkDboolean() {
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleBoolean = TRUE"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleBoolean = true"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleBoolean = FALSE"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleBoolean = false"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleBoolean = TRue"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleBoolean alias FROM cmistest:extendedContent WHERE alias = TRUE"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleBoolean alias FROM cmistest:extendedContent WHERE alias = true"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleBoolean alias FROM cmistest:extendedContent WHERE alias = FALSE"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleBoolean alias FROM cmistest:extendedContent WHERE alias = false"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:singleBoolean alias FROM cmistest:extendedContent WHERE alias = TRue"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE '1' =  ANY cmistest:multipleBoolean "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE '2' =  ANY cmistest:multipleBoolean "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleBoolean as alias FROM cmistest:extendedContent WHERE '1' =  ANY alias "), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmistest:multipleBoolean as alias FROM cmistest:extendedContent WHERE '2' =  ANY alias "), this.expectedDocCount(1));
    }

    @Test
    public void checkContainsSyntax() {
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('quick')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('two')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('-quick')"), this.expectedDocCount(11));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('quick brown fox')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('quick two')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('quick -two')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('-quick two')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('-quick -two')"), this.expectedDocCount(10));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('fox brown quick')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('quick OR two')"), this.expectedDocCount(2));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('quick OR -two')"), this.expectedDocCount(11));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('-quick OR -two')"), this.expectedDocCount(12));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('\\'fox brown quick\\'')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('\\'quick brown fox\\' two')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('-\\'quick brown fox\\' two')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE CONTAINS('cmis:name:\\'Folder 9\\\\\\'\\'')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown two')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown AND two')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('quick OR (brown AND two)')"), this.expectedDocCount(1));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('(quick OR brown) AND two')"), this.expectedDocCount(0));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown OR two')"), this.expectedDocCount(2));
        CmisIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown two')"), this.expectedDocCount(1));
    }
}

