/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.ArrayList;
import java.util.Arrays;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AlfrescoSolrTrackerIT
extends AbstractAlfrescoSolrIT {
    private static Log logger = LogFactory.getLog(AlfrescoSolrTrackerIT.class);
    private static long MAX_WAIT_TIME = 80000L;

    @BeforeClass
    public static void beforeClass() throws Exception {
        AlfrescoSolrTrackerIT.initAlfrescoCore("schema.xml");
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void clearQueue() throws Exception {
        SOLRAPIQueueClient.NODE_META_DATA_MAP.clear();
        SOLRAPIQueueClient.TRANSACTION_QUEUE.clear();
        SOLRAPIQueueClient.ACL_CHANGE_SET_QUEUE.clear();
        SOLRAPIQueueClient.ACL_READERS_MAP.clear();
        SOLRAPIQueueClient.ACL_MAP.clear();
        SOLRAPIQueueClient.NODE_MAP.clear();
    }

    @Test
    public void testTrackers() throws Exception {
        int i;
        logger.info((Object)"######### Starting tracker test ###########");
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        Acl acl2 = AlfrescoSolrUtils.getAcl(aclChangeSet, 0x7FFFFFFFFFFFFFF5L);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, AlfrescoSolrUtils.list("joel"), AlfrescoSolrUtils.list("phil"), null);
        AclReaders aclReaders2 = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl2, AlfrescoSolrUtils.list("jim"), AlfrescoSolrUtils.list("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, AlfrescoSolrUtils.list(acl, acl2), AlfrescoSolrUtils.list(aclReaders, aclReaders2));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        AlfrescoSolrTrackerIT.waitForDocCount((Query)waitForQuery, 1L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed First Test ##############################");
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 2);
        Node folderNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        Node fileNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        Node errorNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        logger.info((Object)("######### error node:" + errorNode.getId()));
        NodeMetaData folderMetaData = AlfrescoSolrUtils.getNodeMetaData(folderNode, txn, acl, "mike", null, false);
        NodeMetaData fileMetaData = AlfrescoSolrUtils.getNodeMetaData(fileNode, txn, acl, "mike", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), false);
        NodeMetaData errorMetaData = AlfrescoSolrUtils.getNodeMetaData(errorNode, txn, acl, "lisa", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), true);
        AlfrescoSolrTrackerIT.indexTransaction(txn, AlfrescoSolrUtils.list(errorNode, folderNode, fileNode), AlfrescoSolrUtils.list(errorMetaData, folderMetaData, fileMetaData));
        logger.info((Object)"#################### Started Second Test ##############################");
        builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!TX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_TXID", (Long)txn.getId(), (Long)(txn.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        waitForQuery = builder.build();
        AlfrescoSolrTrackerIT.waitForDocCount((Query)waitForQuery, 1L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Second Test ##############################");
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("READER", "jim")), 1L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 2L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(fileNode.getId()))), 1L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Third Test ##############################");
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("q", new String[]{"t1:" + fileNode.getId()});
        params.add("qt", new String[]{"/afts"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        params.add("sort", new String[]{"id asc"});
        params.add("fq", new String[]{"{!afts}AUTHORITY_FILTER_FROM_JSON"});
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"joel\"], \"tenants\": [ \"\" ]}");
        AlfrescoSolrTrackerIT.assertQ((SolrQueryRequest)req, "*[count(//doc)=1]", "//result/doc[1]/long[@name='DBID'][.='" + fileNode.getId() + "']");
        logger.info((Object)"#################### Passed Fourth Test ##############################");
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("DOC_TYPE", "ErrorNode")), 1L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Fifth Test ##############################");
        Transaction txn1 = AlfrescoSolrUtils.getTransaction(0, 1);
        folderMetaData.getProperties().put(ContentModel.PROP_CASCADE_TX, new StringPropertyValue(Long.toString(txn1.getId())));
        folderNode.setTxnId(txn1.getId());
        folderMetaData.setTxnId(txn1.getId());
        NodeRef nodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), AlfrescoSolrUtils.createGUID());
        fileMetaData.setAncestors(AlfrescoSolrUtils.ancestors(nodeRef));
        logger.info((Object)"################### ADDING CASCADE TRANSACTION #################");
        AlfrescoSolrTrackerIT.indexTransaction(txn1, AlfrescoSolrUtils.list(folderNode), AlfrescoSolrUtils.list(folderMetaData));
        builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!TX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_TXID", (Long)txn1.getId(), (Long)(txn1.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        AlfrescoSolrTrackerIT.waitForDocCount((Query)builder.build(), 1L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Sixth Test ##############################");
        TermQuery termQuery1 = new TermQuery(new Term("ANCESTOR", nodeRef.toString()));
        AlfrescoSolrTrackerIT.waitForDocCount((Query)termQuery1, 1L, MAX_WAIT_TIME);
        params = new ModifiableSolrParams();
        params.add("q", new String[]{"ANCESTOR:\"" + nodeRef.toString() + "\""});
        params.add("qt", new String[]{"/afts"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        params.add("sort", new String[]{"id asc"});
        params.add("fq", new String[]{"{!afts}AUTHORITY_FILTER_FROM_JSON"});
        req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"mike\"], \"tenants\": [ \"\" ]}");
        AlfrescoSolrTrackerIT.assertQ((SolrQueryRequest)req, "*[count(//doc)=1]", "//result/doc[1]/long[@name='DBID'][.='" + fileNode.getId() + "']");
        logger.info((Object)"#################### Passed Seventh Test ##############################");
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 2L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Eighth Test ##############################");
        this.testIsContentIndexed(acl);
        Transaction txn2 = AlfrescoSolrUtils.getTransaction(0, 550);
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
        for (i = 0; i < 550; ++i) {
            Node n = AlfrescoSolrUtils.getNode(txn2, acl, Node.SolrApiNodeStatus.UPDATED);
            NodeMetaData nm = AlfrescoSolrUtils.getNodeMetaData(n, txn2, acl, "mike", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), false);
            nodes.add(n);
            nodeMetaDatas.add(nm);
        }
        logger.info((Object)("############################ Bulk Nodes:" + nodes.size()));
        AlfrescoSolrTrackerIT.indexTransaction(txn2, nodes, nodeMetaDatas);
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 552L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Ninth Test ##############################");
        for (i = 0; i < 1000; ++i) {
            Transaction txnX = AlfrescoSolrUtils.getTransaction(0, 1);
            ArrayList<Node> nodesX = new ArrayList<Node>();
            ArrayList<NodeMetaData> nodeMetaDatasX = new ArrayList<NodeMetaData>();
            Node n = AlfrescoSolrUtils.getNode(txnX, acl, Node.SolrApiNodeStatus.UPDATED);
            NodeMetaData nm = AlfrescoSolrUtils.getNodeMetaData(n, txnX, acl, "mike", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), false);
            nodesX.add(n);
            nodeMetaDatasX.add(nm);
            AlfrescoSolrTrackerIT.indexTransaction(txnX, nodesX, nodeMetaDatasX);
        }
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 1552L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Tenth Test ##############################");
        fileMetaData.setOwner("amy");
        AlfrescoSolrTrackerIT.reindexTransactionId(txn.getId());
        folderMetaData.setOwner("jill");
        this.reindexNodeId(folderNode.getId());
        builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)new TermQuery(new Term("OWNER", "amy")), BooleanClause.Occur.MUST));
        AlfrescoSolrTrackerIT.waitForDocCount((Query)builder.build(), 1L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Eleventh Test ##############################");
        builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)new TermQuery(new Term("OWNER", "jill")), BooleanClause.Occur.MUST));
        AlfrescoSolrTrackerIT.waitForDocCount((Query)builder.build(), 1L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Twelth Test ##############################");
        params = new ModifiableSolrParams();
        params.add("q", new String[]{"t1:" + fileNode.getId()});
        params.add("qt", new String[]{"/afts"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        params.add("sort", new String[]{"id asc"});
        params.add("fq", new String[]{"{!afts}AUTHORITY_FILTER_FROM_JSON"});
        req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"amy\"], \"tenants\": [ \"\" ]}");
        AlfrescoSolrTrackerIT.assertQ((SolrQueryRequest)req, "*[count(//doc)=1]", "//result/doc[1]/long[@name='DBID'][.='" + fileNode.getId() + "']");
        logger.info((Object)"#################### Passed Fourteenth Test ##############################");
        params = new ModifiableSolrParams();
        params.add("q", new String[]{"t1:" + folderNode.getId()});
        params.add("qt", new String[]{"/afts"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        params.add("sort", new String[]{"id asc"});
        params.add("fq", new String[]{"{!afts}AUTHORITY_FILTER_FROM_JSON"});
        req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"jill\"], \"tenants\": [ \"\" ]}");
        AlfrescoSolrTrackerIT.assertQ((SolrQueryRequest)req, "*[count(//doc)=1]", "//result/doc[1]/long[@name='DBID'][.='" + folderNode.getId() + "']");
        logger.info((Object)"#################### Passed Fifteenth Test ##############################");
        aclReaders.setReaders(Arrays.asList("andy"));
        this.indexAclId(acl.getId());
        aclReaders2.setReaders(Arrays.asList("ice"));
        this.reindexAclId(acl2.getId());
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("READER", "andy")), 1L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("READER", "ice")), 1L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("READER", "jim")), 0L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Sixteenth Test ##############################");
        params = new ModifiableSolrParams();
        params.add("q", new String[]{"t1:" + fileNode.getId()});
        params.add("qt", new String[]{"/afts"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        params.add("sort", new String[]{"id asc"});
        params.add("fq", new String[]{"{!afts}AUTHORITY_FILTER_FROM_JSON"});
        req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"andy\"], \"tenants\": [ \"\" ]}");
        logger.info((Object)"#################### Passed Seventeenth Test ##############################");
        aclReaders.setReaders(Arrays.asList("alan"));
        aclReaders2.setReaders(Arrays.asList("paul"));
        this.reindexAclChangeSetId(aclChangeSet.getId());
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("READER", "alan")), 1L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("READER", "paul")), 1L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("READER", "andy")), 0L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("READER", "ice")), 0L, MAX_WAIT_TIME);
        this.purgeAclId(acl2.getId());
        this.purgeNodeId(fileNode.getId());
        this.purgeTransactionId(txn2.getId());
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("READER", "paul")), 0L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(fileNode.getId()))), 0L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 1001L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Eighteenth Test ##############################");
        this.purgeAclChangeSetId(aclChangeSet.getId());
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("READER", "alan")), 0L, MAX_WAIT_TIME);
        errorMetaData.setNodeRef(new NodeRef(new StoreRef("workspace", "SpacesStore"), AlfrescoSolrUtils.createGUID()));
        logger.info((Object)"Retry the error node");
        this.retry();
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("DOC_TYPE", "ErrorNode")), 0L, MAX_WAIT_TIME);
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(errorNode.getId()))), 1L, MAX_WAIT_TIME);
        logger.info((Object)"#################### Passed Nineteenth Test ##############################");
    }

    private void testIsContentIndexed(Acl acl) throws Exception {
        int previousNumberOfDocuments = 2;
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 2L, MAX_WAIT_TIME);
        Transaction txnWithAspect = AlfrescoSolrUtils.getTransaction(0, 1);
        Node aspectNode = AlfrescoSolrUtils.getNode(txnWithAspect, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData aspectNodeMetaData = AlfrescoSolrUtils.getNodeMetaData(aspectNode, txnWithAspect, acl, "mike", null, false);
        aspectNodeMetaData.getAspects().add(ContentModel.ASPECT_INDEX_CONTROL);
        aspectNodeMetaData.getProperties().put(ContentModel.PROP_IS_INDEXED, new StringPropertyValue("true"));
        aspectNodeMetaData.getProperties().put(ContentModel.PROP_IS_CONTENT_INDEXED, new StringPropertyValue("false"));
        AlfrescoSolrTrackerIT.indexTransaction(txnWithAspect, AlfrescoSolrUtils.list(aspectNode), AlfrescoSolrUtils.list(aspectNodeMetaData));
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 2L, MAX_WAIT_TIME);
        Transaction txnContentIndexedFromTrueToFalse = AlfrescoSolrUtils.getTransaction(0, 1);
        aspectNodeMetaData.getProperties().put(ContentModel.PROP_IS_CONTENT_INDEXED, new StringPropertyValue("true"));
        AlfrescoSolrTrackerIT.indexTransaction(txnContentIndexedFromTrueToFalse, AlfrescoSolrUtils.list(aspectNode), AlfrescoSolrUtils.list(aspectNodeMetaData));
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 3L, MAX_WAIT_TIME);
        Transaction txnContentIndexedFromFalseToTrue = AlfrescoSolrUtils.getTransaction(0, 1);
        aspectNodeMetaData.getProperties().put(ContentModel.PROP_IS_CONTENT_INDEXED, new StringPropertyValue("false"));
        AlfrescoSolrTrackerIT.indexTransaction(txnContentIndexedFromFalseToTrue, AlfrescoSolrUtils.list(aspectNode), AlfrescoSolrUtils.list(aspectNodeMetaData));
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 2L, MAX_WAIT_TIME);
        Transaction txnDeleteContentIndexed = AlfrescoSolrUtils.getTransaction(1, 0);
        AlfrescoSolrTrackerIT.indexTransaction(txnDeleteContentIndexed, AlfrescoSolrUtils.list(aspectNode), AlfrescoSolrUtils.list(aspectNodeMetaData));
        AlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 2L, MAX_WAIT_TIME);
    }
}

