/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.SOLRAPIQueueClient;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

@LuceneTestCase.SuppressCodecs(value={"Appending", "Lucene3x", "Lucene40", "Lucene41", "Lucene42", "Lucene43", "Lucene44", "Lucene45", "Lucene46", "Lucene47", "Lucene48", "Lucene49"})
@SolrTestCaseJ4.SuppressSSL
public class CascadingIT
extends AbstractAlfrescoSolrIT {
    private static long MAX_WAIT_TIME = 80000L;
    private Node folderNode;
    private NodeMetaData childFolderMetaData;
    private Node childFolderNode;
    private NodeMetaData folderMetaData;
    private Node fileNode;
    private NodeMetaData fileMetaData;

    @BeforeClass
    public static void beforeClass() throws Exception {
        CascadingIT.initAlfrescoCore("schema.xml");
    }

    @Before
    public void indexTestData() throws Exception {
        Acl acl = this.getTestAcl();
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 3);
        this.folderNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        this.childFolderNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        this.fileNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        this.folderMetaData = AlfrescoSolrUtils.getNodeMetaData(this.folderNode, txn, acl, "mike", null, false);
        this.folderMetaData.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue("folder1"));
        this.childFolderMetaData = AlfrescoSolrUtils.getNodeMetaData(this.childFolderNode, txn, acl, "mike", AlfrescoSolrUtils.ancestors(this.folderMetaData.getNodeRef()), false);
        this.childFolderMetaData.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue("folder2"));
        this.fileMetaData = AlfrescoSolrUtils.getNodeMetaData(this.fileNode, txn, acl, "mike", AlfrescoSolrUtils.ancestors(this.folderMetaData.getNodeRef(), this.childFolderMetaData.getNodeRef()), false);
        this.fileMetaData.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue("file1"));
        this.upsertData(txn, Arrays.asList(this.folderNode, this.childFolderNode, this.fileNode), Arrays.asList(this.folderMetaData, this.childFolderMetaData, this.fileMetaData));
    }

    @Test
    public void solrTracking_folderUpdate_shouldReIndexFolderAndChildren() throws Exception {
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 1);
        this.folderMetaData.getProperties().put(ContentModel.PROP_CASCADE_TX, new StringPropertyValue(Long.toString(txn.getId())));
        this.folderMetaData.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue("folder2"));
        this.folderNode.setTxnId(txn.getId());
        this.folderMetaData.setTxnId(txn.getId());
        NodeRef nodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), AlfrescoSolrUtils.createGUID());
        this.childFolderMetaData.setAncestors(AlfrescoSolrUtils.ancestors(nodeRef));
        this.fileMetaData.setAncestors(AlfrescoSolrUtils.ancestors(nodeRef));
        this.upsertData(txn, Collections.singletonList(this.folderNode), Collections.singletonList(this.folderMetaData));
        TermQuery query = new TermQuery(new Term("ANCESTOR", nodeRef.toString()));
        CascadingIT.waitForDocCount((Query)query, 2L, MAX_WAIT_TIME);
        ModifiableSolrParams params = new ModifiableSolrParams().add("q", new String[]{"ANCESTOR:\"" + nodeRef.toString() + "\""}).add("qt", new String[]{"/afts"}).add("start", new String[]{"0"}).add("rows", new String[]{"6"}).add("sort", new String[]{"id asc"}).add("fq", new String[]{"{!afts}AUTHORITY_FILTER_FROM_JSON"});
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(params, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [ \"mike\"], \"tenants\": [ \"\" ]}");
        CascadingIT.assertQ((SolrQueryRequest)req, "*[count(//doc)=2]", "//result/doc[1]/long[@name='DBID'][.='" + this.childFolderNode.getId() + "']", "//result/doc[2]/long[@name='DBID'][.='" + this.fileNode.getId() + "']");
    }

    @After
    public void clearQueue() {
        SOLRAPIQueueClient.NODE_META_DATA_MAP.clear();
        SOLRAPIQueueClient.TRANSACTION_QUEUE.clear();
        SOLRAPIQueueClient.ACL_CHANGE_SET_QUEUE.clear();
        SOLRAPIQueueClient.ACL_READERS_MAP.clear();
        SOLRAPIQueueClient.ACL_MAP.clear();
        SOLRAPIQueueClient.NODE_MAP.clear();
    }

    private Acl getTestAcl() throws Exception {
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Collections.singletonList(acl), Collections.singletonList(aclReaders));
        BooleanQuery.Builder builder = new BooleanQuery.Builder().add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST)).add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        CascadingIT.waitForDocCount((Query)waitForQuery, 1L, MAX_WAIT_TIME);
        return acl;
    }

    private void upsertData(Transaction txn, List<Node> nodes, List<NodeMetaData> metadata) throws Exception {
        CascadingIT.indexTransaction(txn, nodes, metadata);
        BooleanQuery.Builder builder = new BooleanQuery.Builder().add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!TX")), BooleanClause.Occur.MUST)).add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_TXID", (Long)txn.getId(), (Long)(txn.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        CascadingIT.waitForDocCount((Query)waitForQuery, 1L, MAX_WAIT_TIME);
    }
}

