/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.ArrayList;
import java.util.Properties;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.SolrInformationServer;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.ContentTracker;
import org.alfresco.solr.tracker.Tracker;
import org.alfresco.solr.tracker.TrackerStats;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContentTrackerTest {
    private ContentTracker contentTracker;
    @Mock
    private SOLRAPIClient repositoryClient;
    private String coreName = "theCoreName";
    @Mock
    private SolrInformationServer srv;
    @Spy
    private Properties props;
    @Mock
    private TrackerStats trackerStats;
    private int UPDATE_BATCH = 2;

    @Before
    public void setUp() throws Exception {
        ((Properties)Mockito.doReturn((Object)"workspace://SpacesStore").when((Object)this.props)).getProperty((String)Mockito.eq((Object)"alfresco.stores"), Mockito.anyString());
        ((Properties)Mockito.doReturn((Object)("" + this.UPDATE_BATCH)).when((Object)this.props)).getProperty((String)Mockito.eq((Object)"alfresco.contentUpdateBatchSize"), Mockito.anyString());
        Mockito.when((Object)this.srv.getTrackerStats()).thenReturn((Object)this.trackerStats);
        this.contentTracker = new ContentTracker(this.props, this.repositoryClient, this.coreName, (InformationServer)this.srv);
    }

    @Test
    @Ignore(value="Superseded by AlfrescoSolrTrackerTest")
    public void doTrackWithNoContentDoesNothing() throws Exception {
        this.contentTracker.doTrack("anIterationId");
        ((SolrInformationServer)Mockito.verify((Object)this.srv, (VerificationMode)Mockito.never())).updateContent((AlfrescoSolrDataModel.TenantDbId)Mockito.any());
        ((SolrInformationServer)Mockito.verify((Object)this.srv, (VerificationMode)Mockito.never())).commit();
    }

    @Test
    @Ignore(value="Superseded by AlfrescoSolrTrackerTest")
    public void doTrackWithContentUpdatesContent() throws Exception {
        ArrayList<AlfrescoSolrDataModel.TenantDbId> docs1 = new ArrayList<AlfrescoSolrDataModel.TenantDbId>();
        ArrayList<AlfrescoSolrDataModel.TenantDbId> docs2 = new ArrayList<AlfrescoSolrDataModel.TenantDbId>();
        ArrayList emptyList = new ArrayList();
        for (int i = 0; i <= this.UPDATE_BATCH; ++i) {
            AlfrescoSolrDataModel.TenantDbId doc = new AlfrescoSolrDataModel.TenantDbId();
            doc.dbId = 1L;
            doc.tenant = "1";
            docs1.add(doc);
        }
        AlfrescoSolrDataModel.TenantDbId thirdDoc = (AlfrescoSolrDataModel.TenantDbId)docs1.get(this.UPDATE_BATCH);
        thirdDoc.dbId = 3L;
        thirdDoc.tenant = "3";
        for (long i = 0L; i < (long)this.UPDATE_BATCH; ++i) {
            AlfrescoSolrDataModel.TenantDbId doc = new AlfrescoSolrDataModel.TenantDbId();
            doc.dbId = 2L;
            doc.tenant = "2";
            docs2.add(doc);
        }
        Mockito.when((Object)this.srv.getDocsWithUncleanContent()).thenReturn(docs1).thenReturn(docs2).thenReturn(emptyList);
        this.contentTracker.doTrack("anIterationId");
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.srv});
        ((SolrInformationServer)order.verify((Object)this.srv)).getDocsWithUncleanContent();
        AlfrescoSolrDataModel.TenantDbId docRef = new AlfrescoSolrDataModel.TenantDbId();
        docRef.dbId = 1L;
        docRef.tenant = "1";
        ((SolrInformationServer)order.verify((Object)this.srv, Mockito.times((int)this.UPDATE_BATCH))).updateContent(docRef);
        ((SolrInformationServer)order.verify((Object)this.srv)).commit();
        ((SolrInformationServer)order.verify((Object)this.srv)).updateContent(thirdDoc);
        ((SolrInformationServer)order.verify((Object)this.srv)).commit();
        ((SolrInformationServer)order.verify((Object)this.srv)).getDocsWithUncleanContent();
        docRef = new AlfrescoSolrDataModel.TenantDbId();
        docRef.dbId = 2L;
        docRef.tenant = "2";
        ((SolrInformationServer)order.verify((Object)this.srv, Mockito.times((int)this.UPDATE_BATCH))).updateContent(docRef);
        ((SolrInformationServer)order.verify((Object)this.srv)).commit();
        ((SolrInformationServer)order.verify((Object)this.srv)).getDocsWithUncleanContent();
    }

    @Test
    public void typeCheck() {
        Assert.assertEquals((Object)this.contentTracker.getType(), (Object)Tracker.Type.CONTENT);
    }
}

