/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Properties;
import java.util.Random;
import java.util.stream.IntStream;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.solr.tracker.DocRouterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DBIDRangeRouterTest {
    private final Random randomizer = new Random();
    private DocRouter router;
    @Mock
    private Acl acl;
    @Mock
    private Node node;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Properties properties = new Properties();
        properties.put("shard.range", "200-20000");
        this.router = DocRouterFactory.getRouter((Properties)properties, (ShardMethodEnum)ShardMethodEnum.DB_ID_RANGE);
    }

    @Test
    public void aclsAreReplicatedAcrossShards() {
        IntStream.range(0, 100).forEach(index -> Assert.assertTrue((boolean)this.router.routeAcl(this.randomizer.nextInt(), this.randomizer.nextInt(), this.acl)));
    }

    @Test
    public void outOfBoundsShouldRejectTheNode() {
        Mockito.when((Object)this.node.getId()).thenReturn((Object)199L);
        Assert.assertFalse((boolean)this.router.routeNode(this.randomizer.nextInt(), this.randomizer.nextInt(), this.node));
        Mockito.when((Object)this.node.getId()).thenReturn((Object)20000L);
        Assert.assertFalse((boolean)this.router.routeNode(this.randomizer.nextInt(), this.randomizer.nextInt(), this.node));
    }

    @Test
    public void inRange_shouldAcceptTheNode() {
        Mockito.when((Object)this.node.getId()).thenReturn((Object)200L);
        Assert.assertTrue((boolean)this.router.routeNode(this.randomizer.nextInt(), this.randomizer.nextInt(), this.node));
        Mockito.when((Object)this.node.getId()).thenReturn((Object)543L);
        Assert.assertTrue((boolean)this.router.routeNode(this.randomizer.nextInt(), this.randomizer.nextInt(), this.node));
    }
}

