/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
@LuceneTestCase.SuppressCodecs(value={"Appending", "Lucene3x", "Lucene40", "Lucene41", "Lucene42", "Lucene43", "Lucene44", "Lucene45", "Lucene46", "Lucene47", "Lucene48", "Lucene49"})
public class DistributedAlfrescoSolrTrackerLargeTxnIdIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    private static void initData() throws Throwable {
        Properties properties = new Properties();
        properties.put("solr.initial.transaction.range", "0-9223372036854775807");
        DistributedAlfrescoSolrTrackerLargeTxnIdIT.initSolrServers(2, "DistributedAlfrescoSolrTrackerLargeTxnTest", properties);
    }

    @AfterClass
    private static void destroyData() {
        DistributedAlfrescoSolrTrackerLargeTxnIdIT.dismissSolrServers();
    }

    @Test
    public void testTracker() throws Exception {
        DistributedAlfrescoSolrTrackerLargeTxnIdIT.putHandleDefaults();
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        Acl acl2 = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AclReaders aclReaders2 = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl2, Collections.singletonList("jim"), Collections.singletonList("phil"), null);
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 2);
        long txnCommitTimeMs = txn.getCommitTimeMs();
        long backdatedCommitTimeMs = txnCommitTimeMs - 4600000L;
        txn.setCommitTimeMs(backdatedCommitTimeMs);
        Node folderNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        Node fileNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        Node errorNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData folderMetaData = AlfrescoSolrUtils.getNodeMetaData(folderNode, txn, acl, "mike", null, false);
        NodeMetaData fileMetaData = AlfrescoSolrUtils.getNodeMetaData(fileNode, txn, acl, "mike", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), false);
        NodeMetaData errorMetaData = AlfrescoSolrUtils.getNodeMetaData(errorNode, txn, acl, "lisa", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), true);
        DistributedAlfrescoSolrTrackerLargeTxnIdIT.indexTransaction(txn, Arrays.asList(errorNode, folderNode, fileNode), Arrays.asList(errorMetaData, folderMetaData, fileMetaData));
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Arrays.asList(acl, acl2), Arrays.asList(aclReaders, aclReaders2));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        DistributedAlfrescoSolrTrackerLargeTxnIdIT.waitForDocCountAllCores((Query)waitForQuery, 1, 80000L);
    }
}

