/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Arrays;
import java.util.Collections;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedAlfrescoSolrTrackerRaceIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        DistributedAlfrescoSolrTrackerRaceIT.initSolrServers(2, "DistributedAlfrescoSolrTrackerRaceIT", null);
    }

    @AfterClass
    public static void destroyData() {
        DistributedAlfrescoSolrTrackerRaceIT.dismissSolrServers();
    }

    @Test
    public void testTracker() throws Exception {
        DistributedAlfrescoSolrTrackerRaceIT.putHandleDefaults();
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(2, 1L, System.currentTimeMillis() - 2764800000L);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        Acl acl2 = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AclReaders aclReaders2 = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl2, Collections.singletonList("jim"), Collections.singletonList("phil"), null);
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 2, 1L, System.currentTimeMillis() - 2764800000L);
        Node folderNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        Node fileNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        Node errorNode = AlfrescoSolrUtils.getNode(txn, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData folderMetaData = AlfrescoSolrUtils.getNodeMetaData(folderNode, txn, acl, "mike", null, false);
        NodeMetaData fileMetaData = AlfrescoSolrUtils.getNodeMetaData(fileNode, txn, acl, "mike", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), false);
        NodeMetaData errorMetaData = AlfrescoSolrUtils.getNodeMetaData(errorNode, txn, acl, "lisa", AlfrescoSolrUtils.ancestors(folderMetaData.getNodeRef()), true);
        DistributedAlfrescoSolrTrackerRaceIT.indexTransaction(txn, Arrays.asList(errorNode, folderNode, fileNode), Arrays.asList(errorMetaData, folderMetaData, fileMetaData));
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Arrays.asList(acl, acl2), Arrays.asList(aclReaders, aclReaders2));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        DistributedAlfrescoSolrTrackerRaceIT.waitForDocCountAllCores((Query)waitForQuery, 1, 100000L);
        DistributedAlfrescoSolrTrackerRaceIT.waitForDocCountAllCores((Query)new TermQuery(new Term("READER", "jim")), 1, 100000L);
        DistributedAlfrescoSolrTrackerRaceIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 2, 100000L);
        DistributedAlfrescoSolrTrackerRaceIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(folderNode.getId()))), 1, 100000L);
        DistributedAlfrescoSolrTrackerRaceIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(fileNode.getId()))), 1, 100000L);
        DistributedAlfrescoSolrTrackerRaceIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", Long.toString(errorNode.getId()))), 0, 100000L);
        this.query(DistributedAlfrescoSolrTrackerRaceIT.getDefaultTestClient(), true, "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}]}", DistributedAlfrescoSolrTrackerRaceIT.params((String[])new String[]{"q", "t1:world", "qt", "/afts", "shards.qt", "/afts", "start", "0", "rows", "6", "sort", "id asc"}));
    }
}

