/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.response.SolrQueryResponse;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class DistributedExpandDbidRangeAlfrescoSolrTrackerIT
extends AbstractAlfrescoDistributedIT {
    @BeforeClass
    public static void initData() throws Throwable {
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.initSolrServers(2, DistributedExpandDbidRangeAlfrescoSolrTrackerIT.getSimpleClassName(), DistributedExpandDbidRangeAlfrescoSolrTrackerIT.getShardMethod());
        Thread.sleep(10000L);
    }

    @AfterClass
    public static void destroyData() {
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.dismissSolrServers();
    }

    @Test
    public void testDbIdRange() throws Exception {
        NodeMetaData nodeMetaData;
        Node node;
        int aclIndex;
        int i;
        NodeMetaData nodeMetaData2;
        Node node2;
        int aclIndex2;
        int i2;
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.putHandleDefaults();
        int numAcls = 250;
        AclChangeSet bulkAclChangeSet = AlfrescoSolrUtils.getAclChangeSet(numAcls);
        ArrayList<Acl> bulkAcls = new ArrayList<Acl>();
        ArrayList<AclReaders> bulkAclReaders = new ArrayList<AclReaders>();
        for (int i3 = 0; i3 < numAcls; ++i3) {
            Acl bulkAcl = AlfrescoSolrUtils.getAcl(bulkAclChangeSet);
            bulkAcls.add(bulkAcl);
            bulkAclReaders.add(AlfrescoSolrUtils.getAclReaders(bulkAclChangeSet, bulkAcl, Collections.singletonList("joel" + bulkAcl.getId()), Collections.singletonList("phil" + bulkAcl.getId()), null));
        }
        AlfrescoSolrUtils.indexAclChangeSet(bulkAclChangeSet, bulkAcls, bulkAclReaders);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)bulkAclChangeSet.getId(), (Long)(bulkAclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.waitForDocCount((Query)waitForQuery, 1, AlfrescoSolrUtils.MAX_WAIT_TIME);
        SolrQueryResponse response0 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(0);
        NamedList values0 = response0.getValues();
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("start")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("end")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("nodeCount")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("minDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("maxDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("expand")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values0.get("expanded")));
        System.out.println("RANGECHECK0:" + String.valueOf(values0));
        SolrQueryResponse response1 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(1);
        NamedList values1 = response1.getValues();
        System.out.println("RANGECHECK1:" + String.valueOf(values1));
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("start")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("end")), (long)200L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("nodeCount")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("minDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("maxDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("expand")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values1.get("expanded")));
        int numNodes = 25;
        ArrayList<Object> nodes = new ArrayList<Node>();
        ArrayList<Object> nodeMetaDatas = new ArrayList<NodeMetaData>();
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (i2 = 0; i2 < numNodes; ++i2) {
            aclIndex2 = i2 % numAcls;
            node2 = AlfrescoSolrUtils.getNode(i2, bigTxn, (Acl)bulkAcls.get(aclIndex2), Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node2);
            nodeMetaData2 = AlfrescoSolrUtils.getNodeMetaData(node2, bigTxn, (Acl)bulkAcls.get(aclIndex2), "mike", null, false);
            nodeMetaDatas.add(nodeMetaData2);
        }
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes, 100000L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.waitForDocCountAllCores((Query)new TermQuery(new Term("DOC_TYPE", "Acl")), numAcls, 80000L);
        response0 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(0);
        values0 = response0.getValues();
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("start")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("end")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("nodeCount")), (long)25L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("minDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("maxDbid")), (long)24L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("expand")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values0.get("expanded")));
        System.out.println("_RANGECHECK0:" + String.valueOf(values0));
        response1 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(1);
        values1 = response1.getValues();
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("start")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("end")), (long)200L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("nodeCount")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("minDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("maxDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("expand")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values1.get("expanded")));
        numNodes = 26;
        nodes = new ArrayList();
        nodeMetaDatas = new ArrayList();
        bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (i2 = 0; i2 < numNodes; ++i2) {
            aclIndex2 = i2 % numAcls;
            node2 = AlfrescoSolrUtils.getNode((long)i2 + 35L, bigTxn, (Acl)bulkAcls.get(aclIndex2), Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node2);
            nodeMetaData2 = AlfrescoSolrUtils.getNodeMetaData(node2, bigTxn, (Acl)bulkAcls.get(aclIndex2), "mike", null, false);
            nodeMetaDatas.add(nodeMetaData2);
        }
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 51, 100000L);
        response0 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(0);
        values0 = response0.getValues();
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("start")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("end")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("nodeCount")), (long)51L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("minDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("maxDbid")), (long)60L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((double)((Double)values0.get("density")), (double)0.85, (double)0.0);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("expand")), (long)17L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values0.get("expanded")));
        System.out.println("_RANGECHECK0:" + String.valueOf(values0));
        response1 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(1);
        values1 = response1.getValues();
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("start")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("end")), (long)200L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("nodeCount")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("minDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("maxDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("expand")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values1.get("expanded")));
        System.out.println("_RANGECHECK1:" + String.valueOf(values1));
        numNodes = 5;
        nodes = new ArrayList();
        nodeMetaDatas = new ArrayList();
        bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (i2 = 0; i2 < numNodes; ++i2) {
            aclIndex2 = i2 % numAcls;
            node2 = AlfrescoSolrUtils.getNode((long)i2 + 72L, bigTxn, (Acl)bulkAcls.get(aclIndex2), Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node2);
            nodeMetaData2 = AlfrescoSolrUtils.getNodeMetaData(node2, bigTxn, (Acl)bulkAcls.get(aclIndex2), "mike", null, false);
            nodeMetaDatas.add(nodeMetaData2);
        }
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 56, 100000L);
        response0 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(0);
        values0 = response0.getValues();
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("start")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("end")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("nodeCount")), (long)56L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("minDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("maxDbid")), (long)76L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((double)((Double)values0.get("density")), (double)0.7368421052631579, (double)0.0);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("expand")), (long)-1L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values0.get("expanded")));
        SolrQueryResponse expandResponse = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.expand(0, 35);
        NamedList expandValues = expandResponse.getValues();
        String ex = (String)expandValues.get("exception");
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((Object)ex, (Object)"Expansion cannot occur if max DBID in the index is more then 75% of range.");
        Number expanded = (Number)expandValues.get("expand");
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)expanded.intValue(), (long)-1L);
        System.out.println("_RANGECHECK0:" + String.valueOf(values0));
        response1 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(1);
        values1 = response1.getValues();
        System.out.println("_RANGECHECK1:" + String.valueOf(values1));
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("start")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("end")), (long)200L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("nodeCount")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("minDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("maxDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("expand")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values1.get("expanded")));
        numNodes = 5;
        nodes = new ArrayList();
        nodeMetaDatas = new ArrayList();
        bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (i = 0; i < numNodes; ++i) {
            aclIndex = i % numAcls;
            node = AlfrescoSolrUtils.getNode((long)i + 100L, bigTxn, (Acl)bulkAcls.get(aclIndex), Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, (Acl)bulkAcls.get(aclIndex), "mike", null, false);
            nodeMetaDatas.add(nodeMetaData);
        }
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 61, 100000L);
        response0 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(0);
        values0 = response0.getValues();
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("start")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("end")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("nodeCount")), (long)56L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("minDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("maxDbid")), (long)76L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((double)((Double)values0.get("density")), (double)0.7368421052631579, (double)0.0);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("expand")), (long)-1L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values0.get("expanded")));
        response1 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(1);
        values1 = response1.getValues();
        System.out.println("_RANGECHECK1:" + String.valueOf(values1));
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("start")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("end")), (long)200L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("nodeCount")), (long)5L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("minDbid")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("maxDbid")), (long)104L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("expand")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values1.get("expanded")));
        numNodes = 35;
        nodes = new ArrayList();
        nodeMetaDatas = new ArrayList();
        bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (i = 0; i < numNodes; ++i) {
            aclIndex = i % numAcls;
            node = AlfrescoSolrUtils.getNode((long)i + 120L, bigTxn, (Acl)bulkAcls.get(aclIndex), Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, (Acl)bulkAcls.get(aclIndex), "mike", null, false);
            nodeMetaDatas.add(nodeMetaData);
        }
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 96, 100000L);
        response0 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(0);
        values0 = response0.getValues();
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("start")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("end")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("nodeCount")), (long)56L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("minDbid")), (long)0L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("maxDbid")), (long)76L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((double)((Double)values0.get("density")), (double)0.7368421052631579, (double)0.0);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values0.get("expand")), (long)-1L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values0.get("expanded")));
        response1 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(1);
        values1 = response1.getValues();
        System.out.println("_RANGECHECK1:" + String.valueOf(values1));
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("start")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("end")), (long)200L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("nodeCount")), (long)40L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("minDbid")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("maxDbid")), (long)154L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((double)((Double)values1.get("density")), (double)0.7407407407407407, (double)0.0);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("expand")), (long)35L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertFalse((boolean)((Boolean)values1.get("expanded")));
        expandResponse = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.expand(1, 35);
        expandValues = expandResponse.getValues();
        expanded = (Number)expandValues.get("expand");
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)expanded.intValue(), (long)235L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.waitForShardsCount((Query)new TermQuery(new Term("id", "TRACKER!STATE!CAP")), 1, 100000L, System.currentTimeMillis());
        response1 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(1);
        values1 = response1.getValues();
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("start")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("end")), (long)235L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("nodeCount")), (long)40L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("minDbid")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("maxDbid")), (long)154L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((double)((Double)values1.get("density")), (double)0.7407407407407407, (double)0.0);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("expand")), (long)-1L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertTrue((boolean)((Boolean)values1.get("expanded")));
        numNodes = 3;
        nodes = new ArrayList();
        nodeMetaDatas = new ArrayList();
        bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        for (i = 0; i < numNodes; ++i) {
            aclIndex = i % numAcls;
            node = AlfrescoSolrUtils.getNode((long)i + 230L, bigTxn, (Acl)bulkAcls.get(aclIndex), Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, (Acl)bulkAcls.get(aclIndex), "mike", null, false);
            nodeMetaDatas.add(nodeMetaData);
        }
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), 99, 100000L);
        response1 = DistributedExpandDbidRangeAlfrescoSolrTrackerIT.rangeCheck(1);
        values1 = response1.getValues();
        System.out.println("_RANGECHECK1:" + String.valueOf(values1));
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("start")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("end")), (long)235L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("nodeCount")), (long)43L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("minDbid")), (long)100L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("maxDbid")), (long)232L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((double)((Double)values1.get("density")), (double)0.32575757575757575, (double)0.0);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertEquals((long)((Long)values1.get("expand")), (long)-1L);
        DistributedExpandDbidRangeAlfrescoSolrTrackerIT.assertTrue((boolean)((Boolean)values1.get("expanded")));
    }

    protected static Properties getShardMethod() {
        Properties prop = new Properties();
        prop.put("shard.method", "DB_ID_RANGE");
        return prop;
    }
}

