/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.apache.solr.SolrTestCaseJ4;
import org.carrot2.shaded.guava.common.collect.ImmutableList;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
@SolrTestCaseJ4.SuppressObjectReleaseTracker(bugUrl="RAMDirectory")
public class DistributedExplicitShardIdWithStaticPropertyRouterIT
extends AbstractAlfrescoDistributedIT {
    private final int timeout = 100000;

    @Before
    public void initData() throws Throwable {
        DistributedExplicitShardIdWithStaticPropertyRouterIT.initSolrServers(2, DistributedExplicitShardIdWithStaticPropertyRouterIT.getSimpleClassName(), DistributedExplicitShardIdWithStaticPropertyRouterIT.getProperties());
        this.indexData();
    }

    @AfterClass
    public static void destroyData() {
        DistributedExplicitShardIdWithStaticPropertyRouterIT.dismissSolrServers();
    }

    private void indexData() throws Exception {
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, (List<Acl>)ImmutableList.of((Object)acl), (List<AclReaders>)ImmutableList.of((Object)aclReaders));
        this.indexTestData(acl);
    }

    public void indexTestData(Acl acl) throws Exception {
        Transaction txn = AlfrescoSolrUtils.getTransaction(0, 3);
        Node node1 = AlfrescoSolrUtils.getNode(0L, txn, acl, Node.SolrApiNodeStatus.UPDATED);
        node1.setExplicitShardId(Integer.valueOf(0));
        NodeMetaData nodeMetaData1 = AlfrescoSolrUtils.getNodeMetaData(node1, txn, acl, "elia", null, false);
        nodeMetaData1.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue("first"));
        Node node2 = AlfrescoSolrUtils.getNode(1L, txn, acl, Node.SolrApiNodeStatus.UPDATED);
        node2.setExplicitShardId(Integer.valueOf(1));
        NodeMetaData nodeMetaData2 = AlfrescoSolrUtils.getNodeMetaData(node2, txn, acl, "elia", null, false);
        nodeMetaData2.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue("second"));
        Node node3 = AlfrescoSolrUtils.getNode(2L, txn, acl, Node.SolrApiNodeStatus.UPDATED);
        NodeMetaData nodeMetaData3 = AlfrescoSolrUtils.getNodeMetaData(node3, txn, acl, "elia", null, false);
        nodeMetaData3.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue("third"));
        Node node4 = AlfrescoSolrUtils.getNode(3L, txn, acl, Node.SolrApiNodeStatus.UPDATED);
        node4.setExplicitShardId(Integer.valueOf(1));
        NodeMetaData nodeMetaData4 = AlfrescoSolrUtils.getNodeMetaData(node4, txn, acl, "elia", null, false);
        nodeMetaData4.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue("forth"));
        Node node5 = AlfrescoSolrUtils.getNode(4L, txn, acl, Node.SolrApiNodeStatus.UPDATED);
        node5.setExplicitShardId(Integer.valueOf(4));
        NodeMetaData nodeMetaData5 = AlfrescoSolrUtils.getNodeMetaData(node5, txn, acl, "elia", null, false);
        nodeMetaData5.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue("fifth"));
        DistributedExplicitShardIdWithStaticPropertyRouterIT.indexTransaction(txn, (List<Node>)ImmutableList.of((Object)node1, (Object)node2, (Object)node3, (Object)node4, (Object)node5), (List<NodeMetaData>)ImmutableList.of((Object)nodeMetaData1, (Object)nodeMetaData2, (Object)nodeMetaData3, (Object)nodeMetaData4, (Object)nodeMetaData5));
        DistributedExplicitShardIdWithStaticPropertyRouterIT.waitForShardsCount(DistributedExplicitShardIdWithStaticPropertyRouterIT.params((String[])new String[]{"q", "cm:content:world", "qt", "/afts"}), 3, 100000L, System.currentTimeMillis());
    }

    @Test
    public void testNodesShouldBeIndexedInSpecifiedShard() throws Exception {
        DistributedExplicitShardIdWithStaticPropertyRouterIT.assertShardCount(0, DistributedExplicitShardIdWithStaticPropertyRouterIT.params((String[])new String[]{"q", "cm:content:world", "qt", "/afts"}), 1);
        DistributedExplicitShardIdWithStaticPropertyRouterIT.assertShardCount(1, DistributedExplicitShardIdWithStaticPropertyRouterIT.params((String[])new String[]{"q", "cm:content:world", "qt", "/afts"}), 2);
        DistributedExplicitShardIdWithStaticPropertyRouterIT.assertShardCount(0, DistributedExplicitShardIdWithStaticPropertyRouterIT.params((String[])new String[]{"q", "cm:name:first", "qt", "/afts", "shards", shards}), 1);
        DistributedExplicitShardIdWithStaticPropertyRouterIT.assertShardCount(0, DistributedExplicitShardIdWithStaticPropertyRouterIT.params((String[])new String[]{"q", "cm:name:third", "qt", "/afts", "shards", shards}), 0);
        DistributedExplicitShardIdWithStaticPropertyRouterIT.assertShardCount(0, DistributedExplicitShardIdWithStaticPropertyRouterIT.params((String[])new String[]{"q", "cm:name:fifth", "qt", "/afts", "shards", shards}), 0);
    }

    protected static Properties getProperties() {
        Properties prop = new Properties();
        prop.put("shard.method", ShardMethodEnum.LAST_REGISTERED_INDEXING_SHARD.toString());
        return prop;
    }
}

