/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.client.AlfrescoModelDiff;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.ModelTracker;
import org.alfresco.solr.tracker.TrackerStats;
import org.json.JSONException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ModelTrackerIT {
    private ModelTracker modelTracker;
    @Mock
    private SOLRAPIClient repositoryClient;
    private String coreName = "theCoreName";
    @Mock
    private InformationServer srv;
    @Mock
    private Properties props;
    @Mock
    private TrackerStats trackerStats;
    private static File alfrescoModelDir;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        alfrescoModelDir = new File("target/testalfrescoModels");
        alfrescoModelDir.mkdir();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        try {
            File[] listFiles;
            for (File file : listFiles = alfrescoModelDir.listFiles()) {
                file.delete();
            }
            alfrescoModelDir.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.props.getProperty("alfresco.stores", "workspace://SpacesStore")).thenReturn((Object)"workspace://SpacesStore");
        Mockito.when((Object)this.props.getProperty("alfresco.batch.count", "5000")).thenReturn((Object)"5000");
        Mockito.when((Object)this.props.getProperty("alfresco.maxLiveSearchers", "2")).thenReturn((Object)"2");
        Mockito.when((Object)this.props.getProperty("shard.count", "1")).thenReturn((Object)"1");
        Mockito.when((Object)this.props.getProperty("shard.instance", "0")).thenReturn((Object)"0");
        Mockito.when((Object)this.srv.getTrackerStats()).thenReturn((Object)this.trackerStats);
        System.setProperty("solr.model.dir", alfrescoModelDir.getAbsolutePath());
        this.modelTracker = new ModelTracker(null, this.props, this.repositoryClient, this.coreName, this.srv);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testDoTrack() throws AuthenticationException, IOException, JSONException {
        ModelTracker spiedModelTracker = (ModelTracker)Mockito.spy((Object)this.modelTracker);
        spiedModelTracker.doTrack("AnIterationId");
        ((InformationServer)Mockito.verify((Object)this.srv)).getRegisteredSearcherCount();
        ((ModelTracker)Mockito.verify((Object)spiedModelTracker)).trackModels(false);
    }

    @Test
    public void testTrackModels() throws AuthenticationException, IOException, JSONException {
        String name = this.setUpTestTrackModels();
        this.modelTracker.trackModels(false);
        this.verifyTestTrackModels(name);
    }

    private void verifyTestTrackModels(final String name) {
        ((InformationServer)Mockito.verify((Object)this.srv)).afterInitModels();
        Assert.assertTrue((boolean)alfrescoModelDir.isDirectory());
        File[] modelRepresentations = alfrescoModelDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(name);
            }
        });
        Assert.assertEquals((long)1L, (long)modelRepresentations.length);
    }

    private String setUpTestTrackModels() throws AuthenticationException, IOException, JSONException {
        QName modelName = QName.createQName((String)"qname");
        AlfrescoModelDiff.TYPE type = AlfrescoModelDiff.TYPE.CHANGED;
        Long oldChecksum = new Long(0L);
        Long newChecksum = new Long(1L);
        AlfrescoModelDiff diff = new AlfrescoModelDiff(modelName, type, oldChecksum, newChecksum);
        ArrayList<AlfrescoModelDiff> modelDiffs = new ArrayList<AlfrescoModelDiff>();
        modelDiffs.add(diff);
        Mockito.when((Object)this.repositoryClient.getModelsDiff((String)ArgumentMatchers.any(String.class), (List)ArgumentMatchers.any(List.class))).thenReturn(modelDiffs);
        String name = "a model name";
        M2Model model = M2Model.createModel((String)"a model name");
        M2Model spiedModel = (M2Model)Mockito.spy((Object)model);
        model.createNamespace("uri", "prefix");
        AlfrescoModel alfrescoModel = new AlfrescoModel(spiedModel, newChecksum);
        Mockito.when((Object)this.repositoryClient.getModel((String)ArgumentMatchers.any(String.class), (QName)ArgumentMatchers.eq((Object)modelName))).thenReturn((Object)alfrescoModel);
        NamespaceDAO namespaceDao = (NamespaceDAO)Mockito.mock(NamespaceDAO.class);
        ArrayList<String> values = new ArrayList<String>();
        values.add("prefix");
        Mockito.when((Object)namespaceDao.getPrefixes(ArgumentMatchers.anyString())).thenReturn(values);
        Mockito.when((Object)this.srv.getNamespaceDAO()).thenReturn((Object)namespaceDao);
        Mockito.when((Object)this.srv.getM2Model(modelName)).thenReturn((Object)spiedModel);
        Mockito.when((Object)this.srv.putModel(spiedModel)).thenReturn((Object)true);
        return "a model name";
    }

    @Test
    public void testEnsureFirstModelSync() throws AuthenticationException, IOException, JSONException {
        String name = this.setUpTestTrackModels();
        this.modelTracker.ensureFirstModelSync();
        this.verifyTestTrackModels(name);
    }
}

