/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;

public class CachingTermPositions
extends PostingsEnum {
    int[] results;
    int position = -1;
    int last = -1;
    PostingsEnum delegate;

    public CachingTermPositions(PostingsEnum delegate) {
        this.delegate = delegate;
    }

    public int nextPosition() throws IOException {
        if (this.results == null) {
            this.results = new int[this.freq()];
        }
        ++this.position;
        if (this.last < this.position) {
            this.results[this.position] = this.delegate.nextPosition();
            this.last = this.position;
        }
        return this.results[this.position];
    }

    public void reset() {
        this.position = -1;
    }

    private void clear() {
        this.position = -1;
        this.last = -1;
        this.results = null;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public int freq() throws IOException {
        return this.delegate.freq();
    }

    public int startOffset() throws IOException {
        return this.delegate.startOffset();
    }

    public int endOffset() throws IOException {
        return this.delegate.endOffset();
    }

    public int docID() {
        return this.delegate.docID();
    }

    public BytesRef getPayload() throws IOException {
        return this.delegate.getPayload();
    }

    public AttributeSource attributes() {
        return this.delegate.attributes();
    }

    public int nextDoc() throws IOException {
        int nextDoc = this.delegate.nextDoc();
        this.clear();
        return nextDoc;
    }

    public int advance(int target) throws IOException {
        int nextDoc = this.delegate.advance(target);
        this.clear();
        return nextDoc;
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public long cost() {
        return this.delegate.cost();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

