/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.Set;
import org.alfresco.solr.query.AbstractAuthorityQuery;
import org.alfresco.solr.query.AbstractAuthorityQueryWeight;
import org.alfresco.solr.query.SolrReaderScorer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrReaderQuery
extends AbstractAuthorityQuery {
    public SolrReaderQuery(String authority) {
        super(authority);
    }

    @Override
    public String toString(String field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("READER").append(':');
        stringBuilder.append(this.authority);
        return stringBuilder.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScore) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        return new SolrReaderQueryWeight((SolrIndexSearcher)searcher, this, this.authority);
    }

    private class SolrReaderQueryWeight
    extends AbstractAuthorityQueryWeight {
        public SolrReaderQueryWeight(SolrIndexSearcher searcher, Query query, String reader) throws IOException {
            super(searcher, false, query, "READER", reader);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return SolrReaderScorer.createReaderScorer(this, context, this.searcher, SolrReaderQuery.this.authority);
        }

        public void extractTerms(Set<Term> terms) {
            terms.add(new Term("READER", SolrReaderQuery.this.authority));
        }
    }
}

