/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.Set;
import org.alfresco.solr.query.AbstractAuthorityQueryWeight;
import org.alfresco.solr.query.AbstractAuthoritySetQuery;
import org.alfresco.solr.query.SolrReaderSetScorer2;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrReaderSetQuery
extends AbstractAuthoritySetQuery {
    public SolrReaderSetQuery(String authorities) {
        super(authorities);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScore) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        return new SolrReaderSetQueryWeight((SolrIndexSearcher)searcher, this, this.authorities);
    }

    @Override
    public String toString(String field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("READERSET").append(':');
        stringBuilder.append(this.authorities);
        return stringBuilder.toString();
    }

    private class SolrReaderSetQueryWeight
    extends AbstractAuthorityQueryWeight {
        public SolrReaderSetQueryWeight(SolrIndexSearcher searcher, Query query, String readers) throws IOException {
            super(searcher, false, query, "READERSET", readers);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            LeafReader reader = context.reader();
            return SolrReaderSetScorer2.createReaderSetScorer(this, context, this.searcher, SolrReaderSetQuery.this.authorities, reader);
        }

        public void extractTerms(Set<Term> terms) {
            terms.add(new Term("READERSET", SolrReaderSetQuery.this.authorities));
        }
    }
}

