/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.text.Collator;
import java.util.Locale;
import org.alfresco.solr.AlfrescoCollatableMLTextFieldType;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AlfrescoCollatableMLTextFieldTypeTest {
    private static final int NUM_HITS = 3;
    private static final String FIELD = "field";
    private static final Locale LOCALE = Locale.getDefault();
    private static final int DOC = 0;
    private static final String BOTTOM_STRING = "Bottom";
    @InjectMocks
    AlfrescoCollatableMLTextFieldType.MLTextSortFieldComparator textSortFieldComparator = new AlfrescoCollatableMLTextFieldType.MLTextSortFieldComparator(3, "field", LOCALE);
    @Mock
    BinaryDocValues mockDocTerms;
    @Mock
    Bits mockDocsWithField;
    @Mock
    Collator mockCollator;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.reset((Object[])new Object[]{this.mockDocTerms, this.mockDocsWithField});
        this.textSortFieldComparator.bottom = BOTTOM_STRING;
    }

    @Test
    public void testCompareBottom_termLengthZeroAndDocDoesntHaveField() {
        Mockito.when((Object)this.mockDocTerms.get(0)).thenReturn((Object)new BytesRef());
        Mockito.when((Object)this.mockDocsWithField.get(0)).thenReturn((Object)false);
        int result = this.textSortFieldComparator.compareBottom(0);
        Assert.assertEquals((String)"Expected value for doc to be null, and so it to be sorted before BOTTOM_TERM", (long)1L, (long)result);
    }

    @Test
    public void testCompareBottom_nullDocsWithField() {
        Bits oldValue = this.textSortFieldComparator.docsWithField;
        this.textSortFieldComparator.docsWithField = null;
        Mockito.when((Object)this.mockDocTerms.get(0)).thenReturn((Object)new BytesRef());
        this.textSortFieldComparator.compareBottom(0);
        ((Collator)Mockito.verify((Object)this.mockCollator)).compare(BOTTOM_STRING, "");
        this.textSortFieldComparator.docsWithField = oldValue;
    }

    @Test
    public void testCompareBottom_populatedTerm() {
        Mockito.when((Object)this.mockDocTerms.get(0)).thenReturn((Object)new BytesRef((CharSequence)"Some value"));
        Mockito.when((Object)this.mockDocsWithField.get(0)).thenReturn((Object)false);
        this.textSortFieldComparator.compareBottom(0);
        ((Collator)Mockito.verify((Object)this.mockCollator)).compare(BOTTOM_STRING, "Some value");
    }

    @Test
    public void testCompareBottom_encodedTerm_localeFound() {
        String mlText = "\u0000ru\u0000First\u0000Ignored\u0000en_US\u0000Second\u0000IgnoredToo\u0000th_TH_TH\u0000Third\u0000AlsoIgnored";
        Mockito.when((Object)this.mockDocTerms.get(0)).thenReturn((Object)new BytesRef((CharSequence)mlText));
        Mockito.when((Object)this.mockDocsWithField.get(0)).thenReturn((Object)false);
        this.textSortFieldComparator.collatorLocale = Locale.forLanguageTag("ru");
        this.textSortFieldComparator.compareBottom(0);
        ((Collator)Mockito.verify((Object)this.mockCollator)).compare(BOTTOM_STRING, "First");
        this.textSortFieldComparator.collatorLocale = Locale.forLanguageTag("en");
        this.textSortFieldComparator.compareBottom(0);
        ((Collator)Mockito.verify((Object)this.mockCollator)).compare(BOTTOM_STRING, "Second");
        this.textSortFieldComparator.collatorLocale = Locale.forLanguageTag("th");
        this.textSortFieldComparator.compareBottom(0);
        ((Collator)Mockito.verify((Object)this.mockCollator)).compare(BOTTOM_STRING, "Third");
        this.textSortFieldComparator.collatorLocale = LOCALE;
    }

    @Test
    public void testCompareBottom_badlyEncodedTerm() {
        String mlText = "\u0000ru";
        Mockito.when((Object)this.mockDocTerms.get(0)).thenReturn((Object)new BytesRef((CharSequence)mlText));
        this.textSortFieldComparator.compareBottom(0);
        ((Collator)Mockito.verify((Object)this.mockCollator)).compare(BOTTOM_STRING, "");
    }

    @Test
    public void testCompareValues_nullLessThanString() {
        int result = this.textSortFieldComparator.compareValues(null, "NotNull");
        Assert.assertEquals((String)"Expected null to be 'less' than string.", (long)-1L, (long)result);
    }

    @Test
    public void testCompareValues_stringGreaterThanNull() {
        int result = this.textSortFieldComparator.compareValues("NotNull", null);
        Assert.assertEquals((String)"Expected string to be 'greater' than null.", (long)1L, (long)result);
    }

    @Test
    public void testCompareValues_nullEqualToNull() {
        int result = this.textSortFieldComparator.compareValues(null, null);
        Assert.assertEquals((String)"Expected two null values to be equal.", (long)0L, (long)result);
    }

    @Test
    public void testCompareValues_twoStringsCompared() {
        int comparisonResult = 10;
        Mockito.when((Object)this.mockCollator.compare("NotNull1", "NotNull2")).thenReturn((Object)comparisonResult);
        int result = this.textSortFieldComparator.compareValues("NotNull1", "NotNull2");
        ((Collator)Mockito.verify((Object)this.mockCollator)).compare("NotNull1", "NotNull2");
        Assert.assertEquals((String)"Expected result to be obtained from collator.", (long)comparisonResult, (long)result);
    }
}

